/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class LabelService {
    private static final Log LOGGER = LogFactory.getLog(LabelService.class);

    public static int getLabelResultCount(Long labelObjectId, Long labelId, Map<String, Object> filters) {
        return (Integer)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelResultCount", (Object[])new Object[]{labelObjectId, labelId, filters});
    }

    public static Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int start, int pageSize) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelResult", (Object[])new Object[]{labelObjectId, labelId, filters, start, pageSize});
    }

    public static Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int pageSize, Object[] objSortValues) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelResult", (Object[])new Object[]{labelObjectId, labelId, filters, 0, pageSize, objSortValues});
    }

    public static Map<Object, Object> queryModelLabelValues(Long labelId, int topN) {
        ArrayList<Long> labelIds = new ArrayList<Long>(1);
        labelIds.add(labelId);
        return LabelService.queryModelLabelValues(labelIds, topN);
    }

    public static Map<Object, Object> queryModelLabelValues(List<Long> labelIds, int topN) {
        HashMap<String, List<Long>> filters = new HashMap<String, List<Long>>(1);
        filters.put("labelIds", labelIds);
        LOGGER.info("queryModelLabelValues labelIds:{}", labelIds);
        Map labelRespMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabels", (Object[])new Object[]{"1", "C", filters, 0, topN});
        if (labelRespMap == null || labelRespMap.isEmpty()) {
            return Collections.emptyMap();
        }
        List resultList = (List)labelRespMap.get("resultList");
        if (resultList == null || resultList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> labelValueMap = new HashMap<Object, Object>(1);
        for (Map labelInfo : resultList) {
            try {
                List labelValueList = (List)labelInfo.get("labelValues");
                for (Map labelValueInfo : labelValueList) {
                    Long labelValueId = (Long)labelValueInfo.get("labelValueId");
                    Map labelValueName = (Map)labelValueInfo.get("labelValueName");
                    labelValueMap.put(labelValueId, LabelService.getLodcalString(labelValueName));
                }
            }
            catch (Exception exception) {
                LOGGER.warn("queryModelLabelValues exception, labelInfo:{}", (Object)labelInfo);
            }
        }
        return labelValueMap;
    }

    private static String getLodcalString(Map<String, String> localVal) {
        String val = localVal.get(Lang.get().toString());
        if (val == null && (val = localVal.get("GLang")) == null) {
            val = localVal.get(Lang.zh_CN.toString());
        }
        return val;
    }
}

