/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import org.apache.commons.lang.StringUtils;

public class MultipleLabelFilterFunction
implements Function<QFilter, QFilter> {
    private static final Log LOGGER = LogFactory.getLog(MultipleLabelFilterFunction.class);
    private final HRComplexObjContext complexObjContext;

    public MultipleLabelFilterFunction(HRComplexObjContext complexObjContext) {
        this.complexObjContext = complexObjContext;
    }

    @Override
    public QFilter apply(QFilter qFilter) {
        String multipleLabelViewId = LabelFieldUtil.getMultipleLabelViewId(qFilter.getProperty());
        if (HRStringUtils.isEmpty((String)multipleLabelViewId)) {
            return qFilter;
        }
        String[] entityLabelArr = multipleLabelViewId.split(",");
        QFilter resultQFilter = null;
        for (String entityLabel : entityLabelArr) {
            String[] split = entityLabel.split("\\.");
            if (split.length == 2 && StringUtils.isNumeric((String)split[1])) {
                String prex = "";
                if (!split[0].equals(this.complexObjContext.getEntityNumber())) {
                    prex = split[0] + '.';
                }
                long labelPk = Long.parseLong(split[1]);
                String labelAlias = prex + "label_" + labelPk;
                if (resultQFilter == null) {
                    resultQFilter = new QFilter(labelAlias, qFilter.getCP(), qFilter.getValue());
                    continue;
                }
                resultQFilter.or(new QFilter(labelAlias, qFilter.getCP(), qFilter.getValue()));
                continue;
            }
            LOGGER.warn("multipleLabelViewId error,entityLabel:{}, qfilter:{}", (Object)entityLabel, (Object)qFilter);
        }
        return resultQFilter;
    }
}

