/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;

public class QFilterESTransFunction
implements Function<QFilter, QFilter> {
    private static Log LOGGER = LogFactory.getLog(QFilterESTransFunction.class);
    private final HRComplexObjContext context;
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public QFilterESTransFunction(HRComplexObjContext context) {
        this.context = context;
    }

    @Override
    public QFilter apply(QFilter filter) {
        boolean isLabelField = LabelFieldUtil.isLabelField(filter.getProperty());
        if (isLabelField) {
            return filter;
        }
        if ("ftlike".equals(filter.getCP())) {
            filter.__setCP("like");
        }
        if (filter.toString().equalsIgnoreCase("1 != 1")) {
            return filter;
        }
        if (filter.getProperty().equals("1")) {
            return filter;
        }
        QFilterUtil.convertPermQFilterEx((QFilter)filter, (HRComplexObjContext)this.context, (MainEntityTypeUtil)this.mainEntityTypeUtil);
        String entityName = QFilterUtil.getSubEntityName((String)filter.getProperty(), (HRComplexObjContext)this.context);
        if (entityName == null) {
            entityName = this.context.getEntityNumber();
        }
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(entityName);
        IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)entityType, (String)filter.getProperty());
        try {
            this.processSpecialFilter(filter, fieldProperty);
        }
        catch (Exception er) {
            LOGGER.error((Throwable)er);
        }
        return filter;
    }

    private void processSpecialFilter(QFilter filter, IDataEntityProperty property) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Collection cl;
        String[] nameKeys;
        if (filter.getCP().equalsIgnoreCase("not exists") && filter.getValue().toString().equalsIgnoreCase("1 = 1")) {
            filter.__setCP("=");
            filter.__setValue((Object)0L);
            return;
        }
        if (property instanceof ILocaleProperty) {
            String langStr = RequestContext.get().getLang().name();
            filter.__setProperty(filter.getProperty() + "_l." + langStr);
        } else if (property instanceof BooleanProp) {
            if (filter.getValue() instanceof Collection) {
                List values = (List)filter.getValue();
                ArrayList<Boolean> bolVals = new ArrayList<Boolean>(values.size());
                for (String val : values) {
                    bolVals.add(val.equals("1"));
                }
                filter.__setValue(bolVals);
            } else {
                filter.__setValue((Object)"1".equals(String.valueOf(filter.getValue())));
            }
        }
        if (property instanceof ComboProp || property instanceof DateTimeProp || property instanceof TimeProp) {
            filter.__setProperty(filter.getProperty() + "_store_value4es");
        }
        if ((nameKeys = filter.getProperty().split("\\."))[nameKeys.length - 1].equalsIgnoreCase("id")) {
            if (null != filter.getValue() && filter.getValue() instanceof QEmptyValue) {
                if (property instanceof BasedataProp) {
                    IDataEntityProperty refIdProp = ((BasedataProp)property).getRefIdProp();
                    if (refIdProp instanceof LongProp) {
                        this.resetFilter(filter, QFilterUtil.hrEmptyDecimal);
                    } else if (refIdProp instanceof VarcharProp) {
                        this.resetFilter(filter, QFilterUtil.hrEmptyText);
                    } else {
                        filter.__setCP("is null");
                    }
                } else {
                    filter.__setCP("is null");
                }
            }
        } else if (filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            if (property instanceof DecimalProp) {
                this.resetFilter(filter, QFilterUtil.hrEmptyDecimal);
            } else if (property instanceof TextProp) {
                this.resetFilter(filter, QFilterUtil.hrEmptyFieldText);
            } else {
                filter.__setCP("is null");
            }
        }
        if (filter.getCP().equalsIgnoreCase("in") && filter.getValue() == null) {
            filter.__setCP("is null");
        }
        if (filter.getValue() != null && filter.getValue() instanceof Collection && (cl = (Collection)filter.getValue()).isEmpty()) {
            filter.__setCP("is null");
        }
    }

    private void resetFilter(QFilter filter, String cp) throws NoSuchFieldException, IllegalAccessException {
        kd.hr.hbp.business.service.query.util.QFilterESTransFunction.resetFilter((QFilter)filter, (String)cp);
    }
}

