/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.List;
import java.util.function.Function;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hrmp.hrss.business.domain.search.service.es.SmartSearchEsEsStorage;
import kd.hrmp.hrss.business.domain.search.service.query.CustomQFilterFunction;
import kd.hrmp.hrss.business.domain.search.service.query.EsFilterFieldTransfer;
import kd.hrmp.hrss.business.domain.search.service.query.MultipleLabelFilterFunction;
import kd.hrmp.hrss.business.domain.search.service.query.QFilterESTransFunction;
import kd.hrmp.hrss.business.domain.search.service.query.SingleLabelFilterFunction;
import org.elasticsearch.index.query.QueryBuilder;

public class QFilterQueryBuilder {
    public static QueryBuilder getQueryBuilder(Long sceneId, HRComplexObjContext complexObjContext, QFilter[] qFilters) {
        if (qFilters == null || qFilters.length == 0) {
            return null;
        }
        QFilter[] qFiltersCopy = QFilterQueryBuilder.copyQFilters(qFilters);
        CustomQFilterFunction customQFilterFunction = new CustomQFilterFunction(sceneId);
        MultipleLabelFilterFunction labelFilterFunction = new MultipleLabelFilterFunction(complexObjContext);
        SingleLabelFilterFunction singleLabelFilterFunction = new SingleLabelFilterFunction();
        QFilterESTransFunction sqltf = new QFilterESTransFunction(complexObjContext);
        int n = qFiltersCopy.length;
        for (int i = 0; i < n; ++i) {
            QFilter qFilter = qFiltersCopy[i];
            if (qFilter == null) continue;
            qFiltersCopy[i] = qFiltersCopy[i].trans((Function)customQFilterFunction);
            qFiltersCopy[i] = qFiltersCopy[i].trans((Function)labelFilterFunction);
            qFiltersCopy[i] = qFiltersCopy[i].trans((Function)sqltf);
            qFiltersCopy[i] = qFiltersCopy[i].trans((Function)singleLabelFilterFunction);
        }
        EsFilterFieldTransfer esFilterFieldTransfer = new EsFilterFieldTransfer();
        List<EsFilterField> esFilterFields = esFilterFieldTransfer.transferQFilter(complexObjContext, qFiltersCopy);
        SmartSearchEsEsStorage esStorage = new SmartSearchEsEsStorage();
        return esStorage.buidQueryBuilder(esFilterFields);
    }

    private static QFilter[] copyQFilters(QFilter[] filterArray) {
        QFilter[] filterArrayCopy = new QFilter[filterArray.length];
        for (int j = 0; j < filterArray.length; ++j) {
            if (filterArray[j] == null) continue;
            filterArrayCopy[j] = filterArray[j].copy();
        }
        return filterArrayCopy;
    }
}

