/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import org.apache.commons.collections.CollectionUtils;

public class SearchObjQueryService {
    private static final Log LOGGER = LogFactory.getLog(SearchObjQueryService.class);

    public static long queryDataCount(HRComplexObjContext complexObjCont) {
        ReportQueryService reportQueryService = new ReportQueryService(complexObjCont);
        return reportQueryService.queryDataCount(0, -1);
    }

    public static List<Map<String, Object>> queryListMap(HRComplexObjContext complexObjCont, List<Object> idList, int exceptionSiize) {
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        LOGGER.info("query list data by HRComplexObjContext, idsize:{}", (Object)idList.size());
        complexObjCont.getQfilterList().add(new QFilter("id", "in", idList));
        complexObjCont.setTransferField(true);
        complexObjCont.setRouteByPrivacy(false);
        complexObjCont.setAlgoXDetailOptimize(false);
        ReportQueryService reportQueryService = new ReportQueryService(complexObjCont);
        LOGGER.info("queryDataSet filter{}", (Object)complexObjCont.getQfilterList());
        List dataList = reportQueryService.queryMap(0, exceptionSiize);
        if (dataList.size() > exceptionSiize - 1) {
            Object maxDataKey = null;
            Long dataSize = 0L;
            Map.Entry maxDataMapEntry = dataList.parallelStream().collect(Collectors.groupingBy(map -> map.get("id"), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).orElse(null);
            if (maxDataMapEntry != null) {
                maxDataKey = maxDataMapEntry.getKey();
                dataSize = (Long)maxDataMapEntry.getValue();
            }
            LOGGER.warn("queryException data too large,mainId:{},size:{}", maxDataKey, (Object)dataSize);
            throw new KDBizException("queryException data too large,mainId:" + maxDataKey + ",dataSize:" + dataSize);
        }
        return dataList;
    }

    public static List<Object> queryFieldValues(HRComplexObjContext context) {
        ReportQueryService reportQueryService = new ReportQueryService(context);
        List dataList = reportQueryService.queryMap();
        return dataList.stream().map(map -> map.get("id")).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

