/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchTargetTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.SearchParamUtil;
import kd.hrmp.hrss.business.domain.search.service.query.ISearchBuilderItemService;
import kd.hrmp.hrss.business.domain.search.service.query.QFilterQueryBuilder;
import kd.hrmp.hrss.business.domain.search.service.query.SearchBuilderFactory;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightService;
import kd.hrmp.hrss.common.model.search.GptAndDslBo;
import kd.hrmp.hrss.common.model.search.InputFilterAnalysisRst;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class SearchQBuilderService {
    private static final Log LOGGER = LogFactory.getLog(SearchQBuilderService.class);

    public GptAndDslBo genKeyWordSearchBuilder(SearchParam searchParam, HRComplexObjContext complexObjContext) {
        GptAndDslBo gptAndDslBo;
        String searchContent = SearchParamUtil.getSearchContent(searchParam);
        LOGGER.info("DO_SEARCH_LOGgenKeyWordSearchBuilder searchContent:{}", (Object)searchContent);
        if (HRStringUtils.isEmpty((String)searchContent)) {
            gptAndDslBo = null;
        } else {
            InputFilterAnalysisRst inputFilterAnalysisRst = SearchWeightService.getInstance().getSearchWeightConfList(searchContent, searchParam.getSceneId(), searchParam.getPageId());
            BoolQueryBuilder smartSearchQueryBuilder = this.genSmartSearchQueryBuilder(complexObjContext, searchParam, inputFilterAnalysisRst);
            gptAndDslBo = new GptAndDslBo((QueryBuilder)smartSearchQueryBuilder, inputFilterAnalysisRst);
            if (inputFilterAnalysisRst == null || inputFilterAnalysisRst.getGptFilterResult() == null) {
                LOGGER.info("full text search add labelTxT");
                gptAndDslBo.setInputQueryBuilder(this.addAllLabelQueryBuilder(gptAndDslBo.getInputQueryBuilder(), searchParam));
            }
        }
        return gptAndDslBo;
    }

    public QueryBuilder assemblyKeyWordAndQFilter(Long sceneId, HRComplexObjContext complexObjContext, BoolQueryBuilder queryBuilder, QFilter[] qFilters) {
        QueryBuilder qfilterQueryBuilder;
        if (queryBuilder != null) {
            queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder);
        }
        if ((qfilterQueryBuilder = QFilterQueryBuilder.getQueryBuilder(sceneId, complexObjContext, qFilters)) != null) {
            LOGGER.info("SEARCH_DSL_QFilterQueryBuilder:{}", (Object)qfilterQueryBuilder);
            if (queryBuilder == null) {
                return QueryBuilders.constantScoreQuery((QueryBuilder)qfilterQueryBuilder);
            }
            queryBuilder.filter(qfilterQueryBuilder);
        }
        return queryBuilder;
    }

    private BoolQueryBuilder genSmartSearchQueryBuilder(HRComplexObjContext complexObjContext, SearchParam searchParam, InputFilterAnalysisRst inputFilterAnalysisRst) {
        SearchTargetTypeEnum searchTargetType = searchParam.getSearchTargetType();
        ISearchBuilderItemService searchBuilderService = SearchBuilderFactory.getSearchBuilderService(searchTargetType);
        BoolQueryBuilder queryBuilder = searchBuilderService.createSearchBuilder(searchParam, complexObjContext, inputFilterAnalysisRst);
        return queryBuilder;
    }

    private QueryBuilder addAllLabelQueryBuilder(QueryBuilder queryBuilder, SearchParam searchParam) {
        if (searchParam.getSearchTargetType() != null) {
            return queryBuilder;
        }
        SearchKeyLogicEnum searchKeyLogic = searchParam.getSearchKeyLogic();
        SearchCategoryEnum searchCategory = searchParam.getCategory();
        QueryBuilder labelQueryBuilder = null;
        List<String> searchContentList = SearchParamUtil.getSearchContentList(searchParam);
        if (searchContentList.isEmpty()) {
            return queryBuilder;
        }
        if (searchContentList.size() == 1) {
            labelQueryBuilder = this.genAllLabelQueryBuilder(searchCategory, searchContentList.get(0));
        } else {
            BoolQueryBuilder boolQueryBuilder = null;
            for (String searchKey : searchContentList) {
                if (HRStringUtils.isEmpty((String)searchKey)) continue;
                if (boolQueryBuilder == null) {
                    boolQueryBuilder = QueryBuilders.boolQuery();
                }
                QueryBuilder tmpQueryBuilder = this.genAllLabelQueryBuilder(searchCategory, searchKey);
                if (searchKeyLogic == SearchKeyLogicEnum.AND) {
                    boolQueryBuilder.must(tmpQueryBuilder);
                    continue;
                }
                boolQueryBuilder.should(tmpQueryBuilder);
            }
            labelQueryBuilder = boolQueryBuilder;
        }
        if (labelQueryBuilder == null) {
            return queryBuilder;
        }
        if (queryBuilder == null) {
            return QueryBuilders.boolQuery().should(labelQueryBuilder);
        }
        BoolQueryBuilder rstQueryBuilder = QueryBuilders.boolQuery();
        labelQueryBuilder.boost(3.0f);
        LOGGER.info("SEARCH_DSL_AllLabelQueryBuilder:{}", (Object)labelQueryBuilder);
        queryBuilder.boost(7.0f);
        rstQueryBuilder.should(queryBuilder).should(labelQueryBuilder);
        return rstQueryBuilder;
    }

    private QueryBuilder genAllLabelQueryBuilder(SearchCategoryEnum searchCategory, String searchKey) {
        if (searchCategory == SearchCategoryEnum.PHRASE_SEARCH) {
            return QueryBuilders.matchPhraseQuery((String)"all_label_val_txt", (Object)searchKey);
        }
        return QueryBuilders.matchQuery((String)"all_label_val_txt", (Object)searchKey);
    }
}

