/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchlog;

import java.util.List;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hrmp.hrss.business.domain.search.service.searchscene.SearchSceneBusQueryService;

public class CustomQFilterViewFunction
implements Function<QFilter, QFilter> {
    private final Long sceneId;
    private DynamicObject sceneDyo;
    private static final Log LOGGER = LogFactory.getLog(CustomQFilterViewFunction.class);

    public CustomQFilterViewFunction(Long sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public QFilter apply(QFilter qFilter) {
        String property = qFilter.getProperty();
        if (!property.contains("$")) {
            return qFilter;
        }
        String[] split = property.split("\\$");
        if (split.length != 2) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        String fieldAlias = split[0];
        DynamicObject curSceneDyo = this.getSceneDyo();
        DynamicObjectCollection searchFilterColl = curSceneDyo.getDynamicObjectCollection("filterentryentity");
        DynamicObject searchFilterDyo = searchFilterColl.stream().filter(dyo -> dyo.getDynamicObject("customfilter") != null && fieldAlias.equals(dyo.getString("searchobjfield.fieldalias"))).findAny().orElse(null);
        if (searchFilterDyo == null) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        DynamicObject customFilterDyo = searchFilterDyo.getDynamicObject("customfilter");
        String customFieldKey = split[1];
        List<SearchCustomFilterBo> customFilterList = SearchSceneBusQueryService.genCustomFilterList(customFilterDyo.getLong("id"));
        SearchCustomFilterBo customFilter = customFilterList.stream().filter(cf -> cf.getKey().equals(customFieldKey)).findAny().orElse(null);
        if (customFilter == null) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        qFilter.__setValue((Object)customFilter.getName());
        return qFilter;
    }

    private DynamicObject getSceneDyo() {
        if (this.sceneDyo == null) {
            this.sceneDyo = SearchSceneBusQueryService.loadSceneConf(this.sceneId);
        }
        return this.sceneDyo;
    }
}

