/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.searchlog.CustomQFilterViewFunction;
import kd.hrmp.hrss.business.domain.search.service.searchlog.QCPTitleEnum;

public class QFilterSaveLogHelper {
    public static String qfilterArrSerializedString(QFilter[] qFilters) {
        if (qFilters == null) {
            return "[]";
        }
        Object[] strArr = new String[qFilters.length];
        for (int i = 0; i < qFilters.length; ++i) {
            QFilter qFilter = qFilters[i];
            if (qFilter == null) continue;
            strArr[i] = qFilter.toSerializedString();
        }
        return Arrays.toString(strArr);
    }

    public static String qfilterArrTransString(Long sceneId, QFilter[] qFilters, List<SearchFieldBo> allSearchFieldList) {
        if (qFilters == null) {
            return "";
        }
        QFilter[] copyFilter = QFilterSaveLogHelper.copyQFilters(qFilters);
        QFilterSaveLogHelper.qFilterPropTransView(sceneId, copyFilter, allSearchFieldList);
        StringBuilder qFilterSb = new StringBuilder();
        for (int i = 0; i < copyFilter.length; ++i) {
            QFilter qFilter = copyFilter[i];
            if (qFilter == null) continue;
            qFilterSb.append(QFilterSaveLogHelper.qFilterToViewString(qFilter, QFilterUtilHR::parametertoString));
            if (i >= copyFilter.length - 1) continue;
            qFilterSb.append(" ");
            qFilterSb.append(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"QFilterSaveLogHelper_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            qFilterSb.append("\r\n");
        }
        return qFilterSb.toString();
    }

    private static void qFilterPropTransView(Long sceneId, QFilter[] copyFilter, List<SearchFieldBo> allSearchFieldList) {
        Map<String, String> searchFieldMap = allSearchFieldList.stream().collect(Collectors.toMap(SearchFieldBo::getFieldAlias, SearchFieldBo::getDisplayName, (d1, d2) -> d1));
        CustomQFilterViewFunction cqf = new CustomQFilterViewFunction(sceneId);
        int n = copyFilter.length;
        for (int i = 0; i < n; ++i) {
            if (copyFilter[i] == null) continue;
            copyFilter[i] = copyFilter[i].trans((Function)cqf);
        }
        String customFilterPrex = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u9879#", (String)"QFilterSaveLogHelper_3", (String)"hrmp-hrss-business", (Object[])new Object[0]);
        for (int i = 0; i < copyFilter.length; ++i) {
            QFilter qFilter = copyFilter[i];
            if (qFilter == null) continue;
            QFilterSaveLogHelper.resetQFilterProp(searchFieldMap, customFilterPrex, qFilter);
        }
    }

    private static void resetQFilterProp(Map<String, String> searchFieldMap, String customFilterPrex, QFilter qFilter) {
        String displayName;
        String property = qFilter.getProperty();
        boolean addPrex = false;
        if (property.contains("$")) {
            String[] split = property.split("\\$");
            property = split[0];
            addPrex = true;
        }
        if (HRStringUtils.isNotEmpty((String)(displayName = searchFieldMap.get(property)))) {
            if (addPrex) {
                displayName = customFilterPrex + displayName;
            }
            qFilter.__setProperty(displayName);
        }
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QFilterSaveLogHelper.resetQFilterProp(searchFieldMap, customFilterPrex, nest.getFilter());
        }
    }

    private static String qFilterToViewString(QFilter qFilter, Function<Object, String> param2StringFnc) {
        StringBuilder qFilterSb = new StringBuilder(128);
        if (qFilter.isJoinSQLFilter()) {
            qFilterSb.append(qFilter.getProperty());
        } else {
            String cpName = QCPTitleEnum.getName(qFilter.getCP());
            if (HRStringUtils.isEmpty((String)cpName)) {
                cpName = qFilter.getCP();
            }
            qFilterSb.append(qFilter.getProperty()).append(' ').append(cpName);
            Object value = qFilter.getValue();
            if (!qFilter.isExpressValue()) {
                value = ORMUtil.isContains((QFilterHint)qFilter.getQFilterHint()) || ORMUtil.isNotContains((QFilterHint)qFilter.getQFilterHint()) ? "'%" + value + "%'" : (ORMUtil.isStartWith((QFilterHint)qFilter.getQFilterHint()) ? "'" + value + "%'" : (ORMUtil.isEndWith((QFilterHint)qFilter.getQFilterHint()) ? "'%" + value + "'" : param2StringFnc.apply(value)));
            }
            if (qFilter.getCP().equalsIgnoreCase("in") || qFilter.getCP().equalsIgnoreCase("not in")) {
                qFilterSb.append(" (").append(value).append(')');
            } else {
                qFilterSb.append(' ').append(value);
            }
        }
        List nests = qFilter.getNests(false);
        if (!nests.isEmpty()) {
            QFilterSaveLogHelper.resolveNests(nests, qFilterSb, nest -> {
                String opStr = nest.isAnd() ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"QFilterSaveLogHelper_0", (String)"hrmp-hrss-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"QFilterSaveLogHelper_1", (String)"hrmp-hrss-business", (Object[])new Object[0]);
                qFilterSb.append(' ').append(opStr).append("\r\n").append(QFilterSaveLogHelper.qFilterToViewString(nest.getFilter(), param2StringFnc));
                return null;
            });
        }
        return qFilterSb.toString();
    }

    private static void resolveNests(List<QFilter.QFilterNest> nests, StringBuilder qFilterSb, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            qFilterSb.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest nest : nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    qFilterSb.insert(0, '(');
                    qFilterSb.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            qFilterSb.append(')');
        }
    }

    public static QFilter[] rebuidFlikeQFilterEx(QFilter[] qFilters, String searchType) {
        ArrayList<QFilter> flikeFilters = new ArrayList<QFilter>();
        for (int i = 0; i < qFilters.length; ++i) {
            QFilter filter = qFilters[i];
            if (filter == null || !"ftlike".equals(filter.getCP())) continue;
            if (!filter.getProperty().equals("1") && !filter.getProperty().equals("2")) {
                QFilter qf = new QFilter(filter.getProperty(), "like", filter.getValue());
                flikeFilters.add(qf);
                qFilters[i] = null;
                List nests = filter.getNests(false);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    QFilter[] filterEx = QFilterSaveLogHelper.rebuidFlikeQFilterEx(nestFilter.toArray(), searchType);
                    flikeFilters.addAll(Arrays.asList(filterEx));
                }
                continue;
            }
            String values = filter.getOriginValue().toString();
            int valSplitIdx = values.indexOf("#");
            if (valSplitIdx < 0) continue;
            String properties = values.substring(0, valSplitIdx);
            String[] propertyArray = properties.split(",");
            values = values.substring(valSplitIdx + 1);
            String[] valueArray = values.split("\b");
            QFilter parentFilter = null;
            for (String property : propertyArray) {
                QFilter subFilter = null;
                for (String value : valueArray) {
                    QFilter qf = "1".equals(searchType) ? new QFilter(property, "like", (Object)("%" + value + "%")) : ("2".equals(searchType) ? new QFilter(property, "like", (Object)(value + "%")) : new QFilter(property, "like", (Object)("%" + value + "%")));
                    subFilter = subFilter == null ? qf.copy() : subFilter.or(qf);
                }
                if (subFilter == null) continue;
                parentFilter = parentFilter == null ? subFilter.copy() : parentFilter.or(subFilter);
            }
            flikeFilters.add(parentFilter);
            qFilters[i] = null;
        }
        return flikeFilters.toArray(new QFilter[0]);
    }

    public static QFilter[] copyQFilters(QFilter[] filterArray) {
        QFilter[] filterArrayCopy = new QFilter[filterArray.length];
        for (int j = 0; j < filterArray.length; ++j) {
            if (filterArray[j] == null) continue;
            filterArrayCopy[j] = filterArray[j].copy();
        }
        return filterArrayCopy;
    }

    public static String qFilterArrTransString(List<Map<String, String>> wordPropRelation, QFilter qFilter) {
        QFilterSaveLogHelper.resetQFilterProp(wordPropRelation, qFilter);
        StringBuilder qFilterSb = new StringBuilder();
        qFilterSb.append(QFilterSaveLogHelper.qFilterToViewString(qFilter, QFilterUtilHR::parametertoString));
        return qFilterSb.toString();
    }

    private static void resetQFilterProp(List<Map<String, String>> wordPropRelation, QFilter qFilter) {
        String property = qFilter.getProperty();
        for (Map<String, String> map : wordPropRelation) {
            if (!HRStringUtils.equals((String)map.get("k"), (String)property)) continue;
            qFilter.__setProperty(map.get("v"));
            break;
        }
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QFilterSaveLogHelper.resetQFilterProp(wordPropRelation, nest.getFilter());
        }
    }
}

