/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchlog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.searchlog.SearchKeywordCountBo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.ai.EsSearchByGptService;
import kd.hrmp.hrss.business.domain.search.service.searchlog.QFilterSaveLogHelper;
import org.elasticsearch.index.query.QueryBuilder;

public class UserSearchLogService {
    private static final Log LOGGER = LogFactory.getLog(UserSearchLogService.class);
    private static final String PAGE_HRSS_USERSEARCHLOG = "hrss_usersearchlog";
    private static final String PAGE_HRSS_USERLASTSEARCHKEY = "hrss_userlastsearchkey";
    private static final int MAX_TEXT_LENGTH = 100000;

    public static void asynSaveUserSearchLog(SearchParam searchParam, QFilter[] qFilters, List<SearchFieldBo> allSearchFieldList, QFilter gptFilterResult, QueryBuilder queryBuilder) {
        Long sceneId = searchParam.getSceneId();
        String searchPageNumber = searchParam.getPermCtlDymNum();
        String searchKey = searchParam.getSearchContent();
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        LOGGER.info("DO_SEARCH_LOGasynSaveUserSearchLog param:[userId:{}, sceneId:{}, searchPageNumber:{}, searchKey:{}]", new Object[]{currUserId, sceneId, searchPageNumber, searchKey});
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"asynSaveUserSearchLog", () -> {
            LOGGER.info("DO_SEARCH_LOGasynSaveUserSearchLog trigger-traceId:{}", (Object)traceId);
            Long searchPageId = UserSearchLogService.queryPageConfPk(searchPageNumber);
            UserSearchLogService.saveUserSearchLog(sceneId, searchPageId, searchKey, qFilters, allSearchFieldList, currUserId, date, gptFilterResult, queryBuilder);
            UserSearchLogService.saveUserLastSearchKey(sceneId, searchPageId, searchKey, currUserId, date);
        });
    }

    private static void saveUserLastSearchKey(Long sceneId, Long searchPageId, String searchKey, long currUserId, Date searchTime) {
        if (HRStringUtils.isEmpty((String)searchKey)) {
            LOGGER.info("saveUserLastSearchKey searchKey is EMPTY donothing");
            return;
        }
        if (searchPageId == 0L) {
            LOGGER.info("saveUserLastSearchKey searchPageId is EMPTY donothing");
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                UserSearchLogService.removeUserKeywords(sceneId, searchPageId, (Long)currUserId, searchKey);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_HRSS_USERLASTSEARCHKEY);
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("user", (Object)currUserId);
                dynamicObject.set("searchtime", (Object)searchTime);
                dynamicObject.set("searchscene", (Object)sceneId);
                dynamicObject.set("searchpage", (Object)searchPageId);
                dynamicObject.set("searchkey", (Object)searchKey);
                serviceHelper.saveOne(dynamicObject);
                UserSearchLogService.clearOverbrimData(sceneId, searchPageId, currUserId, 10);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOGGER.error("saveUserLastSearchKey exception:", (Throwable)exception);
            }
        }
    }

    private static void clearOverbrimData(Long sceneId, Long searchPageId, long currUserId, int retain) {
        String sqlBuilder = "DELETE FROM t_hrss_userlastsearchkey  WHERE fsearchsceneid = ? AND fsearchpageid = ? AND fuserid = ?  AND fid not in ( SELECT fid from ( SELECT TOP " + retain + " fid  FROM t_hrss_userlastsearchkey  WHERE fsearchsceneid = ? AND fsearchpageid = ? AND fuserid = ?  ORDER BY fsearchtime DESC ) AS subquery ) ";
        HRDBUtil.execute((DBRoute)DBRoute.of((String)"hmp"), (String)sqlBuilder, (Object[])new Object[]{sceneId, searchPageId, currUserId, sceneId, searchPageId, currUserId});
    }

    private static void saveUserSearchLog(Long sceneId, Long searchPageId, String searchKey, QFilter[] qFilters, List<SearchFieldBo> allSearchFieldList, long currUserId, Date searchTime, QFilter gptFilterResult, QueryBuilder queryBuilder) {
        try {
            String str;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_HRSS_USERSEARCHLOG);
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("user", (Object)currUserId);
            dynamicObject.set("searchtime", (Object)searchTime);
            dynamicObject.set("searchscene", (Object)sceneId);
            dynamicObject.set("searchpage", (Object)searchPageId);
            dynamicObject.set("searchkey", (Object)searchKey);
            List<Map<String, String>> wordCategoryMap = EsSearchByGptService.getWordCategoryMap(sceneId);
            dynamicObject.set("viewfilter", (Object)UserSearchLogService.subMaxText(QFilterSaveLogHelper.qfilterArrTransString(sceneId, qFilters, allSearchFieldList), false));
            dynamicObject.set("runfilter", (Object)UserSearchLogService.subMaxText(QFilterSaveLogHelper.qfilterArrSerializedString(qFilters), true));
            if (gptFilterResult != null) {
                dynamicObject.set("gptreturn", (Object)gptFilterResult.toSerializedString());
                dynamicObject.set("gptreturnstr", (Object)UserSearchLogService.subMaxText(QFilterSaveLogHelper.qFilterArrTransString(wordCategoryMap, gptFilterResult), false));
            }
            if (queryBuilder != null && HRStringUtils.isNotEmpty((String)(str = queryBuilder.toString()))) {
                String replace = str.replace("```", "").replace("\n", "").replace(" ", "");
                dynamicObject.set("dsl", (Object)UserSearchLogService.subMaxText(replace, false));
            }
            serviceHelper.saveOne(dynamicObject);
        }
        catch (Exception exception) {
            LOGGER.error("saveUserSearchLog exception:", (Throwable)exception);
        }
    }

    private static String subMaxText(String text, boolean exceDiscard) {
        if (HRStringUtils.isNotEmpty((String)text) && text.length() > 100000) {
            if (exceDiscard) {
                return "";
            }
            return text.substring(0, 100000) + "\u2026\u2026";
        }
        return text;
    }

    public static List<SearchKeywordCountBo> queryTopSearchKey(Long searchScene, String searchPageNumber, Date startTime, Date entTime, int topN) {
        Long searchPageId = UserSearchLogService.checkParamQuerySearchPageId(searchScene, searchPageNumber);
        ArrayList<Comparable<Long>> paramList = new ArrayList<Comparable<Long>>(10);
        paramList.add(searchScene);
        paramList.add(searchPageId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ");
        sqlBuilder.append("TOP ").append(topN).append(" ");
        sqlBuilder.append(" fsearchkey AS searchkey,count(fsearchkey) AS scount ");
        sqlBuilder.append(" FROM t_hrss_usersearchlog ");
        sqlBuilder.append(" WHERE fsearchsceneid = ? AND fsearchpageid = ? AND fsearchkey != ' ' ");
        if (startTime != null) {
            sqlBuilder.append(" AND fsearchtime >= ? ");
            paramList.add(startTime);
        }
        if (entTime != null) {
            sqlBuilder.append(" AND fsearchtime <= ? ");
            paramList.add(entTime);
        }
        sqlBuilder.append(" GROUP BY fsearchsceneid,fsearchpageid,fsearchkey ");
        sqlBuilder.append(" ORDER BY COUNT(fsearchkey) DESC");
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sqlBuilder.toString(), (Object[])paramList.toArray(new Object[0]), rs -> {
            ArrayList<SearchKeywordCountBo> searchKeyList = new ArrayList<SearchKeywordCountBo>(10);
            while (rs.next()) {
                SearchKeywordCountBo searchKeywordCountBo = new SearchKeywordCountBo();
                searchKeywordCountBo.setKeyword(rs.getString("searchkey"));
                searchKeywordCountBo.setsCount(rs.getInt("scount"));
                searchKeyList.add(searchKeywordCountBo);
            }
            return searchKeyList;
        });
    }

    public static List<String> queryUserTopKeywords(Long sceneId, String searchPageNumber, Long userId, int topN) {
        if (userId == null || userId == 0L) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{"userId is Null"});
        }
        Long searchPageId = UserSearchLogService.checkParamQuerySearchPageId(sceneId, searchPageNumber);
        String sqlStr = "SELECT TOP " + topN + "  fsearchkey AS searchkey  FROM t_hrss_userlastsearchkey  WHERE fsearchsceneid = ? AND fsearchpageid = ? AND fuserid = ?  ORDER BY fsearchtime DESC ";
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sqlStr, (Object[])new Object[]{sceneId, searchPageId, userId}, rs -> {
            ArrayList<String> searchKeyList = new ArrayList<String>(10);
            while (rs.next()) {
                searchKeyList.add(rs.getString("searchkey"));
            }
            return searchKeyList;
        });
    }

    private static void removeUserKeywords(Long sceneId, Long searchPageId, Long userId, String keyword) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        paramList.add(sceneId);
        paramList.add(searchPageId);
        paramList.add(userId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DELETE FROM t_hrss_userlastsearchkey ");
        sqlBuilder.append(" WHERE fsearchsceneid = ? AND fsearchpageid = ? AND fuserid = ? ");
        if (HRStringUtils.isNotEmpty((String)keyword)) {
            sqlBuilder.append(" AND fsearchkey = ? ");
            paramList.add(keyword);
        }
        HRDBUtil.execute((DBRoute)DBRoute.of((String)"hmp"), (String)sqlBuilder.toString(), (Object[])paramList.toArray(new Object[0]));
    }

    public static void removeUserKeywords(Long sceneId, String searchPageNumber, Long userId, String keyword) {
        if (userId == null || userId == 0L) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{"userId is Null"});
        }
        Long searchPageId = UserSearchLogService.checkParamQuerySearchPageId(sceneId, searchPageNumber);
        UserSearchLogService.removeUserKeywords(sceneId, searchPageId, userId, keyword);
    }

    private static Long queryPageConfPk(String searchPageNumber) {
        if (HRStringUtils.isEmpty((String)searchPageNumber)) {
            return 0L;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_searchconfig");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("id", new QFilter[]{new QFilter("basedatafield", "=", (Object)searchPageNumber)});
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private static Long checkParamQuerySearchPageId(Long searchScene, String searchPageNumber) {
        if (HRStringUtils.isEmpty((String)searchPageNumber)) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{"searchPageNumber is Null"});
        }
        if (searchScene == null || searchScene == 0L) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{"searchScene is Null"});
        }
        Long searchPageId = UserSearchLogService.queryPageConfPk(searchPageNumber);
        if (searchPageId == 0L) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{"searchPageNumber is error"});
        }
        return searchPageId;
    }
}

