/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchobj;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.labelandreport.ComplexObjTransferUtil;
import kd.hrmp.hrss.business.domain.search.service.common.SObjCacheService;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjEntityRelation;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import org.apache.commons.collections.CollectionUtils;

public class SearchObjectService
implements SearchObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(SearchObjectService.class);
    private static volatile SearchObjectService service = null;
    private final HRBaseServiceHelper searchObjectHelper = new HRBaseServiceHelper("hrss_searchobject");
    private final HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");
    private final HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrss_schobjentityrel");

    private SearchObjectService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchObjectService getInstance() {
        if (service != null) return service;
        Class<SearchObjectService> clazz = SearchObjectService.class;
        synchronized (SearchObjectService.class) {
            if (service != null) return service;
            service = new SearchObjectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public DynamicObject loadSearchObject(Long searchObjId) {
        return this.searchObjectHelper.loadSingle((Object)searchObjId);
    }

    public boolean isExistsSearchObj(Long searchObjId) {
        return this.searchObjectHelper.isExists((Object)searchObjId);
    }

    public DynamicObject[] loadJoinEntities(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)};
        return this.joinEntityHelper.loadDynamicObjectArray(qFilters);
    }

    public Map<String, String> queryRelEntityAliasMap(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId), new QFilter("type", "=", (Object)"sub")};
        DynamicObject[] dynamicObjects = this.joinEntityHelper.queryOriginalArray("entitynumber,entityalias", qFilters);
        HashMap<String, String> relEntityMap = new HashMap<String, String>(16);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                relEntityMap.put(dynamicObject.getString("entityalias"), dynamicObject.getString("entitynumber"));
            }
        }
        return relEntityMap;
    }

    public Map<Long, String> queryAllSearchObjNumMap() {
        DynamicObject[] dynamicObjects = this.searchObjectHelper.queryOriginalArray("id,number", new QFilter[0]);
        HashMap<Long, String> sobjIdNumberMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            sobjIdNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return sobjIdNumberMap;
    }

    public DynamicObject[] loadQueryFields(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)};
        return this.queryFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] queryFieldInfo(Long searchObjId, QFilter qFilter) {
        if (qFilter == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId), qFilter};
        return this.queryFieldHelper.query("id,entitynumber,fieldalias,valuetype,complextype,controltype,fieldname", qFilters);
    }

    public DynamicObject[] loadEntityRelations(Long searchObjId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)};
        return this.entityRelationHelper.loadDynamicObjectArray(qFilters);
    }

    public List<SchObjJoinEntity> queryAndAssembleJoinEntities(Long searchObjId) {
        DynamicObject[] joinEntityCol = this.loadJoinEntities(searchObjId);
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)joinEntityCol.length);
        for (DynamicObject joinEntityDy : joinEntityCol) {
            SchObjJoinEntity joinEntity = new SchObjJoinEntity();
            joinEntity.setId(joinEntityDy.getString("id"));
            joinEntity.setSearchObjId(joinEntityDy.getDynamicObject("searchobj").getString("id"));
            joinEntity.setType(joinEntityDy.getString("type"));
            String longNumber = joinEntityDy.getString("longnumber");
            joinEntity.setLongNumber(joinEntityDy.getString("longnumber"));
            if (longNumber.contains("!")) {
                joinEntity.setParentLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!")));
            } else {
                joinEntity.setParentLongNumber(null);
            }
            if (HRStringUtils.equals((String)longNumber, (String)"0")) {
                joinEntity.setLevel(Integer.valueOf(0));
            } else {
                String[] longNumberSp = longNumber.split("!");
                joinEntity.setLevel(Integer.valueOf(longNumberSp.length - 1));
            }
            joinEntity.setEntityNumber(joinEntityDy.getString("entitynumber"));
            joinEntity.setEntityAlias(joinEntityDy.getString("entityalias"));
            joinEntity.setSearchTarget(joinEntityDy.getBoolean("searchtarget"));
            joinEntity.setEntityName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)joinEntityDy.getLocaleString("entityname"))));
            String[] split = joinEntity.getEntityAlias().split("\u03b4");
            if (split.length > 1) {
                joinEntity.setDisplayName(joinEntity.getEntityName().getLocaleValue() + split[1]);
            } else {
                joinEntity.setDisplayName(joinEntity.getEntityName().getLocaleValue());
            }
            joinEntities.add(joinEntity);
        }
        return joinEntities.stream().sorted(Comparator.comparing(JoinEntityCommonBo::getLongNumber)).collect(Collectors.toList());
    }

    public List<SchObjQueryField> queryAndAssembleQueryFields(Long searchObjId) {
        DynamicObject[] queryFieldCol = this.loadQueryFields(searchObjId);
        return this.assembleQueryFields(queryFieldCol);
    }

    public List<SchObjQueryField> assembleQueryFields(DynamicObject[] queryFieldCol) {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)queryFieldCol.length);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        Set entityNums = Arrays.stream(queryFieldCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject queryFieldDy : queryFieldCol) {
            SchObjQueryField queryField = new SchObjQueryField();
            queryField.setId(queryFieldDy.getString("id"));
            queryField.setSearchObjId(queryFieldDy.getDynamicObject("searchobj").getString("id"));
            String entityNumber = queryFieldDy.getString("entitynumber");
            queryField.setEntityNumber(entityNumber);
            String fieldAlias = queryFieldDy.getString("fieldalias");
            if (!queryField.isVirtualEntityField()) {
                String nameSuffix = "";
                if (fieldAlias.contains("\u03b4")) {
                    nameSuffix = fieldAlias.substring(fieldAlias.indexOf(948), fieldAlias.indexOf(46));
                }
                String entityName = entityNumMap.get(entityNumber);
                entityName = entityName + nameSuffix;
                queryField.setEntityName(entityName);
            }
            OrmLocaleValue fieldName = (OrmLocaleValue)queryFieldDy.getLocaleString("fieldname");
            queryField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryField.setFieldAlias(fieldAlias);
            queryField.setFieldPath(queryFieldDy.getString("fieldpath"));
            String complexType = queryFieldDy.getString("complextype");
            queryField.setComplexType(complexType);
            queryField.setFieldNumber(this.getFieldShortNumber(entityNumber, fieldAlias, complexType));
            if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                Map baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
            }
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            queryFields.add(queryField);
        }
        return queryFields.stream().sorted(Comparator.comparing(QueryFieldCommonBo::getFieldAlias)).collect(Collectors.toList());
    }

    private String getFieldShortNumber(String entityNumber, String fieldAlias, String fieldComplexType) {
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && fieldAlias.contains(".")) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String[] aliasArr = fieldAlias.split("\\.");
            if (aliasArr.length > 2) {
                String parentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (parentProp instanceof BasedataProp) {
                    return aliasArr[aliasArr.length - 3] + "." + aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
                }
            }
            return aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
        }
        return fieldAlias.substring(fieldAlias.lastIndexOf(46) + 1);
    }

    public List<SchObjEntityRelation> queryAndAssembleEntityRelations(Long searchObjId) {
        DynamicObject[] entityRelationCol = this.loadEntityRelations(searchObjId);
        ArrayList entityRelations = Lists.newArrayListWithCapacity((int)entityRelationCol.length);
        for (DynamicObject entityRelationDy : entityRelationCol) {
            SchObjEntityRelation entityRelation = new SchObjEntityRelation();
            DynamicObject entityDy = entityRelationDy.getDynamicObject("entityid");
            DynamicObject joinEntityDy = entityRelationDy.getDynamicObject("joinentityid");
            entityRelation.setId(entityRelationDy.getString("id"));
            entityRelation.setSearchObjId(entityRelationDy.getDynamicObject("searchobj").getString("id"));
            entityRelation.setEntityId(entityDy.getString("id"));
            entityRelation.setEntityNumber(entityDy.getString("entitynumber"));
            entityRelation.setEntityAlias(entityDy.getString("entityalias"));
            entityRelation.setJoinType(entityRelationDy.getString("jointype"));
            entityRelation.setJoinEntityId(joinEntityDy.getString("id"));
            entityRelation.setJoinEntityNumber(joinEntityDy.getString("entitynumber"));
            entityRelation.setJoinEntityAlias(joinEntityDy.getString("entityalias"));
            DynamicObjectCollection joinConditionCol = entityRelationDy.getDynamicObjectCollection("joinconditions");
            if (joinConditionCol.isEmpty()) {
                throw new KDBizException("search object join conditions is empty.");
            }
            ArrayList joinConditions = Lists.newArrayListWithCapacity((int)joinConditionCol.size());
            for (DynamicObject joinConditionDy : joinConditionCol) {
                JoinConditionBo joinCondition = new JoinConditionBo();
                joinCondition.setId(joinConditionDy.getString("id"));
                joinCondition.setLeftProp(joinConditionDy.getString("leftprop"));
                joinCondition.setCompareType(joinConditionDy.getString("comparetype"));
                String rightPropType = joinConditionDy.getString("rightproptype");
                joinCondition.setRightPropType(rightPropType);
                if (HRStringUtils.equals((String)rightPropType, (String)"field")) {
                    joinCondition.setRightProp(joinConditionDy.getString("rightprop"));
                } else {
                    joinCondition.setRightPropVal(joinConditionDy.getString("rightpropval"));
                }
                joinCondition.setLogicType(joinConditionDy.getString("logictype"));
                joinConditions.add(joinCondition);
            }
            entityRelation.setConditions((List)joinConditions);
            entityRelations.add(entityRelation);
        }
        return entityRelations;
    }

    public DynamicObject[] getSearchFieldByIds(Object[] pkValues) {
        return this.queryFieldHelper.query("entitynumber,fieldname,fieldpath", new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
    }

    public boolean isTargetMainObject(String entityNumber) {
        HRBaseServiceHelper targetObjHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        DynamicObject targetObjDy = targetObjHelper.queryOriginalOne("entitynumber, type", new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)});
        if (targetObjDy != null) {
            return HRStringUtils.equals((String)targetObjDy.getString("type"), (String)"main");
        }
        return false;
    }

    public void setTargetMainObject(List<SchObjJoinEntity> joinEntities) {
        HRBaseServiceHelper targetObjHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        Set entityNumberSet = joinEntities.stream().map(JoinEntityCommonBo::getEntityNumber).collect(Collectors.toSet());
        DynamicObjectCollection targetObjCol = targetObjHelper.queryOriginalCollection("entitynumber, type", new QFilter[]{new QFilter("entityNumber", "in", entityNumberSet)});
        Set isTargetMainSet = targetObjCol.stream().filter(dy -> HRStringUtils.equals((String)dy.getString("type"), (String)"main")).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        for (SchObjJoinEntity joinEntity : joinEntities) {
            if (!isTargetMainSet.contains(joinEntity.getEntityNumber())) continue;
            joinEntity.setTargetObjMainEntity(true);
        }
    }

    public Long getSearchObjId(String searchObjNumber) {
        DynamicObject dynamicObject = this.searchObjectHelper.queryOriginalOne(new QFilter("number", "=", (Object)searchObjNumber));
        return dynamicObject.getLong("id");
    }

    public HRComplexObjContext getComplexObjContext(Long searchObjId) {
        List<SchObjJoinEntity> joinEntityBos = this.queryAndAssembleJoinEntities(searchObjId);
        List<SchObjQueryField> queryFieldBos = this.queryAndAssembleQueryFields(searchObjId);
        List<SchObjEntityRelation> entityRelationBos = this.queryAndAssembleEntityRelations(searchObjId);
        List<QFilter> qFilters = this.getQueryQFilter(searchObjId, queryFieldBos);
        return this.transferToComplexObjContext(joinEntityBos, queryFieldBos, entityRelationBos, qFilters);
    }

    public HRComplexObjContext getComplexObjContextNoQueryField(Long searchObjId) {
        List<SchObjJoinEntity> joinEntityBos = this.queryAndAssembleJoinEntities(searchObjId);
        List<SchObjEntityRelation> entityRelationBos = this.queryAndAssembleEntityRelations(searchObjId);
        List<SchObjQueryField> queryFieldBos = this.queryAndAssembleQueryFields(searchObjId);
        List<QFilter> qFilters = this.getQueryQFilter(searchObjId, queryFieldBos);
        return this.transferToComplexObjContext(joinEntityBos, Collections.emptyList(), entityRelationBos, qFilters);
    }

    public List<QFilter> getQueryQFilter(Long searchObjId, List<SchObjQueryField> queryFields) {
        QFilter qFilter;
        String dataFilter;
        DynamicObject anObj = this.searchObjectHelper.queryOne("datafilter", new QFilter[]{new QFilter("id", "=", (Object)searchObjId)});
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        if (anObj != null && HRStringUtils.isNotEmpty((String)(dataFilter = anObj.getString("datafilter"))) && (qFilter = HRFilterUtil.condition2QFilter4HRReport((String)dataFilter, (String)SerializationUtils.toJsonString(queryFields))) != null) {
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    public HRComplexObjContext transferToComplexObjContext(List<SchObjJoinEntity> joinEntities, List<SchObjQueryField> queryFields, List<SchObjEntityRelation> entityRelations, List<QFilter> qFilters) {
        List<JoinEntityCommonBo> joinEntityCommonBos = this.transferJoinEntityBos(joinEntities);
        List<QueryFieldCommonBo> queryFieldCommonBos = this.transferQueryFieldBos(queryFields);
        Map relationBoMap = entityRelations.stream().collect(Collectors.toMap(EntityRelationCommonBo::getJoinEntityAlias, Function.identity()));
        ArrayList sortedEntityRelations = Lists.newArrayListWithExpectedSize((int)10);
        for (SchObjJoinEntity joinEntity : joinEntities) {
            String longNumber = joinEntity.getLongNumber();
            if (HRStringUtils.equals((String)longNumber, (String)"0")) continue;
            SchObjEntityRelation entityRelationBo = (SchObjEntityRelation)relationBoMap.get(joinEntity.getEntityAlias());
            sortedEntityRelations.add(entityRelationBo);
        }
        List<EntityRelationCommonBo> entityRelationCommonBos = this.transferEntityRelationBos(sortedEntityRelations);
        return ComplexObjTransferUtil.transferToComplexObjContext(joinEntityCommonBos, queryFieldCommonBos, entityRelationCommonBos, qFilters);
    }

    public String querySearchObjMainEntity(Long searchObjPk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
        QFilter qFilter = new QFilter("searchobj", "=", (Object)searchObjPk);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("entitynumber", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("entitynumber");
    }

    public String querySearchObjMainEntity(String searchObjNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
        QFilter qFilter = new QFilter("searchobj.number", "=", (Object)searchObjNumber);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("entitynumber", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("entitynumber");
    }

    public List<JoinEntityCommonBo> transferJoinEntityBos(List<SchObjJoinEntity> joinEntityBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(joinEntityBos), JoinEntityCommonBo.class);
    }

    public List<QueryFieldCommonBo> transferQueryFieldBos(List<SchObjQueryField> queryFieldBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(queryFieldBos), QueryFieldCommonBo.class);
    }

    public List<EntityRelationCommonBo> transferEntityRelationBos(List<SchObjEntityRelation> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), EntityRelationCommonBo.class);
    }

    public DynamicObject getSearchJoinEntityById(Long pkvalue) {
        return this.joinEntityHelper.queryOne((Object)pkvalue);
    }

    public List<SearchFieldBo> queryAllLabelFields(Long searchObjId) {
        return this.queryAllLabelFields(searchObjId, true);
    }

    public List<SearchFieldBo> queryAllLabelFieldsFromCache(Long searchObjId) {
        String cacheKey = "SOBJ_ALLLABELFIELD_" + searchObjId;
        SObjCacheService cacheService = SObjCacheService.getInstance();
        String cacheJson = cacheService.get(cacheKey);
        List<SearchFieldBo> searchFieldBoList = null;
        if (HRStringUtils.isNotEmpty((String)cacheJson)) {
            try {
                LOGGER.info("queryAllLabelFields from cache searchObjId:{}", (Object)searchObjId);
                searchFieldBoList = SerializationUtils.fromJsonStringToList((String)cacheJson, SearchFieldBo.class);
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
        if (CollectionUtils.isEmpty(searchFieldBoList)) {
            LOGGER.info("queryAllLabelFields from cache error searchObjId:{}", (Object)searchObjId);
            searchFieldBoList = SearchObjectService.getInstance().queryAllLabelFields(searchObjId, false);
            cacheService.put(cacheKey, SerializationUtils.toJsonString(searchFieldBoList));
        }
        return searchFieldBoList;
    }

    public List<SearchFieldBo> queryAllLabelFields(Long searchObjId, boolean onlyModelLabel) {
        if (searchObjId == null || searchObjId == 0L) {
            throw new KDBizException("searchObjId is null");
        }
        ArrayList<SearchFieldBo> searchFieldList = new ArrayList<SearchFieldBo>(10);
        List<SchObjJoinEntity> schObjJoinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities(searchObjId);
        for (SchObjJoinEntity schObjJoinEntity : schObjJoinEntities) {
            Map<Long, String> labelInfoMap;
            boolean searchTarget = schObjJoinEntity.isSearchTarget();
            if (!searchTarget) continue;
            try {
                labelInfoMap = SearchObjectService.queryLabelInfo(schObjJoinEntity.getEntityNumber(), onlyModelLabel);
            }
            catch (Exception exception) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6807\u7b7e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\u3002", (String)"SearchObjectService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            }
            String entityType = schObjJoinEntity.getType();
            boolean isMainEntity = HRStringUtils.equals((String)entityType, (String)"main");
            labelInfoMap.forEach((labelId, labelName) -> {
                SearchFieldBo searchFieldBo = new SearchFieldBo();
                searchFieldBo.setLabelField(true);
                String labelField = "label_" + labelId;
                if (!isMainEntity) {
                    labelField = schObjJoinEntity.getEntityAlias() + '.' + labelField;
                }
                searchFieldBo.setFieldAlias(labelField);
                searchFieldBo.setDisplayName(labelName);
                searchFieldList.add(searchFieldBo);
            });
        }
        return searchFieldList;
    }

    private static Map<Long, String> queryLabelInfo(String entityNumber, boolean onlyModleLabel) {
        Map labelObjRstMap = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{entityNumber});
        boolean success = (Boolean)labelObjRstMap.get("success");
        if (!success) {
            throw new KDBizException((String)labelObjRstMap.get("msg"));
        }
        ArrayList resultList = (ArrayList)labelObjRstMap.get("resultList");
        LOGGER.info("queryLabelObjectsByEntityNumber resultList={}", (Object)resultList);
        HashMap<Long, String> labelInfoMap = new HashMap<Long, String>(16);
        for (Map resultMap : resultList) {
            Object labels = resultMap.get("labels");
            if (labels == null) continue;
            ArrayList labelList = (ArrayList)labels;
            for (Map objectMap : labelList) {
                String labelType = (String)objectMap.get("labelType");
                if (onlyModleLabel && !HRStringUtils.equals((String)"10", (String)labelType)) continue;
                Long labelId = (Long)objectMap.get("labelId");
                Map labelNameMap = (Map)objectMap.get("labelName");
                String labelName = (String)labelNameMap.get("GLang");
                labelInfoMap.put(labelId, labelName);
            }
        }
        return labelInfoMap;
    }
}

