/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchscene;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.enums.smartsearch.CustomFilterTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.FilterFieldTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchModeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchTargetTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangeBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.AppMetaUtil;
import kd.hrmp.hrss.business.domain.search.service.common.BaseDataFilterUtil;
import kd.hrmp.hrss.business.domain.search.service.query.LabelService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;

public class SearchSceneBusQueryService {
    private static final Log LOGGER = LogFactory.getLog(SearchSceneBusQueryService.class);
    private static final HRBaseServiceHelper searchSceneHelper = new HRBaseServiceHelper("hrss_searchscene");
    private static final String ENTITY_POSITION = "hbpm_positionhr";

    public static DynamicObject loadSceneConfBySearchPage(String searchPageNumber) {
        QFilter qFilter = new QFilter("searchpage.fbasedataid.number", "=", (Object)searchPageNumber);
        return searchSceneHelper.loadDynamicObject(qFilter);
    }

    public static DynamicObject loadSceneConf(Long pk) {
        return searchSceneHelper.loadSingle((Object)pk);
    }

    public static SearchSceneBo genSearchSceneBo(DynamicObject dynamicObject, String searchPageNumber, String appNumber) {
        try {
            long searchObjId = dynamicObject.getLong("searchobj.id");
            SearchSceneBo sceneBo = new SearchSceneBo(Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"), Long.valueOf(searchObjId), SearchCategoryEnum.of((String)dynamicObject.getString("searchcategory")), SearchKeyLogicEnum.of((String)dynamicObject.getString("searchkeytype")), dynamicObject.getString("copywriting"));
            long time1 = System.currentTimeMillis();
            List<SearchFieldBo> searchFieldList = SearchSceneBusQueryService.genSearchFieldList(dynamicObject, searchObjId);
            sceneBo.setSearchFieldList(searchFieldList);
            long time2 = System.currentTimeMillis();
            LOGGER.info("SearchScene_Query genSearchFieldList,time:{} ms", (Object)(time2 - time1));
            List<SearchRangeBo> searchRangeList = SearchSceneBusQueryService.genSearchRangeList(dynamicObject);
            sceneBo.setSearchRangeList(searchRangeList);
            long time3 = System.currentTimeMillis();
            LOGGER.info("SearchScene_Query genSearchRangeList,time:{} ms", (Object)(time3 - time2));
            List<SearchFilterBo> searchFilterList = SearchSceneBusQueryService.genSearchFilterList(dynamicObject, searchObjId);
            SearchSceneBusQueryService.setFieldEntityInfo(searchFilterList, searchObjId, dynamicObject.getLong("id"), searchPageNumber, appNumber);
            sceneBo.setSearchFilterList(searchFilterList);
            long time4 = System.currentTimeMillis();
            LOGGER.info("SearchScene_Query genSearchFilterList,time:{} ms", (Object)(time4 - time3));
            sceneBo.setSceneVersion(dynamicObject.getDate("modifytime").getTime());
            return sceneBo;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u573a\u666f\u914d\u7f6e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"SearchSceneBusQueryService_5", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
    }

    private static void setFieldEntityInfo(List<SearchFilterBo> searchFilterList, Long searchObjId, Long sceneId, String searchPageNumber, String appNumber) {
        List fieldAliasList = searchFilterList.stream().filter(bo -> bo.getFilterFieldType() != FilterFieldTypeEnum.LABEL).map(SearchFilterBo::getFieldAlias).collect(Collectors.toList());
        if (fieldAliasList.isEmpty()) {
            return;
        }
        QFilter fieldAliasFilter = new QFilter("fieldalias", "in", fieldAliasList);
        DynamicObject[] soFieldDyoArr = SearchObjectService.getInstance().queryFieldInfo(searchObjId, fieldAliasFilter);
        if (soFieldDyoArr != null) {
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            QFilter pkFilter = new QFilter("id", "=", (Object)sceneId);
            QFilter searchPageFilter = new QFilter("searchpage.fbasedataid.number", "=", (Object)searchPageNumber);
            DynamicObject sceneDyo = searchSceneHelper.loadDynamicObject(new QFilter[]{pkFilter, searchPageFilter});
            Map fieldaliasDyoMap = Arrays.stream(soFieldDyoArr).collect(Collectors.toMap(dyo -> dyo.getString("fieldalias"), Function.identity()));
            for (SearchFilterBo searchFilterBo : searchFilterList) {
                String fieldAlias;
                if (searchFilterBo.getFilterFieldType() == FilterFieldTypeEnum.LABEL) continue;
                DynamicObject dynamicObject = (DynamicObject)fieldaliasDyoMap.get(searchFilterBo.getFieldAlias());
                String entityNumber = dynamicObject.getString("entitynumber");
                IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNumber, (String)(fieldAlias = dynamicObject.getString("fieldalias")), (MainEntityTypeUtil)mainEntityTypeUtil);
                if (property == null) {
                    throw new KDBizException("field " + fieldAlias + " not exists");
                }
                String propertyName = property.getName();
                boolean isEntry = false;
                if (property.getParent() != null && property.getParent() instanceof EntryType) {
                    String entryName = property.getParent().getName();
                    propertyName = entryName + "." + propertyName;
                    isEntry = true;
                }
                searchFilterBo.setRealEntityField(propertyName);
                String baseDataNum = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)mainEntityTypeUtil);
                searchFilterBo.setRealEntityNumber(baseDataNum);
                if (baseDataNum == null && isEntry) {
                    baseDataNum = entityNumber;
                    searchFilterBo.setRealEntityNumber(entityNumber);
                }
                String controlType = dynamicObject.getString("controltype");
                searchFilterBo.setComplexType(dynamicObject.getString("complextype"));
                searchFilterBo.setValueType(dynamicObject.getString("valuetype"));
                searchFilterBo.setControlType(controlType);
                Map<Object, Object> top20ValMap = SearchSceneBusQueryService.getPartFilterVal(property, propertyName, baseDataNum, controlType, sceneId, fieldAlias, searchPageNumber, sceneDyo, soFieldDyoArr, appNumber);
                searchFilterBo.setPartFilterValMap(top20ValMap);
            }
        }
    }

    private static Map<Object, Object> getPartFilterVal(IDataEntityProperty property, String propertyName, String baseDataNum, String controlType, Long sceneId, String fieldAlias, String searchPageNumber, DynamicObject sceneDyo, DynamicObject[] soFieldDyoArr, String appNumber) {
        LinkedHashMap<Object, Object> top20ValMap = new LinkedHashMap<Object, Object>(16);
        boolean enumType = AnalyseObjectUtil.isEnumType((String)controlType);
        if (enumType) {
            ComboProp comboProp = (ComboProp)property;
            List comboItemList = comboProp.getComboItems();
            for (ValueMapItem comboItem : comboItemList) {
                top20ValMap.put(comboItem.getValue(), comboItem.getName().toString());
            }
        } else {
            HRBaseServiceHelper baService = new HRBaseServiceHelper(baseDataNum);
            try (AlgoContext context = Algo.newContext();){
                QFilter permQFilters = SearchSceneBusQueryService.getPermQFilters(sceneId, fieldAlias, searchPageNumber, sceneDyo, soFieldDyoArr, appNumber);
                List<QFilter> qFilterList = BaseDataFilterUtil.getF7FilterList(baseDataNum);
                if (permQFilters != null) {
                    qFilterList.add(permQFilters);
                }
                SearchSceneBusQueryService.addSpecialFilter(baseDataNum, qFilterList);
                String orderBy = SearchSceneBusQueryService.getTopNOrderBy(baseDataNum);
                DataSet dataSet = baService.queryDataSet("SearchSceneBusQueryService.setFieldEntityInfo", "id," + propertyName, qFilterList.toArray(new QFilter[0]), orderBy, 20);
                for (Row row : dataSet) {
                    top20ValMap.put(row.get("id"), row.get(propertyName));
                }
            }
            catch (Exception exp) {
                LOGGER.error((Throwable)exp);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5e38\u7528\u8fc7\u6ee4\u6570\u636e\u5931\u8d25\uff0c\u5b9e\u4f53\uff1a%1s\uff0c\u5b57\u6bb5\uff1a%2s", (String)"SearchSceneBusQueryService_3", (String)"hrmp-hrss-business", (Object[])new Object[0]), baseDataNum, fieldAlias));
            }
        }
        return top20ValMap;
    }

    private static void addSpecialFilter(String baseDataNum, List<QFilter> qFilterList) {
        if (baseDataNum.equals("haos_adminorghr")) {
            qFilterList.add(new QFilter("isvirtualorg", "=", (Object)"0"));
        }
    }

    private static String getTopNOrderBy(String baseDataNum) {
        String orderBy = "";
        if (baseDataNum.equals("haos_adminorghr")) {
            orderBy = "sortcode asc";
        } else if (baseDataNum.equals(ENTITY_POSITION)) {
            orderBy = "adminorg.id asc,positiontype.id asc,isleader asc";
        }
        return orderBy;
    }

    private static List<SearchFilterBo> genSearchFilterList(DynamicObject dynamicObject, Long searchObjId) {
        DynamicObjectCollection searchFilterColl = dynamicObject.getDynamicObjectCollection("filterentryentity");
        ArrayList<SearchFilterBo> searchFilterList = new ArrayList<SearchFilterBo>(searchFilterColl.size());
        String mainEntityNumber = SearchObjectService.getInstance().querySearchObjMainEntity(searchObjId);
        for (DynamicObject searchFilterDyo : searchFilterColl) {
            DynamicObject customFilterDyo;
            FilterFieldTypeEnum fieldType = FilterFieldTypeEnum.of((String)searchFilterDyo.getString("fieldtype"));
            if (fieldType == FilterFieldTypeEnum.LABEL) {
                SearchFilterBo searchFilterBo = SearchSceneBusQueryService.genLabelSearchFilterBo(searchFilterDyo, fieldType, mainEntityNumber);
                searchFilterList.add(searchFilterBo);
                continue;
            }
            SearchFilterBo searchFilter = new SearchFilterBo(fieldType, searchFilterDyo.getString("searchobjfield.fieldalias"), searchFilterDyo.getString("filterdisplayname"), searchFilterDyo.getBoolean("commonfilter"));
            if (HRStringUtils.isEmpty((String)searchFilter.getDisplayName())) {
                searchFilter.setDisplayName(searchFilterDyo.getString("searchobjfield.fieldname"));
            }
            if ((customFilterDyo = searchFilterDyo.getDynamicObject("customfilter")) != null) {
                List<SearchCustomFilterBo> customFilterList = SearchSceneBusQueryService.genCustomFilterList(customFilterDyo.getLong("id"));
                searchFilter.setSearchCustomFilterList(customFilterList);
            }
            searchFilterList.add(searchFilter);
        }
        return searchFilterList;
    }

    private static SearchFilterBo genLabelSearchFilterBo(DynamicObject searchFilterDyo, FilterFieldTypeEnum fieldType, String mainEntityNumber) {
        SearchFilterBo searchFilter;
        String labelType = searchFilterDyo.getString("labeltype");
        if ("1".equals(labelType)) {
            String labelAlias;
            String multipleLabelStr = searchFilterDyo.getString("labeldefaultviewid");
            Map<Object, Object> labelValueMap = null;
            if (HRStringUtils.isNotEmpty((String)multipleLabelStr)) {
                String[] entityLabelArr = multipleLabelStr.split(",");
                ArrayList<Long> labelIdList = new ArrayList<Long>(10);
                for (String entityLabel : entityLabelArr) {
                    String[] split = entityLabel.split("\\.");
                    if (split.length != 2 || !StringUtils.isNumeric((String)split[1])) continue;
                    labelIdList.add(Long.valueOf(split[1]));
                }
                if (labelIdList.size() > 0) {
                    labelValueMap = LabelService.queryModelLabelValues(labelIdList, 20);
                }
            }
            if (HRStringUtils.isEmpty((String)(searchFilter = new SearchFilterBo(fieldType, labelAlias = "multiple_label_" + searchFilterDyo.getLong("id"), searchFilterDyo.getString("filterdisplayname"), searchFilterDyo.getBoolean("commonfilter"))).getDisplayName())) {
                searchFilter.setDisplayName(ResManager.loadKDString((String)"\u5168\u91cf\u6807\u7b7e", (String)"SearchSceneBusQueryService_4", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            }
            searchFilter.setPartFilterValMap(labelValueMap);
        } else {
            DynamicObject labelField = searchFilterDyo.getDynamicObject("labelfilterid");
            long labelPk = labelField.getLong("id");
            String labelEntityAlias = searchFilterDyo.getString("labelentity");
            String prex = "";
            if (!labelEntityAlias.equals(mainEntityNumber)) {
                prex = labelEntityAlias + ".";
            }
            String labelAlias = prex + "label_" + labelPk;
            Map<Object, Object> labelValueMap = LabelService.queryModelLabelValues(labelPk, 20);
            searchFilter = new SearchFilterBo(fieldType, labelAlias, searchFilterDyo.getString("filterdisplayname"), searchFilterDyo.getBoolean("commonfilter"));
            if (HRStringUtils.isEmpty((String)searchFilter.getDisplayName())) {
                String labelName = labelField.getLocaleString("name").toString();
                searchFilter.setDisplayName(labelName);
            }
            searchFilter.setPartFilterValMap(labelValueMap);
        }
        return searchFilter;
    }

    public static List<SearchCustomFilterBo> genCustomFilterList(Long customFilterPk) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_customfilter");
        DynamicObject customFilterAllDyo = serviceHelper.loadSingle((Object)customFilterPk);
        DynamicObjectCollection customFilterColl = customFilterAllDyo.getDynamicObjectCollection("entryentity");
        ArrayList<SearchCustomFilterBo> customFilterList = new ArrayList<SearchCustomFilterBo>(10);
        for (DynamicObject filterItem : customFilterColl) {
            SearchCustomFilterBo customFilterBo = new SearchCustomFilterBo();
            customFilterBo.setKey(filterItem.getString("filternumber"));
            customFilterBo.setName(filterItem.getString("filtername"));
            customFilterBo.setFilterRule(filterItem.getString("filterrule"));
            customFilterBo.setCustomFilterType(CustomFilterTypeEnum.of((String)filterItem.getString("filtertype")));
            customFilterList.add(customFilterBo);
        }
        return customFilterList;
    }

    private static List<SearchRangeBo> genSearchRangeList(DynamicObject dynamicObject) {
        DynamicObjectCollection searchItemColl = dynamicObject.getDynamicObjectCollection("searchentryentity");
        ArrayList<SearchRangeBo> searchRangeList = new ArrayList<SearchRangeBo>(searchItemColl.size());
        for (DynamicObject searchItemDyo : searchItemColl) {
            String[] searchModeArr;
            String rangeNums = searchItemDyo.getString("rangenumber");
            String searchModes = searchItemDyo.getString("searchmode");
            String[] rangeNumArr = rangeNums.split(",");
            if (rangeNumArr.length != (searchModeArr = searchModes.substring(1).split(",")).length) {
                throw new KDBizException("config error");
            }
            ArrayList<SearchRangFieldBo> searchRangFieldList = new ArrayList<SearchRangFieldBo>(10);
            for (int i = 0; i < rangeNumArr.length; ++i) {
                searchRangFieldList.add(new SearchRangFieldBo(rangeNumArr[i], SearchModeEnum.of((String)searchModeArr[i])));
            }
            SearchRangeBo searchRange = new SearchRangeBo(Long.valueOf(searchItemDyo.getLong("id")), SearchTargetTypeEnum.of((String)searchItemDyo.getString("searchinfotype")), searchItemDyo.getString("searchdisplayname"), searchRangFieldList);
            searchRange.setDefSearchPrompt(searchItemDyo.getString("inputprompt"));
            searchRangeList.add(searchRange);
        }
        return searchRangeList;
    }

    public static List<SearchFieldBo> genSearchFieldList(DynamicObject dynamicObject, long searchObjId) {
        DynamicObjectCollection searchFieldColl = dynamicObject.getDynamicObjectCollection("sceneentryentity");
        ArrayList<SearchFieldBo> searchFieldList = new ArrayList<SearchFieldBo>(searchFieldColl.size());
        HashSet<String> selectFields = new HashSet<String>(16);
        for (DynamicObject searchFieldDyo : searchFieldColl) {
            SearchFieldBo searchField;
            boolean isLabelField = "2".equals(searchFieldDyo.getString("fieldsource"));
            if (isLabelField) {
                searchField = SearchSceneBusQueryService.genLabelSearchField(searchFieldDyo);
                if (searchField == null) {
                    continue;
                }
            } else {
                DynamicObject queryFieldDyo = searchFieldDyo.getDynamicObject("queryfield");
                if (queryFieldDyo == null) continue;
                String fieldAlias = queryFieldDyo.getString("fieldalias");
                searchField = new SearchFieldBo(fieldAlias, searchFieldDyo.getString("viewname"), true);
                if (HRStringUtils.isEmpty((String)searchField.getDisplayName())) {
                    searchField.setDisplayName(queryFieldDyo.getString("fieldname"));
                }
                String controlType = queryFieldDyo.getString("controltype");
                searchField.setComplexType(queryFieldDyo.getString("complextype"));
                searchField.setValueType(queryFieldDyo.getString("valuetype"));
                searchField.setControlType(controlType);
                selectFields.add(fieldAlias);
            }
            searchFieldList.add(searchField);
        }
        if (searchObjId != 0L && !selectFields.isEmpty()) {
            QFilter qFilter = new QFilter("fieldalias", "not in", selectFields);
            DynamicObject[] dynamicObjects = SearchObjectService.getInstance().queryFieldInfo(searchObjId, qFilter);
            if (dynamicObjects != null) {
                for (DynamicObject queryFieldDyo : dynamicObjects) {
                    SearchFieldBo searchField = new SearchFieldBo(queryFieldDyo.getString("fieldalias"), queryFieldDyo.getString("fieldname"), false);
                    String controlType = queryFieldDyo.getString("controltype");
                    searchField.setComplexType(queryFieldDyo.getString("complextype"));
                    searchField.setValueType(queryFieldDyo.getString("valuetype"));
                    searchField.setControlType(controlType);
                    searchFieldList.add(searchField);
                }
            }
        }
        return searchFieldList;
    }

    private static SearchFieldBo genLabelSearchField(DynamicObject searchFieldDyo) {
        DynamicObject searchObjEntityDyo = searchFieldDyo.getDynamicObject("searchobjentityid");
        if (searchObjEntityDyo == null) {
            return null;
        }
        String entityType = searchObjEntityDyo.getString("type");
        String prex = "";
        if (!entityType.equals("main")) {
            prex = searchObjEntityDyo.getString("entityalias") + ".";
        }
        String labelId = searchFieldDyo.getString("label.id");
        String labelName = searchFieldDyo.getString("label.name");
        if (HRStringUtils.isEmpty((String)labelId) || HRStringUtils.isEmpty((String)labelName)) {
            return null;
        }
        SearchFieldBo searchField = new SearchFieldBo(prex + "label_" + labelId, searchFieldDyo.getString("viewname"), true);
        if (HRStringUtils.isEmpty((String)searchField.getDisplayName())) {
            searchField.setDisplayName(labelName);
        }
        searchField.setLabelField(true);
        return searchField;
    }

    public static String queryUniqueSearchPermCtrlPage(Long sceneId) {
        QFilter pkFilter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject sceneDyo = searchSceneHelper.queryOne("searchpage", new QFilter[]{pkFilter});
        MulBasedataDynamicObjectCollection mulDyoColl = (MulBasedataDynamicObjectCollection)sceneDyo.get("searchpage");
        if (mulDyoColl != null && mulDyoColl.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)mulDyoColl.get(0);
            DynamicObject fbasedataid = (DynamicObject)dynamicObject.get("fbasedataid");
            return fbasedataid.getString("number");
        }
        return null;
    }

    public static QFilter getPermQFilters(Long sceneId, String fieldAlias, String searchPageNumber, DynamicObject sceneDyo, DynamicObject[] soFieldDyoArr, String appNumber) {
        if ("hrss_searchscenetest".equals(searchPageNumber)) {
            return null;
        }
        if (sceneId == null || sceneId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u68c0\u67e5\uff1a\u573a\u666f\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"SearchSceneBusQueryService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)fieldAlias)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u68c0\u67e5\uff1a\u63a7\u6743\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"SearchSceneBusQueryService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)searchPageNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u68c0\u67e5\uff1a\u63a7\u6743\u9875\u9762\u4e3a\u7a7a\u3002", (String)"SearchSceneBusQueryService_2", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        if (sceneDyo == null) {
            QFilter pkFilter = new QFilter("id", "=", (Object)sceneId);
            QFilter searchPageFilter = new QFilter("searchpage.fbasedataid.number", "=", (Object)searchPageNumber);
            sceneDyo = searchSceneHelper.loadDynamicObject(new QFilter[]{pkFilter, searchPageFilter});
        }
        if (sceneDyo == null) {
            return null;
        }
        DynamicObjectCollection searchFieldDyoColl = sceneDyo.getDynamicObjectCollection("sceneentryentity");
        String finalFieldAlias = fieldAlias;
        DynamicObject queryfieldDyo = searchFieldDyoColl.stream().filter(dyo -> dyo.getDynamicObject("queryfield") != null).map(dyo -> dyo.getDynamicObject("queryfield")).filter(queryFieldDyo -> queryFieldDyo.getString("fieldalias").equals(finalFieldAlias)).findFirst().orElse(null);
        if (queryfieldDyo == null) {
            if (soFieldDyoArr == null) {
                DynamicObject[] dynamicObjects = SearchObjectService.getInstance().queryFieldInfo(sceneDyo.getDynamicObject("searchobj").getLong("id"), new QFilter("fieldalias", "=", (Object)fieldAlias));
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    queryfieldDyo = dynamicObjects[0];
                }
            } else {
                queryfieldDyo = Arrays.stream(soFieldDyoArr).filter(queryFieldDyo -> queryFieldDyo.getString("fieldalias").equals(finalFieldAlias)).findFirst().orElse(null);
            }
        }
        if (queryfieldDyo == null) {
            return null;
        }
        String complexType = queryfieldDyo.getString("complextype");
        String appId = AppMetaUtil.getEntityAppId(searchPageNumber, appNumber);
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
        if (AnalyseObjectUtil.isBaseDataType((String)complexType) && SearchSceneBusQueryService.isBaseDataEnd(fieldAlias)) {
            fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf("."));
            return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, searchPageNumber, fieldAlias, "47150e89000000ac", customParam});
        }
        return null;
    }

    private static boolean isBaseDataEnd(String fieldAlias) {
        return fieldAlias.endsWith("name") || fieldAlias.endsWith("number") || fieldAlias.endsWith("id");
    }
}

