/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchweight;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.SmartSearchEntity;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;

public class SearchWeightConfHelper {
    private HRBaseServiceHelper SEARCH_WEIGHT_HELPER = new HRBaseServiceHelper("hrss_searchweight");
    private HRBaseServiceHelper HRSS_AIWORDCATEGORY_HRLPER = new HRBaseServiceHelper("hrss_aiwordcategory");

    public static SearchWeightConfHelper getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject getWeightGradeDyn(Long gradeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_searchweightgrade");
        return serviceHelper.queryOne((Object)gradeId);
    }

    public DynamicObject getWeightConfigDyn(Long configId) {
        return this.SEARCH_WEIGHT_HELPER.queryOne((Object)configId);
    }

    public List<SmartSearchWordConfig> getAiFieldConfigures(List<String> aiFields, Long sceneId) {
        DynamicObject searchWeight = this.querySearchWeightBySceneId(sceneId);
        if (searchWeight == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6392\u5e8f\u6743\u91cd\u201d\u3002", (String)"SearchWeightConfHelper_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        ArrayList smartSearchWordConfigs = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection weightConfColl = searchWeight.getDynamicObjectCollection("entryentity");
        for (DynamicObject weightConfDyo : weightConfColl) {
            String categoryNumber;
            DynamicObject aiWordCategory = weightConfDyo.getDynamicObject("aiwordcategory");
            if (aiWordCategory == null || !aiFields.contains(categoryNumber = aiWordCategory.getString("number"))) continue;
            SmartSearchWordConfig smartSearchWordConfig = new SmartSearchWordConfig(categoryNumber);
            DynamicObjectCollection weightConfDyoColl = weightConfDyo.getDynamicObjectCollection("subentryentity");
            List<SmartSearchBoostGroup> smartSearchBoostGroups = this.assembleBoostGroups(weightConfDyoColl);
            smartSearchWordConfig.setBoostGroupList(smartSearchBoostGroups);
            smartSearchWordConfigs.add(smartSearchWordConfig);
        }
        return smartSearchWordConfigs;
    }

    public List<SmartSearchBoostGroup> getDefWeightConfig(Long sceneId) {
        DynamicObject searchWeightConf = this.querySearchWeightBySceneId(sceneId);
        if (searchWeightConf == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6392\u5e8f\u6743\u91cd\u201d\u3002", (String)"SearchWeightConfHelper_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection weightConfColl = searchWeightConf.getDynamicObjectCollection("entryentity");
        DynamicObject defWeightConf = weightConfColl.stream().filter(dyo -> dyo.getDynamicObject("aiwordcategory") == null).findFirst().orElse(null);
        if (defWeightConf == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection weightConfDyoColl = defWeightConf.getDynamicObjectCollection("subentryentity");
        return this.assembleBoostGroups(weightConfDyoColl);
    }

    public DynamicObject querySearchWeightBySceneId(Long sceneId) {
        QFilter sceneFilter = new QFilter("usescene", "=", (Object)sceneId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.SEARCH_WEIGHT_HELPER.loadDynamicObject(new QFilter[]{sceneFilter, enableFilter});
    }

    private List<SmartSearchBoostGroup> assembleBoostGroups(DynamicObjectCollection weightConfDyoColl) {
        ArrayList smartSearchBoostGroups = Lists.newArrayListWithExpectedSize((int)weightConfDyoColl.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)weightConfDyoColl.size());
        for (DynamicObject weightConfDyo : weightConfDyoColl) {
            List entityList;
            String boostValue = String.valueOf(weightConfDyo.getBigDecimal("grade.weightvalue"));
            SmartSearchBoostGroup smartSearchBoostGroup = (SmartSearchBoostGroup)map.get(boostValue);
            if (smartSearchBoostGroup == null) {
                smartSearchBoostGroup = new SmartSearchBoostGroup(Float.parseFloat(boostValue));
            }
            if ((entityList = smartSearchBoostGroup.getEntityList()) == null) {
                entityList = Lists.newArrayListWithExpectedSize((int)16);
            }
            String entityAlias = weightConfDyo.getString("searchobjentityid.entityalias");
            String entityNumber = weightConfDyo.getString("searchobjentityid.entitynumber");
            String fieldkey = weightConfDyo.getString("fieldid");
            entityList.add(new SmartSearchEntity(entityNumber, entityAlias, fieldkey));
            smartSearchBoostGroup.setEntityList(entityList);
            map.put(boostValue, smartSearchBoostGroup);
        }
        map.forEach((key, val) -> smartSearchBoostGroups.add(val));
        return smartSearchBoostGroups;
    }

    public DynamicObject[] getAiWordcategory() {
        DynamicObject[] query = this.HRSS_AIWORDCATEGORY_HRLPER.query(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return query;
    }

    public DynamicObject getSearchweightById(Object pkValue) {
        return this.SEARCH_WEIGHT_HELPER.queryOne(pkValue);
    }

    public DynamicObject[] getAllSearchweight() {
        return this.SEARCH_WEIGHT_HELPER.query("usescene", new QFilter[0]);
    }

    public DynamicObject[] getWeightBySceneId(Long sceneId) {
        QFilter sceneFilter = new QFilter("usescene", "=", (Object)sceneId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.SEARCH_WEIGHT_HELPER.loadDynamicObjectArray(new QFilter[]{sceneFilter, enableFilter});
    }

    public DynamicObject[] queryWeightByGrade(List<Object> entryPk) {
        QFilter filter = new QFilter("entryentity.subentryentity.grade.id", "in", entryPk);
        return this.SEARCH_WEIGHT_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject queryOneWeightGrade(Object pkValue) {
        HRBaseServiceHelper weightGradeHelp = new HRBaseServiceHelper("hrss_searchwtgrade");
        return weightGradeHelp.queryOne(pkValue);
    }

    public void getSearchWeightLabelEntity(HashSet<String> usedLabelEntity, Long searchObjectId) {
        DynamicObject[] query;
        for (DynamicObject dynamicObject : query = this.SEARCH_WEIGHT_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("usescene.searchobj.id", "=", (Object)searchObjectId)})) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                DynamicObjectCollection subentry = object.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subentry) {
                    String[] split;
                    String fieldIdStr = subEntry.getString("fieldid");
                    DynamicObject searchObjEntity = subEntry.getDynamicObject("searchobjentityid");
                    if (searchObjEntity == null) continue;
                    String entitynumber = searchObjEntity.getString("entitynumber");
                    for (String field : split = fieldIdStr.split(",")) {
                        if (!LabelFieldUtil.isLabelField(field)) continue;
                        usedLabelEntity.add(entitynumber);
                    }
                }
            }
        }
    }

    private static class Instance {
        private static SearchWeightConfHelper INSTANCE = new SearchWeightConfHelper();

        private Instance() {
        }
    }
}

