/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.searchweight;

import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.ai.EsSearchByGptService;
import kd.hrmp.hrss.business.domain.search.service.common.GptFilterUtil;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.model.search.InputFilterAnalysisRst;
import org.apache.commons.collections.CollectionUtils;

public class SearchWeightService {
    private static final Log LOGGER = LogFactory.getLog(SearchWeightService.class);

    private SearchWeightService() {
    }

    public static SearchWeightService getInstance() {
        return new SearchWeightService();
    }

    public InputFilterAnalysisRst getSearchWeightConfList(String searchContent, Long sceneId, String pageId) {
        InputFilterAnalysisRst inputFilterAnalysisRst;
        PageCache pageCache;
        QFilter gptFilterResult = null;
        LOGGER.info("getSearchWeightConfList.pageId:{}", (Object)pageId);
        if (HRStringUtils.isNotEmpty((String)pageId)) {
            pageCache = new PageCache(pageId);
            String responseData = pageCache.get("last_data#" + searchContent);
            LOGGER.info("getSearchWeightConfList.responseData:{}", (Object)responseData);
            if (HRStringUtils.isNotEmpty((String)responseData)) {
                gptFilterResult = QFilter.fromSerializedString((String)responseData);
            }
        }
        if (gptFilterResult == null) {
            LOGGER.info("getSearchWeightConfList.wordGPTAnalysis start");
            gptFilterResult = EsSearchByGptService.getInstance().wordGPTAnalysis(searchContent, sceneId);
            if (HRStringUtils.isNotEmpty((String)pageId) && gptFilterResult != null) {
                LOGGER.info("getSearchWeightConfList.gptFilterResult:{}", (Object)gptFilterResult.toString());
                pageCache = new PageCache(pageId);
                pageCache.put("last_data#" + searchContent, gptFilterResult.toSerializedString());
            }
            LOGGER.info("getSearchWeightConfList.wordGPTAnalysis end");
        } else {
            LOGGER.info("getSearchWeightConfList.gptFilterResult.toSerializedString:{}", (Object)gptFilterResult.toString());
        }
        if (gptFilterResult == null) {
            LOGGER.info("DO_SEARCH_LOGGPT analysis fail,has no words or GPT fail!");
            inputFilterAnalysisRst = null;
        } else {
            inputFilterAnalysisRst = new InputFilterAnalysisRst();
            inputFilterAnalysisRst.setInput(searchContent);
            inputFilterAnalysisRst.setGptFilterResult(gptFilterResult);
            List<SmartSearchWordConfig> searchWordConfigList = this.queryInputEntityFieldCfg(sceneId, gptFilterResult);
            inputFilterAnalysisRst.setSearchWordConfigList(searchWordConfigList);
            LOGGER.info("DO_SEARCH_LOGassembleSearchWeightConfList result:{}", (Object)inputFilterAnalysisRst);
        }
        return inputFilterAnalysisRst;
    }

    public List<SmartSearchWordConfig> queryInputEntityFieldCfg(Long sceneId, QFilter gptFilterResult) {
        List<String> categoryList = GptFilterUtil.collectCategory(gptFilterResult);
        if (CollectionUtils.isEmpty(categoryList)) {
            return Collections.emptyList();
        }
        return SearchWeightConfHelper.getInstance().getAiFieldConfigures(categoryList, sceneId);
    }
}

