/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.task;

import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjEsOperateService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjSyncConfService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OldEsIndexDeleteTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(OldEsIndexDeleteTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("AIQ OldEsIndexDeleteTask execute begin...");
        try {
            Map<Long, String> allSObjMap = SearchObjectService.getInstance().queryAllSearchObjNumMap();
            if (MapUtils.isEmpty(allSObjMap)) {
                return;
            }
            SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
            allSObjMap.forEach((sObjPk, sObjNumber) -> {
                Set<Long> keepRecordIds = SearchObjSyncConfService.queryFinishSyncId(sObjPk, 2);
                if (CollectionUtils.isNotEmpty(keepRecordIds)) {
                    LOGGER.info("AIQ OldEsIndexDeleteTask start_delete_index searchObjNumber:{}, keepRecordIds:{}", sObjNumber, keepRecordIds);
                    Set<Long> syncingPks = SearchObjSyncConfService.queryAllSyncIngData(sObjPk);
                    if (CollectionUtils.isNotEmpty(syncingPks)) {
                        keepRecordIds.addAll(syncingPks);
                    }
                    esOperateService.deleteOldIndex((Long)sObjPk, keepRecordIds);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("AIQ OldEsIndexDeleteTask_error", (Throwable)ex);
        }
        LOGGER.info("AIQ OldEsIndexDeleteTask execute end...");
    }
}

