/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.task;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;

public class SearchObjFieldControlTypeUpdateTask
extends AbstractTask
implements SearchObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(SearchObjFieldControlTypeUpdateTask.class);
    private final HRBaseServiceHelper searchObjectHelper = new HRBaseServiceHelper("hrss_searchobject");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            DynamicObjectCollection searchObjCol = this.searchObjectHelper.queryOriginalCollection("id", new QFilter[0]);
            List searchObjIds = searchObjCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            QFilter[] qFilters = new QFilter[]{new QFilter("searchobj", "in", searchObjIds), new QFilter("controltype", "=", (Object)FieldControlType.TEXT.getValue())};
            DynamicObject[] queryFieldDys = this.queryFieldHelper.query("id, entitynumber, fieldpath, complextype, controltype", qFilters);
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            HashMap entityMetadataMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap metadataNumberToIdMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject queryFieldDy : queryFieldDys) {
                try {
                    String entityNumber = queryFieldDy.getString("entitynumber");
                    MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
                    SearchObjFieldControlTypeUpdateTask.getEntityMetadata(entityNumber, entityMetadataMap, metadataNumberToIdMap);
                    String fieldPath = queryFieldDy.getString("fieldpath");
                    String complexType = queryFieldDy.getString("complextype");
                    String fieldControlType = AnalyseObjectUtil.getFieldControlType((MainEntityType)mainEntityType, (Map)entityMetadataMap, (Map)metadataNumberToIdMap, (String)fieldPath, (String)complexType, (MainEntityTypeUtil)mainEntityTypeUtil);
                    if (!HRStringUtils.equals((String)fieldControlType, (String)FieldControlType.TEXT.getValue())) {
                        LOGGER.info("SearchObjFieldControlTypeUpdateTask update queryFieldId:{}, controlType:{}", (Object)queryFieldDy.getLong("id"), (Object)fieldControlType);
                    }
                    queryFieldDy.set("controltype", (Object)fieldControlType);
                }
                catch (Exception exception) {
                    LOGGER.error((Throwable)exception);
                }
            }
            this.queryFieldHelper.save(queryFieldDys);
            this.deleteSchedule();
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private static void getEntityMetadata(String entityNum, Map<String, EntityMetadata> entityMetadataMap, Map<String, String> metadataNumberToIdMap) {
        EntityMetadata entityMetadata = entityMetadataMap.get(entityNum);
        if (entityMetadata == null) {
            String metadataId = metadataNumberToIdMap.get(entityNum);
            if (metadataId == null) {
                metadataId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
                metadataNumberToIdMap.put(entityNum, metadataId);
            }
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Entity);
            entityMetadataMap.put(entityNum, entityMetadata);
        }
    }

    private void deleteSchedule() {
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper("sch_schedule");
        scheduleHelper.deleteByFilter(new QFilter[]{new QFilter("number", "=", (Object)"hrss_queryfield_SKDP_S")});
    }
}

