/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.preset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PresetDataChangedService {
    private static final Log LOGGER = LogFactory.getLog(PresetDataChangedService.class);
    private static final HRBaseServiceHelper PRESET_CHANGED = new HRBaseServiceHelper("hrcs_presetchange");
    private static final HRBaseServiceHelper HBSS_LOG_VIEW = new HRBaseServiceHelper("hbss_logview");
    private static final HRBaseServiceHelper SEARCH_SCENE = new HRBaseServiceHelper("hrss_searchscene");
    private static final HRBaseServiceHelper SEARCH_OBJECT = new HRBaseServiceHelper("hrss_searchobject");

    public static void doPresetDataChanged(DynamicObject dyObj) {
        long searchObjId;
        if (!dyObj.containsProperty("issyspreset")) {
            return;
        }
        String currObjType = dyObj.getDataEntityType().getName();
        String isPreset = dyObj.getString("issyspreset");
        if ("false".equals(isPreset) || "0".equals(isPreset)) {
            if (!"hrss_searchscene".equals(currObjType)) {
                return;
            }
            Object sObj = dyObj.get("searchobj");
            long searchObjId2 = PresetDataChangedService.getIdFromObj(sObj);
            DynamicObject searchObj = SEARCH_OBJECT.queryOne("id,issyspreset", (Object)searchObjId2);
            String isPresetSObj = searchObj.getString("issyspreset");
            if ("false".equals(isPresetSObj) || "0".equals(isPresetSObj)) {
                return;
            }
        }
        if ("hrss_searchscene".equals(currObjType)) {
            Object sObj = dyObj.get("searchobj");
            searchObjId = PresetDataChangedService.getIdFromObj(sObj);
        } else if ("hrss_searchweight".equals(currObjType) || "hrss_searchwtgrade".equals(currObjType)) {
            long sceneId = PresetDataChangedService.getIdFromObj(dyObj.get("usescene"));
            DynamicObject sceneObj = SEARCH_SCENE.queryOriginalOne("id,number,searchobj", (Object)sceneId);
            Object sObj = sceneObj.get("searchobj");
            searchObjId = PresetDataChangedService.getIdFromObj(sObj);
        } else if ("hrss_searchobject".equals(currObjType)) {
            searchObjId = (Long)dyObj.getPkValue();
        } else {
            return;
        }
        QFilter searchObjTypeFilter = new QFilter("basedata", "=", (Object)"hrss_searchobject");
        QFilter searchObjIdFilter = new QFilter("bdid", "=", (Object)searchObjId);
        boolean existChange = PRESET_CHANGED.isExists(new QFilter[]{searchObjTypeFilter, searchObjIdFilter});
        if (existChange) {
            return;
        }
        if ("hrss_searchobject".equals(currObjType)) {
            PresetDataChangedService.savePresetChangeLog(searchObjId);
        } else {
            PresetDataChangedService.checkAndSavePresetLog(searchObjId, currObjType, (Long)dyObj.getPkValue());
        }
    }

    private static void checkAndSavePresetLog(long searchObjId, String currObjType, long currObjId) {
        ThreadPools.executeOnce((String)"PresetDataChanged_check", () -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                LOGGER.warn("thread wait Exception: ", (Throwable)exception);
            }
            QFilter bizObj = new QFilter("bizobj", "=", (Object)currObjType);
            QFilter bizObjId = new QFilter("modifybillid", "=", (Object)String.valueOf(currObjId));
            DynamicObject operLogs2 = HBSS_LOG_VIEW.queryOriginalOne("id,bizobj,modifybillid,modifycontent", new QFilter[]{bizObj, bizObjId}, "id desc");
            if (operLogs2 == null || StringUtils.isEmpty((String)operLogs2.getString("modifycontent"))) {
                if (!"hrss_searchscene".equals(currObjType)) {
                    return;
                }
                QFilter bizObjIdAdd = new QFilter("modifybillid", "=", (Object)(String.valueOf(currObjId) + "+"));
                DynamicObject operLogsAdd = HBSS_LOG_VIEW.queryOriginalOne("id,bizobj,modifybillid,modifycontent", new QFilter[]{bizObj, bizObjIdAdd}, "id desc");
                if (operLogsAdd == null || StringUtils.isEmpty((String)operLogsAdd.getString("modifycontent"))) {
                    return;
                }
                operLogs2 = operLogsAdd;
            }
            String content = operLogs2.getString("modifycontent");
            JSONObject modifyJson = JSON.parseObject((String)content);
            PresetDataChangedService.filterNotNeedKeys(new String[]{"c", "k", "creator", "modifier", "disabler", "createtime", "modifytime", "disabledate", "status", "enable"}, modifyJson);
            if (modifyJson.isEmpty()) {
                return;
            }
            PresetDataChangedService.savePresetChangeLog(searchObjId);
        });
    }

    private static void savePresetChangeLog(long searchObjId) {
        try {
            DynamicObject presetObj = PRESET_CHANGED.generateEmptyDynamicObject();
            DynamicObject searchObj = SEARCH_OBJECT.queryOne("id,number,name", (Object)searchObjId);
            presetObj.set("basedata", (Object)"hrss_searchobject");
            presetObj.set("basedataname", (Object)searchObj.getDataEntityType().getDisplayName().getLocaleValue());
            presetObj.set("bdid", (Object)searchObjId);
            presetObj.set("bdnumber", (Object)searchObj.getString("number"));
            presetObj.set("bdname", (Object)searchObj.getString("name"));
            presetObj.set("ischange", (Object)"1");
            presetObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            PRESET_CHANGED.saveOne(presetObj);
        }
        catch (Exception exception) {
            LOGGER.error("savePresetChangeLog Exception: ", (Throwable)exception);
        }
    }

    private static long getIdFromObj(Object obj) {
        long searchObjId = 0L;
        if (obj instanceof DynamicObject) {
            searchObjId = (Long)((DynamicObject)obj).getPkValue();
        } else if (obj instanceof Long) {
            searchObjId = (Long)obj;
        }
        return searchObjId;
    }

    private static void filterNotNeedKeys(String[] filterKeys, JSONObject modifyJson) {
        if (filterKeys == null || filterKeys.length < 1) {
            return;
        }
        for (String key : filterKeys) {
            modifyJson.remove((Object)key);
        }
    }
}

