/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ArrayUtils;

public final class AIAnalysisUtil {
    private static final Double DEST = 0.75;
    private static final int INT_TEN = 10;

    private AIAnalysisUtil() {
    }

    public static boolean isSimilarByStringArray(String input, String value) {
        StringBuilder target = new StringBuilder(value.length());
        Object[] arr = input.split(" ");
        if (ArrayUtils.isEmpty((Object[])arr)) {
            return false;
        }
        if (arr.length == 1) {
            return AIAnalysisUtil.similar((String)arr[0], value) >= DEST;
        }
        for (Object str : arr) {
            if (AIAnalysisUtil.similar((String)str, value) >= DEST) {
                return true;
            }
            if (!value.contains((CharSequence)str) && !((String)str).contains(value)) continue;
            target.append((String)(value.length() >= ((String)str).length() ? str : value));
        }
        double similar = AIAnalysisUtil.similar(target.toString(), value);
        return similar >= DEST;
    }

    public static boolean isSimilarKeyWord(String strA, String strB) {
        return AIAnalysisUtil.similar(strA, strB) >= DEST;
    }

    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = AIAnalysisUtil.removeSign(strB);
            newStrB = AIAnalysisUtil.removeSign(strA);
        } else {
            newStrA = AIAnalysisUtil.removeSign(strA);
            newStrB = AIAnalysisUtil.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int temp2 = AIAnalysisUtil.longestCommonSubstring(newStrA, newStrB).length();
        return AIAnalysisUtil.div(new BigDecimal(Integer.toString(temp2)), new BigDecimal(Integer.toString(temp)), 10, RoundingMode.HALF_UP).doubleValue();
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (!AIAnalysisUtil.isValidChar(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int mc = chars_strA.length;
        int nc = chars_strB.length;
        int[][] matrix = new int[mc + 1][nc + 1];
        for (int i = 1; i <= mc; ++i) {
            for (int j = 1; j <= nc; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[mc][nc]];
        int currentIndex = result.length - 1;
        while (matrix[mc][nc] != 0) {
            if (matrix[mc][nc] == matrix[mc][nc - 1]) {
                --nc;
                continue;
            }
            if (matrix[mc][nc] == matrix[mc - 1][nc]) {
                --mc;
                continue;
            }
            result[currentIndex] = chars_strA[mc - 1];
            --currentIndex;
            --nc;
            --mc;
        }
        return new String(result);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        if (v2 == null) {
            throw new IllegalArgumentException("Divisor must be not null !");
        }
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }
}

