/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.opplugin.web.capacity;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageRangeTypeEnum;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageTypeEnum;
import kd.hr.hrti.opplugin.web.capacity.validate.CapacityStorageSaveValidator;

public class CapacityStorageSaveOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"isadminnot", "isadmintrue", "isadminfalse", "entryentity", "capitem", "type", "rangetype", "post", "designorg", "jobscm", "capstorjobseq", "capstorjobfamily", "capstorjobclass", "capjob", "country"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CapacityStorageSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(args);
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            DynamicObjectCollection country;
            String type = dataEntity.getString("type");
            String rangeType = dataEntity.getString("rangetype");
            if (type.equals(CapacityStorageTypeEnum.PROFESSIONAL.getNumber())) {
                if (CapacityStorageRangeTypeEnum.JOB.getNumber().equals(rangeType)) {
                    dataEntity.set("post", null);
                }
                if (CapacityStorageRangeTypeEnum.POST.getNumber().equals(rangeType)) {
                    dataEntity.set("designorg", null);
                    dataEntity.set("jobscm", null);
                    dataEntity.set("capstorjobseq", null);
                    dataEntity.set("capstorjobfamily", null);
                    dataEntity.set("capstorjobclass", null);
                    dataEntity.set("capjob", null);
                }
            }
            if (!type.equals(CapacityStorageTypeEnum.GENERAL.getNumber()) || null == (country = dataEntity.getDynamicObjectCollection("country")) || country.size() <= 0) continue;
            dataEntity.set("country", null);
        }
    }
}

