/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.metadata.form.container.FlexPanelAp;

public class FormCommonService {
    public FlexPanelAp createFlexPanelAp(String key) {
        FlexPanelAp containerAp = new FlexPanelAp();
        containerAp.setKey(key);
        containerAp.setDirection("row");
        containerAp.setJustifyContent("flex-start");
        containerAp.setAlignItems("stretch");
        containerAp.setOverflow("visible");
        containerAp.setWrap(false);
        return containerAp;
    }

    public FlexPanelAp createParentFlexPanelAp(String key) {
        FlexPanelAp containerAp = new FlexPanelAp();
        containerAp.setKey(key);
        containerAp.setDirection("column");
        containerAp.setJustifyContent("flex-start");
        containerAp.setAlignItems("stretch");
        containerAp.setWrap(false);
        return containerAp;
    }

    public void showInfoDetailCard(IFormView view, String targetKey, String formId, Map<String, Object> customMap) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId(formId);
        fsp.setCustomParams(customMap);
        view.showForm(fsp);
    }

    public void buildInfoDetailFlex(IFormView view, String sortInfoListStr, String formId) {
        String targetKey;
        int i;
        List sortInfoList = (List)SerializationUtils.fromJsonString((String)sortInfoListStr, List.class);
        FlexPanelAp parentPanelAp = this.createParentFlexPanelAp("infoflex");
        for (i = 0; i < sortInfoList.size(); ++i) {
            targetKey = "infoflex" + i;
            FlexPanelAp flexPanelAp = this.createFlexPanelAp(targetKey);
            parentPanelAp.getItems().add(flexPanelAp);
        }
        view.updateControlMetadata("infoflex", parentPanelAp.createControl());
        for (i = 0; i < sortInfoList.size(); ++i) {
            targetKey = "infoflex" + i;
            HashMap customMap = Maps.newHashMap();
            customMap.put("data", sortInfoList);
            customMap.put("currSize", i);
            this.showInfoDetailCard(view, targetKey, formId, customMap);
        }
    }

    public void showMoreLabel(BeforeShowTipsEvent evt, String labelKey, String moreLabel) {
        String key = ((Control)evt.getSource()).getKey();
        if (labelKey.equals(key)) {
            FormShowParameter fsp = evt.getFormshowParameter();
            if (fsp == null) {
                fsp = new FormShowParameter();
                evt.setFormshowParameter(fsp);
            }
            Object[] split = moreLabel.split("\u3001");
            fsp.setCustomParam("moreLabel", (Object)SerializationUtils.serializeToBase64((Object)Lists.newArrayList((Object[])split)));
        }
    }
}

