/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.capacity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrti.bussiness.application.CapacityApplicationService;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HbjmJobApplicationService;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageRangeTypeEnum;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageTypeEnum;
import kd.hr.hrti.common.util.CommUtils;

public class CapacityStoragePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log logger = LogFactory.getLog(CapacityApplicationService.class);
    private final HbjmJobApplicationService hbjmJobApplicationService = (HbjmJobApplicationService)ServiceFactory.getService(HbjmJobApplicationService.class);

    public void registerListener(EventObject object) {
        super.registerListener(object);
        BasedataEdit jobScm = (BasedataEdit)this.getControl("jobscm");
        jobScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit capstorjobseq = (MulBasedataEdit)this.getControl("capstorjobseq");
        capstorjobseq.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit capstorjobfamily = (MulBasedataEdit)this.getControl("capstorjobfamily");
        capstorjobfamily.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit capstorjobclass = (MulBasedataEdit)this.getControl("capstorjobclass");
        capstorjobclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit capjob = (MulBasedataEdit)this.getControl("capjob");
        capjob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        capjob.addAfterF7SelectListener((AfterF7SelectListener)this);
        MulBasedataEdit items = (MulBasedataEdit)this.getControl("capitemclick");
        items.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("addentry".equals(itemKey)) {
            this.setCapcityItemsValue();
            MulBasedataEdit capItemClick = (MulBasedataEdit)this.getControl("capitemclick");
            capItemClick.click();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.setCapcityItemsValue();
        }
    }

    private void setCapcityItemsValue() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        Long[] capItemIds = (Long[])this.getModel().getEntryEntity("entryentity").stream().map(dynamicObject -> dynamicObject.getLong("capitem_id")).toArray(Long[]::new);
        this.getModel().setValue("capitemclick", (Object)capItemIds);
        CommUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"capitemclick"});
        model.endInit();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showSubjectRangeChange();
        this.showCountryAndOrgNot();
        this.jobAndPostMustInput();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.fieldDoEnable("designorg", "jobscm");
            this.fieldDoEnable("jobscm", "capstorjobseq");
            this.mulFieldDoEnable("capstorjobseq", "capstorjobfamily");
            this.mulFieldDoEnable("capstorjobfamily", "capstorjobclass");
            this.mulFieldDoEnable("capstorjobclass", "capjob");
        }
        this.getModel().setDataChanged(false);
    }

    private void showCountryAndOrgNot() {
        DynamicObjectCollection country = (DynamicObjectCollection)this.getModel().getValue("country");
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("capacityorg");
        if (country.size() > 0) {
            this.getModel().setValue("countrynot", (Object)false);
        }
        if (org.size() > 0) {
            this.getModel().setValue("orgnot", (Object)false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IPageCache pageCache = this.getView().getPageCache();
        String name = args.getProperty().getName();
        if ("type".equals(name)) {
            this.showSubjectRangeChange();
            this.setValueBySubjectRangeChange();
        }
        this.setContryControlVisible(name);
        this.setOrgControlVisible(name);
        this.setAdminControlVisible(name);
        if ("designorg".equals(name)) {
            this.fieldDoEnable("designorg", "jobscm");
        }
        if ("jobscm".equals(name)) {
            this.fieldDoEnable("jobscm", "capstorjobseq");
            this.fieldDoEnable("jobscm", "capjob");
        }
        if ("capstorjobseq".equals(name)) {
            if (!"true".equals(pageCache.get("capstorjobseq"))) {
                this.getModel().setValue("capjob", null);
            } else {
                pageCache.put("capstorjobseq", null);
            }
            this.mulFieldDoEnable("capstorjobseq", "capstorjobfamily");
        }
        if ("capstorjobfamily".equals(name)) {
            if (!"true".equals(pageCache.get("capstorjobfamily"))) {
                this.getModel().setValue("capjob", null);
            } else {
                pageCache.put("capstorjobfamily", null);
            }
            this.mulFieldDoEnable("capstorjobfamily", "capstorjobclass");
        }
        if ("capstorjobclass".equals(name)) {
            if (!"true".equals(pageCache.get("capstorjobclass"))) {
                this.getModel().setValue("capjob", null);
            } else {
                pageCache.put("capstorjobclass", null);
            }
        }
        if ("capitemclick".equals(name)) {
            MulBasedataDynamicObjectCollection value = (MulBasedataDynamicObjectCollection)this.getModel().getValue("capitemclick");
            List<Long> capacityItemIds = value.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
            this.setCapacityItemEntity(capacityItemIds);
        }
        if ("rangetype".equals(name)) {
            Map promptMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "hintap", this.getModel().getDataEntity()});
            logger.info("\u80fd\u529b\u5e93\u63d0\u793a\u8bed\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + (CollectionUtils.isEmpty((Map)promptMap) ? promptMap : promptMap.toString()));
            Hint hint = (Hint)this.getControl("hintap");
            for (Map.Entry entry : promptMap.entrySet()) {
                hint.setContent((Long)entry.getKey(), (String)entry.getValue());
            }
            this.jobAndPostMustInput();
            this.cleanProfessionalControl();
        }
    }

    private void setValueBySubjectRangeChange() {
        String type = (String)this.getModel().getValue("type");
        if (CapacityStorageTypeEnum.PROFESSIONAL.getNumber().equals(type)) {
            this.getModel().setValue("countrynot", (Object)true);
            this.getModel().setValue("orgnot", (Object)true);
            this.getModel().setValue("country", null);
            this.getModel().setValue("capacityorg", null);
            this.getModel().setValue("isadminnot", (Object)true);
            this.getModel().setValue("isadminfalse", (Object)false);
            this.getModel().setValue("isadmintrue", (Object)false);
        } else if (CapacityStorageTypeEnum.GENERAL.getNumber().equals(type) || CapacityStorageTypeEnum.MANAGEAL.getNumber().equals(type)) {
            this.cleanProfessionalControl();
        }
    }

    private void cleanProfessionalControl() {
        this.getModel().setValue("designorg", null);
        this.getModel().setValue("jobscm", null);
        this.getModel().setValue("capstorjobseq", null);
        this.getModel().setValue("capstorjobfamily", null);
        this.getModel().setValue("capstorjobclass", null);
        this.getModel().setValue("capjob", null);
        this.getModel().setValue("post", null);
    }

    private void setAdminControlVisible(String name) {
        if ("isadminnot".equals(name) && ((Boolean)this.getModel().getValue("isadminnot")).booleanValue()) {
            this.getModel().setValue("isadmintrue", (Object)false);
            this.getModel().setValue("isadminfalse", (Object)false);
        }
        if ("isadmintrue".equals(name) && ((Boolean)this.getModel().getValue("isadmintrue")).booleanValue()) {
            this.getModel().setValue("isadminnot", (Object)false);
            this.getModel().setValue("isadminfalse", (Object)false);
        }
        if ("isadminfalse".equals(name) && ((Boolean)this.getModel().getValue("isadminfalse")).booleanValue()) {
            this.getModel().setValue("isadminnot", (Object)false);
            this.getModel().setValue("isadmintrue", (Object)false);
        }
    }

    private void setContryControlVisible(String name) {
        if ("countrynot".equals(name)) {
            Boolean countryNot = (Boolean)this.getModel().getValue("countrynot");
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("country");
            if (countryNot.booleanValue()) {
                mulBasedataEdit.setMustInput(false);
                this.getModel().setValue("country", null);
                this.getView().updateView("country");
            } else {
                mulBasedataEdit.setMustInput(true);
            }
        }
    }

    private void setOrgControlVisible(String name) {
        if ("orgnot".equals(name)) {
            Boolean orgNot = (Boolean)this.getModel().getValue("orgnot");
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("capacityorg");
            if (orgNot.booleanValue()) {
                mulBasedataEdit.setMustInput(false);
                this.getModel().setValue("capacityorg", null);
                this.getView().updateView("capacityorg");
            } else {
                mulBasedataEdit.setMustInput(true);
            }
        }
    }

    private void setCapacityItemEntity(List<Long> capacityItemIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        if (CollectionUtils.isEmpty(capacityItemIds)) {
            return;
        }
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("capitem", new Object[0]);
        for (Long id : capacityItemIds) {
            setter.addRow(new Object[]{id});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void jobAndPostMustInput() {
        BasedataEdit designOrg = (BasedataEdit)this.getControl("designorg");
        BasedataEdit jobScm = (BasedataEdit)this.getControl("jobscm");
        BasedataEdit jobSeq = (BasedataEdit)this.getControl("capstorjobseq");
        BasedataEdit post = (BasedataEdit)this.getControl("post");
        if (CapacityStorageRangeTypeEnum.JOB.getNumber().equals(this.getModel().getValue("rangetype"))) {
            designOrg.setMustInput(true);
            jobScm.setMustInput(true);
            jobSeq.setMustInput(true);
            post.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"joblabelap", "postlabelap"});
        }
        if (CapacityStorageRangeTypeEnum.POST.getNumber().equals(this.getModel().getValue("rangetype"))) {
            designOrg.setMustInput(false);
            jobScm.setMustInput(false);
            jobSeq.setMustInput(false);
            post.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"joblabelap", "postlabelap"});
        }
        if (CapacityStorageRangeTypeEnum.JOBANDPOST.getNumber().equals(this.getModel().getValue("rangetype"))) {
            designOrg.setMustInput(true);
            jobScm.setMustInput(true);
            jobSeq.setMustInput(true);
            post.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"joblabelap", "postlabelap"});
        }
    }

    private void fieldDoEnable(String field, String nextField) {
        DynamicObject fieldObj = (DynamicObject)this.getModel().getValue(field);
        if (fieldObj == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{nextField});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{nextField});
        }
        this.getModel().setValue(nextField, null);
    }

    private void mulFieldDoEnable(String field, String nextField) {
        DynamicObjectCollection fieldList = (DynamicObjectCollection)this.getModel().getValue(field);
        if (fieldList.size() > 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{nextField});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{nextField});
        }
        this.getModel().setValue(nextField, null);
    }

    private void showSubjectRangeChange() {
        String type = (String)this.getModel().getValue("type");
        if (CapacityStorageTypeEnum.PROFESSIONAL.getNumber().equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"subjectrange0"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"subjectrange1"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"subjectrange0"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"subjectrange1"});
            if (CapacityStorageTypeEnum.GENERAL.getNumber().equals(type)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            } else if (CapacityStorageTypeEnum.MANAGEAL.getNumber().equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject jobScm;
        String name = beforeF7SelectEvent.getProperty().getName();
        Long userId = RequestContext.get().getCurrUserId();
        if ("capitemclick".equals(name)) {
            String appId = AppMetadataCache.getAppInfo((String)"tdcs").getId();
            QFilter dataRuleFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, "hbss_capacityitem", "47150e89000000ac", null});
            if (null != dataRuleFilter) {
                beforeF7SelectEvent.addCustomQFilter(dataRuleFilter);
            }
        }
        if ("jobscm".equals(name)) {
            DynamicObject designorg = (DynamicObject)this.getModel().getValue("designorg");
            QFilter jobscmhrFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hbjm_jobscmhr", (Long)designorg.getLong("id"));
            beforeF7SelectEvent.addCustomQFilter(jobscmhrFilter);
        }
        if ("capstorjobseq".equals(name)) {
            jobScm = (DynamicObject)this.getModel().getValue("jobscm");
            DynamicObject[] scmAndSeqRelation = this.hbjmJobApplicationService.getScmAndSeqRelation((List)Lists.newArrayList((Object[])new Long[]{jobScm.getLong("id")}));
            List jobSeqIds = Arrays.stream(scmAndSeqRelation).map(item -> item.getLong("jobseq.id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", jobSeqIds));
        }
        if ("capstorjobfamily".equals(name)) {
            DynamicObjectCollection jobSeq = (DynamicObjectCollection)this.getModel().getValue("capstorjobseq");
            List jobSeqIds = jobSeq.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            DynamicObject[] familyBySeq = this.hbjmJobApplicationService.getFamilyBySeq(jobSeqIds);
            List jobFamilyIds = Arrays.stream(familyBySeq).map(item -> item.getLong("jobfamily.id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", jobFamilyIds));
        }
        if ("capstorjobclass".equals(name)) {
            DynamicObjectCollection jobFamily = (DynamicObjectCollection)this.getModel().getValue("capstorjobfamily");
            List jobFamilyIds = jobFamily.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            DynamicObject[] classByFamily = this.hbjmJobApplicationService.getClassByFamily(jobFamilyIds);
            List jobClassIds = Arrays.stream(classByFamily).map(item -> item.getLong("jobclass.id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", jobClassIds));
        }
        if ("capjob".equals(name)) {
            DynamicObjectCollection jobClass;
            List jobClassIds;
            DynamicObjectCollection jobFamily;
            List jobFamilyIds;
            jobScm = (DynamicObject)this.getModel().getValue("jobscm");
            long jobscmId = jobScm.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getShowParameter().setCustomParam("selectedJobscmid", (Object)jobscmId);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("jobscm", "=", (Object)jobscmId));
            DynamicObjectCollection jobSeq = (DynamicObjectCollection)this.getModel().getValue("capstorjobseq");
            List jobSeqIds = jobSeq.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(jobSeqIds)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("jobseq", "in", jobSeqIds));
            }
            if (!CollectionUtils.isEmpty(jobFamilyIds = (jobFamily = (DynamicObjectCollection)this.getModel().getValue("capstorjobfamily")).stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()))) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("jobfamily", "in", jobFamilyIds));
            }
            if (!CollectionUtils.isEmpty(jobClassIds = (jobClass = (DynamicObjectCollection)this.getModel().getValue("capstorjobclass")).stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()))) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("jobclass", "in", jobClassIds));
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        IPageCache pageCache = this.getView().getPageCache();
        Object source = afterF7SelectEvent.getSource();
        String key = null;
        if (source instanceof MulBasedataEdit) {
            key = ((MulBasedataEdit)source).getKey();
        }
        if ("capjob".equals(key)) {
            MulBasedataDynamicObjectCollection value = (MulBasedataDynamicObjectCollection)this.getModel().getValue("capjob");
            List capJobIds = value.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (capJobIds.size() > 0) {
                DynamicObject[] jobHrData = this.hbjmJobApplicationService.getJobHrData(capJobIds);
                HashSet<Long> jobSeqIds = new HashSet<Long>(16);
                HashSet<Long> jobFamilyIds = new HashSet<Long>(16);
                HashSet<Long> jobClassIds = new HashSet<Long>(16);
                for (DynamicObject dynamicObject2 : jobHrData) {
                    jobSeqIds.add(dynamicObject2.getLong("jobseq"));
                    jobFamilyIds.add(dynamicObject2.getLong("jobfamily"));
                    jobClassIds.add(dynamicObject2.getLong("jobclass"));
                }
                pageCache.put("capstorjobseq", "true");
                this.getModel().setValue("capstorjobseq", (Object)jobSeqIds.toArray());
                pageCache.put("capstorjobfamily", "true");
                this.getModel().setValue("capstorjobfamily", (Object)jobFamilyIds.toArray());
                pageCache.put("capstorjobclass", "true");
                this.getModel().setValue("capstorjobclass", (Object)jobClassIds.toArray());
            }
            this.getModel().setValue("capjob", (Object)capJobIds.toArray());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CommUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"capitemclick"});
    }
}

