/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.CustomCardConfigPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.BizApplicationService;
import kd.hr.hrti.formplugin.web.portrait.CardFormListPlugin;

public class CardConfigPlugin
extends CustomCardConfigPlugin {
    private static final Log LOG = LogFactory.getLog(CardFormListPlugin.class);
    private static final BizApplicationService BIZ_SERVICE = (BizApplicationService)ServiceFactory.getService(BizApplicationService.class);

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("cardformname")) {
            this.showCustomFormList();
        } else {
            super.click(evt);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String cache_tempDel = this.getView().getParentView().getPageCache().get("cache_TempDel");
        ArrayList cacheCardIds = HRStringUtils.isEmpty((String)cache_tempDel) ? Lists.newArrayList() : (List)SerializationUtils.fromJsonString((String)cache_tempDel, List.class);
        String cache_allCardConfig = this.getView().getParentView().getPageCache().get("cache_allCardConfig");
        HashMap allCardConfigMap = HRStringUtils.isEmpty((String)cache_allCardConfig) ? Maps.newHashMap() : (Map)SerializationUtils.fromJsonString((String)cache_allCardConfig, Map.class);
        cacheCardIds.forEach(allCardConfigMap::remove);
        HashSet cardFormNumList = Sets.newHashSetWithExpectedSize((int)allCardConfigMap.size());
        allCardConfigMap.forEach((cardId, cardInfo) -> {
            try {
                cardFormNumList.add((String)((Map)HRJSONUtils.cast((String)cardInfo, Map.class)).get("cardformnum"));
            }
            catch (IOException exception) {
                LOG.error("parse-cardFormNum-error");
            }
        });
        String appId = AppMetadataCache.getAppInfo((String)"hrti").getId();
        List formIds = BizAppServiceHelp.getFormsIdByAppId((String)appId);
        DynamicObject[] formMetadataInfo = BIZ_SERVICE.queryFormInfoByFormIds(formIds);
        List allPortraitCardInfo = Arrays.stream(formMetadataInfo).filter(infoDy -> "/910EZ6ZX680".equals(infoDy.getString("inheritpath"))).filter(infoDy -> !infoDy.getString("type").equals("2")).collect(Collectors.toList());
        List filterInfo = allPortraitCardInfo.stream().filter(infoDy -> !cardFormNumList.contains(infoDy.getString("number"))).collect(Collectors.toList());
        List filterIds = filterInfo.stream().map(info -> info.getString("id")).collect(Collectors.toList());
        LOG.info(filterIds.toString());
        int allPortraitCardNum = allPortraitCardInfo.size();
        int selectNum = cardFormNumList.size();
        Label tips = (Label)this.getControl("tips");
        tips.setText(ResManager.loadKDString((String)"\u5e73\u53f0\u5171\u63d0\u4f9b{0}\u4e2a\u5361\u7247\u4f9b\u9009\u62e9\uff0c\u5df2\u9009{1}\u4e2a\u5361\u7247\uff0c\u8fd8\u53ef\u9009{2}\u4e2a\u5361\u7247\u3002", (String)"CardConfigPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[]{allPortraitCardNum, selectNum, allPortraitCardNum - selectNum}));
        this.getPageCache().put("filterIds", SerializationUtils.serializeToBase64(filterIds));
    }

    private void showCustomFormList() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hrti_card_custformlist");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cardformlist"));
        fsp.setCustomParam("filterIds", (Object)this.getPageCache().get("filterIds"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent eve) {
        Map returnMap;
        if ("cardformlist".equals(eve.getActionId()) && !CollectionUtils.isEmpty((Map)(returnMap = (Map)eve.getReturnData()))) {
            String formNum = (String)returnMap.get("formNum");
            String formName = (String)returnMap.get("formName");
            this.getModel().setValue("cardtitle", (Object)formName);
            this.getModel().setValue("cardformnum", (Object)formNum);
            this.getModel().setValue("cardformname", (Object)formName);
        }
    }
}

