/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.BizApplicationService;

public class WorkBenchPlugin
extends GridContainerPlugin
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(WorkBenchPlugin.class);
    private static final BizApplicationService BIZ_SERVICE = (BizApplicationService)ServiceFactory.getService(BizApplicationService.class);
    private static final Long DEFAULT_ID = 1585418459888582656L;

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("customParams:{}", (Object)customParams);
        if (!CollectionUtils.isEmpty((Map)customParams)) {
            Object strSchemeObj;
            boolean isView;
            Object operationStatus = customParams.get("status");
            boolean bl = isView = !Objects.isNull(operationStatus) && OperationStatus.VIEW.toString().equals(operationStatus.toString());
            if (isView) {
                strSchemeObj = customParams.get("strSchemeId");
            } else {
                Long l = strSchemeObj = Objects.isNull(customParams.get("strSchemeId")) ? DEFAULT_ID : customParams.get("strSchemeId");
                if (strSchemeObj instanceof String) {
                    strSchemeObj = HRStringUtils.isEmpty((String)strSchemeObj.toString()) ? DEFAULT_ID : Long.valueOf(Long.parseLong(strSchemeObj.toString()));
                }
                this.getView().addClientCallBack("action", Integer.valueOf(0));
            }
            logger.info("strSchemeObj:{}", strSchemeObj);
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle(strSchemeObj, (String)"portal_scheme", (String)"id,layout,schemetype,ismultiorg");
            if (!Objects.isNull(schemeObj)) {
                logger.info("schemeObj:{}", (Object)schemeObj);
                this.refreshGridContainer(schemeObj);
                this.getView().setVisible(Boolean.valueOf(!isView), new String[]{"floatmenu"});
                return;
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"floatmenu"});
        super.afterCreateNewData(e);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (HRStringUtils.equals((String)e.getName(), (String)"action")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u89c6\u56fe\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"WorkBenchPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[0])), 3000);
            this.changeToDesignMode();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Map paramMap = evt.getParamsMap();
        String key = evt.getItemKey();
        if ("addCard".equals(key)) {
            if (paramMap.get("layout") != null) {
                this.getPageCache().put("layout", paramMap.get("layout").toString());
            }
            this.showNewCardTypeForm(null);
        } else if ("editEnd".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String layout = (String)paramMap.get("layout");
            List newLayoutList = (List)SerializationUtils.fromJsonString((String)layout, List.class);
            List tempDelIds = this.getTempDelIds();
            newLayoutList.removeIf(value -> tempDelIds.contains((String)value.get("i")));
            layout = SerializationUtils.toJsonString((Object)newLayoutList);
            Map<String, String> allCardConfigMap = this.clearCache();
            DynamicObject dynamicObject = this.buildSaveAsSchemObj(customParams);
            CardUtils cardUtils = new CardUtils(this.getView(), this.getPageCache(), this.getModel(), logger);
            boolean success = cardUtils.saveMainPageInfo(SchemeType.GroupScheme, layout, allCardConfigMap, null, dynamicObject);
            if (success) {
                String strSchemeId = BIZ_SERVICE.queryNewestSchemeIdByNumber(String.valueOf(customParams.get("number")));
                if (HRStringUtils.isEmpty((String)strSchemeId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkBenchPlugin_1", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap returnMap = Maps.newHashMap();
                returnMap.put("strSchemeId", strSchemeId);
                this.getView().returnDataToParent((Object)returnMap);
                this.getView().close();
                this.getView().sendFormAction(this.getView());
            }
        } else if ("editCancel".equals(key)) {
            this.getView().close();
        } else if ("switch".equals(key)) {
            this.showSchemeSwitchList();
        } else {
            super.itemClick(evt);
        }
    }

    private void showSchemeSwitchList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"portal_scheme", (boolean)false);
        ArrayList rangeFilterList = Lists.newArrayList();
        String formNum = this.getView().getEntityId();
        rangeFilterList.add(new QFilter("formnum", "=", (Object)formNum).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("ispreset", "=", (Object)"1")));
        lsp.setListFilterParameter(new ListFilterParameter((List)rangeFilterList, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBack_getScheme"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object retDataObj = e.getReturnData();
        String actionId = e.getActionId();
        if (actionId.equals("CallBack_getScheme") && retDataObj instanceof ListSelectedRowCollection) {
            Long schemeId = Long.parseLong(((ListSelectedRowCollection)retDataObj).getPrimaryKeyValues()[0].toString());
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
            this.refreshGridContainer(schemeObj);
            this.getView().addClientCallBack("action", Integer.valueOf(0));
        } else {
            super.closedCallBack(e);
        }
    }

    private Map<String, String> clearCache() {
        Map allCardConfigMap = this.getAllCardConfigMap();
        List tempDelIds = this.getTempDelIds();
        Map cardPageMap = this.getCardPageMap();
        tempDelIds.forEach(allCardConfigMap::remove);
        tempDelIds.forEach(cardPageMap::remove);
        String jsonStr = SerializationUtils.toJsonString((Object)allCardConfigMap);
        this.getPageCache().put("cache_allCardConfig", jsonStr);
        this.setCardPageMap(cardPageMap);
        this.updateTempDelIds(new ArrayList());
        return allCardConfigMap;
    }

    private DynamicObject buildSaveAsSchemObj(Map<String, Object> customParams) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("pc_main_scheme_saveas");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("number", (Object)String.valueOf(customParams.get("number")));
        LocaleString localeString = new LocaleString();
        String strName = Objects.isNull(customParams.get("name")) ? "HP_" + System.currentTimeMillis() : customParams.get("name").toString();
        localeString.setLocaleValue(strName);
        dynamicObject.set("name", (Object)localeString);
        return dynamicObject;
    }

    public void showNewCardTypeForm(String cardTypeIndex) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hrti_customcard");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBack_showAddCardForm"));
        if (StringUtils.isNotEmpty((String)cardTypeIndex)) {
            fsp.setCustomParam("event_rtn_addcard", (Object)cardTypeIndex);
        }
        this.getView().showForm(fsp);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.ADDNEW);
    }
}

