/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class AllAppraisalResultPlugin
extends HRDynamicFormBasePlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        long employeeId = (Long)customParams.get("employee");
        this.showEntryEntity(employeeId);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showEntryEntity(long employeeId) {
        Object[] performanceList = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"IPerformanceService", (String)"listPerformanceByEmployee", (Object[])new Object[]{employeeId, null});
        if (HRArrayUtils.isEmpty((Object[])performanceList)) {
            return;
        }
        List<DynamicObject> sortedPList = Arrays.stream(performanceList).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("check_startdate"), Comparator.reverseOrder())).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("activityname", new Object[0]);
        setter.addField("range", new Object[0]);
        setter.addField("rangetype", new Object[0]);
        setter.addField("grade", new Object[0]);
        setter.addField("score", new Object[0]);
        setter.addField("rank", new Object[0]);
        sortedPList.forEach(dynamicObject -> {
            Date startDate = dynamicObject.getDate("check_startdate");
            Date endDate = dynamicObject.getDate("check_startdate");
            String cycle = ResManager.loadKDString((String)"{0} \u81f3 {1}", (String)"AllAppraisalResultPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")});
            BigDecimal score = dynamicObject.getBigDecimal("score");
            String scoreStr = score != null && !BigDecimal.ZERO.equals(score) ? score.setScale(2, RoundingMode.HALF_UP).toString() : "0";
            setter.addRow(new Object[]{dynamicObject.getString("checkname"), cycle, dynamicObject.getString("rangetype"), dynamicObject.getString("level"), scoreStr, ""});
        });
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

