/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class AllInventoryResultPlugin
extends HRDynamicFormBasePlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        long employeeId = (Long)customParams.get("employee");
        this.showEntryEntity(employeeId);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showEntryEntity(long employeeId) {
        Object[] dynamicObjects = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"IReviewResultService", (String)"listReviewResultByEmployee", (Object[])new Object[]{employeeId});
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            this.showCardEntry((DynamicObject[])dynamicObjects);
        }
    }

    private void showCardEntry(DynamicObject[] dynamicObjects) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("activename", new Object[0]);
        setter.addField("type", new Object[0]);
        setter.addField("finishtime", new Object[0]);
        setter.addField("dimension", new Object[0]);
        setter.addField("result", new Object[0]);
        List<DynamicObject> collect = Arrays.stream(dynamicObjects).sorted((a, b) -> b.getDate("actfinishdate").compareTo(a.getDate("actfinishdate"))).collect(Collectors.toList());
        collect.forEach(dynamicObject -> {
            String dimension = dynamicObject.getString("xdimname") + "/" + dynamicObject.getString("ydimname");
            setter.addRow(new Object[]{dynamicObject.get("activityname"), dynamicObject.get("reviewtypename"), dynamicObject.get("actfinishdate"), dimension, dynamicObject.get("reviewposition")});
        });
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

