/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;

public class CareerDevelopmentPlugin
extends HRDynamicFormBasePlugin
implements ClickListener {
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);

    public void beforeBindData(EventObject e) {
        long empId;
        List empJobRelInfo;
        super.beforeBindData(e);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        boolean empty = true;
        if (!(CollectionUtils.isEmpty((Map)customParams) || Objects.isNull(customParams.get("employee")) || CollectionUtils.isEmpty((Collection)(empJobRelInfo = EXTERNAL_SERVICE.listEmployeeAttachs(empId = Long.parseLong(String.valueOf(customParams.get("employee"))), "hrpi_empjobrel"))))) {
            Object[] gradeScmInfo;
            Map empJobRelInfoMap = (Map)empJobRelInfo.get(0);
            String jobClass = (String)empJobRelInfoMap.get("jobclass");
            this.getModel().setValue("jobclass", (Object)(HRStringUtils.isEmpty((String)jobClass) ? "-" : jobClass));
            String jobFamily = (String)empJobRelInfoMap.get("jobfamily");
            this.getModel().setValue("jobfamily", (Object)(HRStringUtils.isEmpty((String)jobFamily) ? "-" : jobFamily));
            String jobSeq = (String)empJobRelInfoMap.get("jobseq");
            this.getModel().setValue("jobseq", (Object)(HRStringUtils.isEmpty((String)jobSeq) ? "-" : jobSeq));
            String job = (String)empJobRelInfoMap.get("job");
            this.getModel().setValue("job", (Object)(HRStringUtils.isEmpty((String)job) ? "-" : job));
            Long jobLevelScmId = (Long)empJobRelInfoMap.get("joblevelscm_id");
            Long jobGradeScmId = (Long)empJobRelInfoMap.get("jobgradescm_id");
            if (jobLevelScmId != 0L) {
                Object[] levelScmInfo = EXTERNAL_SERVICE.queryJobLevelScm(jobLevelScmId);
                if (HRArrayUtils.isNotEmpty((Object[])levelScmInfo)) {
                    Map<String, Object> data;
                    Long jobLevelId = (Long)empJobRelInfoMap.get("joblevel_id");
                    List<DynamicObject> sortData = Arrays.stream(levelScmInfo).filter(item -> item.getBoolean("entryentity.joblevel_enable")).sorted(Comparator.comparing(item -> item.getInt("entryentity.joblevel_seq"))).collect(Collectors.toList());
                    int currSize = 0;
                    for (int i = 0; i < sortData.size(); ++i) {
                        if (((DynamicObject)sortData.get(i)).getLong("entryentity.entryboid") != jobLevelId.longValue()) continue;
                        currSize = i;
                        break;
                    }
                    if (!CollectionUtils.isEmpty(data = this.buildData(sortData, 0, currSize, "entryentity.joblevel_name"))) {
                        this.buildCustomControl(data);
                        empty = false;
                    }
                }
            } else if (jobGradeScmId != 0L && HRArrayUtils.isNotEmpty((Object[])(gradeScmInfo = EXTERNAL_SERVICE.queryJobGradeScm(jobGradeScmId)))) {
                Map<String, Object> data;
                Long jobGradeId = (Long)empJobRelInfoMap.get("jobgrade_id");
                List<DynamicObject> sortData = Arrays.stream(gradeScmInfo).filter(item -> item.getBoolean("entryentity.jobgrade_enable")).sorted(Comparator.comparing(item -> item.getInt("entryentity.jobgrade_seq"))).collect(Collectors.toList());
                int currSize = 0;
                for (int i = 0; i < sortData.size(); ++i) {
                    if (((DynamicObject)sortData.get(i)).getLong("entryentity.entryboid") != jobGradeId.longValue()) continue;
                    currSize = i;
                    break;
                }
                if (!CollectionUtils.isEmpty(data = this.buildData(sortData, 0, currSize, "entryentity.jobgrade_name"))) {
                    this.buildCustomControl(data);
                    empty = false;
                }
            }
            this.getModel().updateCache();
        }
        this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
    }

    private void buildCustomControl(Map<String, Object> data) {
        CustomControl kdTagCloud = (CustomControl)this.getView().getControl("kdDevChannel");
        HashMap sendData = Maps.newHashMap();
        sendData.put("code", 200);
        sendData.put("success", true);
        sendData.put("eventName", "loadData");
        sendData.put("eventStatus", "init");
        sendData.put("times", System.currentTimeMillis());
        sendData.put("data", data);
        kdTagCloud.setData((Object)sendData);
    }

    private Map<String, Object> buildData(List<DynamicObject> sortData, int i, int currSize, String nameField) {
        HashMap childMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(sortData)) {
            return childMap;
        }
        childMap.put("id", String.valueOf(sortData.get(i).get("entryentity.entryboid")));
        childMap.put("postName", sortData.get(i).getString(nameField));
        childMap.put("level", "");
        String status = i == currSize - 1 ? "1" : (i == currSize ? "2" : "0");
        childMap.put("status", status);
        if (++i < sortData.size()) {
            Map<String, Object> returnMap = this.buildData(sortData, i, currSize, nameField);
            ArrayList childList = Lists.newArrayList();
            childList.add(returnMap);
            childMap.put("children", childList);
        }
        return childMap;
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        String key = args.getKey();
        String eventName = args.getEventName();
        String eventArgs = args.getEventArgs();
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        switch (eventName) {
            default: 
        }
    }
}

