/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;
import kd.hr.hrti.bussiness.domain.portrait.enums.APositionTypeEnum;
import kd.hr.hrti.bussiness.domain.portrait.enums.InCompanyTypeEnum;

public class InCompanyExpPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(InCompanyExpPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);
    private final String DEFAULT_TITLE = ResManager.loadKDString((String)"\u5728\u53f8\u7ecf\u5386", (String)"InCompanyExpPlugin_5", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]);
    private final String str1 = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"InCompanyExpPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]);
    private final String str2 = ResManager.loadKDString((String)"\u81f3", (String)"InCompanyExpPlugin_1", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean empty = true;
        if (!CollectionUtils.isEmpty((Map)params) && !Objects.isNull(params.get("employee"))) {
            empty = this.buildKdCompanyExp(params);
            this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
            this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
            return;
        }
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("employee"))) {
            empty = this.buildKdCompanyExp(customParams);
        }
        this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
    }

    private boolean buildKdCompanyExp(Map<String, Object> customParams) {
        long empId = Long.parseLong(String.valueOf(customParams.get("employee")));
        if (empId == 0L) {
            return true;
        }
        CustomControl kdCompanyExp = (CustomControl)this.getView().getControl("kdCompanyExp");
        HashMap sendData = Maps.newHashMap();
        sendData.put("code", 200);
        sendData.put("success", Boolean.TRUE);
        sendData.put("eventName", "loadData");
        sendData.put("eventStatus", "init");
        sendData.put("times", System.currentTimeMillis());
        boolean empty = this.buildData(sendData, empId);
        if (!empty) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            kdCompanyExp.setData((Object)sendData);
        }
        return empty;
    }

    private boolean buildData(Map<String, Object> sendData, long empId) {
        HashMap allCardConfigMap;
        HashMap data = Maps.newHashMap();
        Map empInfo = EXTERNAL_SERVICE.getEmpentrel(empId);
        String cache_allCardConfig = this.getView().getParentView().getPageCache().get("cache_allCardConfig");
        Map map = allCardConfigMap = HRStringUtils.isEmpty((String)cache_allCardConfig) ? Maps.newHashMap() : (Map)SerializationUtils.fromJsonString((String)cache_allCardConfig, Map.class);
        if (!CollectionUtils.isEmpty((Map)allCardConfigMap)) {
            allCardConfigMap.forEach((cardId, cardInfo) -> {
                Map cardInfoMap = (Map)SerializationUtils.fromJsonString((String)cardInfo, Map.class);
                String cardFormNum = (String)cardInfoMap.get("cardformnum");
                if (HRStringUtils.equals((String)cardFormNum, (String)"hrti_incompanyexp")) {
                    data.put("title", this.parseCardTitle((String)cardInfoMap.get("cardtitle")));
                }
            });
        }
        if (CollectionUtils.isEmpty((Map)empInfo)) {
            return true;
        }
        Date startDate = (Date)empInfo.get("startdate");
        Period period = Period.between(this.dateToLocalDate(startDate), LocalDate.now());
        data.put("startDate", HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
        data.put("year", period.getYears());
        data.put("month", period.getMonths());
        data.put("day", period.getDays() + 1);
        ArrayList orbitList = Lists.newArrayList();
        this.buildEmpExpRecord(empId, data, orbitList);
        this.buildEmpJobInfoRecord(empId, data, orbitList);
        this.buildPersonCommWorkRecord(empId, data, orbitList);
        List sortOrbitList = orbitList.stream().sorted((o1, o2) -> {
            if (o1.get("startDate") == null && o2.get("startDate") == null) {
                return 0;
            }
            if (o1.get("startDate") == null) {
                return 1;
            }
            if (o2.get("startDate") == null) {
                return -1;
            }
            if (o2.get("startDate").equals(o1.get("startDate"))) {
                return Objects.isNull(o1.get("isPrimary")) ? (Objects.isNull(o2.get("isPrimary")) ? 0 : -1) : -1;
            }
            return ((Date)o1.get("startDate")).compareTo((Date)o2.get("startDate"));
        }).collect(Collectors.toList());
        data.put("orbit", sortOrbitList);
        data.put("label", "");
        sendData.put("data", data);
        return false;
    }

    private void buildEmpExpRecord(long empId, Map<String, Object> data, List<Map<String, Object>> orbitList) {
        HRBaseServiceHelper personExpService = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter empIdQFilter = new QFilter("employee", "=", (Object)empId);
        QFilter isCurrVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] queryPerExpData = personExpService.query("startdate,enddate,postype_id,apositiontype,businessstatus,stdposition.name,job.name,position.name", new QFilter[]{empIdQFilter, isCurrVersion});
        List personExpInfo = Arrays.stream(queryPerExpData).map(value -> HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)value)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(personExpInfo)) {
            ArrayList posTypeIds = Lists.newArrayList((Object[])new Long[]{1010L, 1020L, 1030L, 1040L});
            List<Map> filterPersonExpInfo = personExpInfo.stream().filter(value -> posTypeIds.contains((Long)value.get("postype_id"))).collect(Collectors.toList());
            data.put("change", filterPersonExpInfo.size() - 1);
            String str3 = ResManager.loadKDString((String)"[\u4e3b]", (String)"InCompanyExpPlugin_2", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]);
            String str4 = ResManager.loadKDString((String)"[\u517c]", (String)"InCompanyExpPlugin_3", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]);
            filterPersonExpInfo.forEach(personExp -> {
                HashMap personExpMap = Maps.newHashMap();
                InCompanyTypeEnum inCompanyTypeEnum = InCompanyTypeEnum.getEnumByPosTypeId((Long)((Long)personExp.get("postype_id")));
                personExpMap.put("type", inCompanyTypeEnum.getType());
                personExpMap.put("startDate", personExp.get("startdate"));
                String field = APositionTypeEnum.getEnumByType((String)((String)personExp.get("apositiontype"))).getFiled();
                DynamicObject aPosition = (DynamicObject)personExp.get(field);
                String strName = HRDyObjectPropUtil.getName((DynamicObject)aPosition);
                if (inCompanyTypeEnum == InCompanyTypeEnum.PRIMARY) {
                    personExpMap.put("isPrimary", 1);
                    personExpMap.put("desc", str3 + strName);
                } else if (inCompanyTypeEnum == InCompanyTypeEnum.PART_TIME) {
                    personExpMap.put("desc", str4 + strName);
                } else {
                    personExpMap.put("desc", strName);
                }
                String strStartDate = HRDateTimeUtils.format((Date)((Date)personExp.get("startdate")), (String)"yyyy-MM-dd");
                if ("1".equals(personExp.get("businessstatus"))) {
                    personExpMap.put("timeRange", strStartDate + this.str1);
                } else {
                    String strEndDate = HRDateTimeUtils.format((Date)((Date)personExp.get("enddate")), (String)"yyyy-MM-dd");
                    personExpMap.put("timeRange", strStartDate + this.str2 + strEndDate);
                }
                orbitList.add(personExpMap);
            });
        } else {
            data.put("change", 0);
        }
    }

    private void buildEmpJobInfoRecord(long empId, Map<String, Object> data, List<Map<String, Object>> orbitList) {
        QFilter isCurrVersion;
        HRBaseServiceHelper empJobService = new HRBaseServiceHelper("hrpi_empjobrel");
        QFilter empIdQFilter = new QFilter("employee", "=", (Object)empId);
        DynamicObject[] queryEmpJobDate = empJobService.query("startdate,enddate,businessstatus,joblevel.name", new QFilter[]{empIdQFilter, isCurrVersion = new QFilter("iscurrentversion", "=", (Object)"1")});
        List employeeAttachInfo = Arrays.stream(queryEmpJobDate).map(value -> HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)value)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(employeeAttachInfo) && employeeAttachInfo.size() > 1) {
            List<Map> sortEmpAttachInfo = employeeAttachInfo.stream().sorted(Comparator.comparing(map -> (Date)map.get("startdate"))).collect(Collectors.toList()).subList(1, employeeAttachInfo.size());
            data.put("promote", sortEmpAttachInfo.size());
            sortEmpAttachInfo.forEach(empJobInfo -> {
                HashMap empJobMap = Maps.newHashMap();
                empJobMap.put("type", InCompanyTypeEnum.RANK_PROMOTION.getType());
                empJobMap.put("startDate", empJobInfo.get("startdate"));
                empJobMap.put("desc", HRDyObjectPropUtil.getName((DynamicObject)((DynamicObject)empJobInfo.get("joblevel"))));
                String strStartDate = HRDateTimeUtils.format((Date)((Date)empJobInfo.get("startdate")), (String)"yyyy-MM-dd");
                if ("1".equals(empJobInfo.get("businessstatus"))) {
                    empJobMap.put("timeRange", strStartDate + this.str1);
                } else {
                    String strEndDate = HRDateTimeUtils.format((Date)((Date)empJobInfo.get("enddate")), (String)"yyyy-MM-dd");
                    empJobMap.put("timeRange", strStartDate + this.str2 + strEndDate);
                }
                orbitList.add(empJobMap);
            });
        } else {
            data.put("promote", 0);
        }
    }

    private void buildPersonCommWorkRecord(long empId, Map<String, Object> data, List<Map<String, Object>> orbitList) {
        List personCommWorkRecords = EXTERNAL_SERVICE.getPersonCommWorkRecord(empId);
        if (!CollectionUtils.isEmpty((Collection)personCommWorkRecords)) {
            Date currDate = new Date();
            AtomicInteger num = new AtomicInteger(0);
            personCommWorkRecords.forEach(personCommWork -> {
                Object commName = personCommWork.get("commName");
                List roleEntry = (List)personCommWork.get("roleEntry");
                roleEntry.forEach(roleEntryRow -> {
                    Date effectDate = (Date)roleEntryRow.get("effectDate");
                    if (currDate.after(effectDate)) {
                        num.getAndIncrement();
                        Date expireDate = (Date)roleEntryRow.get("expireDate");
                        String roleName = (String)roleEntryRow.get("roleName");
                        HashMap roleMap = Maps.newHashMap();
                        roleMap.put("type", InCompanyTypeEnum.SPECIAL_ORG.getType());
                        roleMap.put("startDate", effectDate);
                        roleMap.put("desc", commName + roleName);
                        String strStartDate = HRDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd");
                        if (Objects.isNull(expireDate) || currDate.before(expireDate)) {
                            roleMap.put("timeRange", strStartDate + this.str1);
                        } else {
                            String strEndDate = HRDateTimeUtils.format((Date)expireDate, (String)"yyyy-MM-dd");
                            roleMap.put("timeRange", strStartDate + this.str2 + strEndDate);
                        }
                        orbitList.add(roleMap);
                    }
                });
            });
            data.put("record", num.get());
        } else {
            data.put("record", 0);
        }
    }

    private String parseCardTitle(String cardTitle) {
        try {
            LOG.info("cardTitle:{}", (Object)cardTitle);
            String replaceStr = cardTitle.replaceAll(" ", "");
            String[] titles = replaceStr.substring(1, replaceStr.length() - 1).split(",");
            Map<String, String> collect = Arrays.stream(titles).collect(Collectors.toMap(value -> value.trim().substring(0, value.indexOf("=")), value -> value.trim().substring(value.indexOf("=") + 1), (v1, v2) -> v1));
            String langTag = RequestContext.get().getLang().getLangTag();
            String title = collect.get(langTag);
            if (HRStringUtils.isEmpty((String)title)) {
                title = collect.get(langTag.replace("-", "_"));
            }
            return HRStringUtils.isEmpty((String)title) ? this.DEFAULT_TITLE : title;
        }
        catch (Exception exception) {
            return this.DEFAULT_TITLE;
        }
    }

    private LocalDate dateToLocalDate(Date startDate) {
        return startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

