/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRImageAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;

public class InterviewEvaluationPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InterviewEvaluationPlugin.class);
    private static final ThreadLocal<List<Map<String, String>>> list = new ThreadLocal();
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);

    public void initialize() {
        super.initialize();
        list.set(this.getEvaluationDataListBack());
        logger.info("evaluation data list " + list);
    }

    public void destory() {
        super.destory();
        list.remove();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
        Object employeeObj = customParams.get("employee");
        if (!Objects.isNull(employeeObj)) {
            long employeeId = Long.parseLong(String.valueOf(employeeObj));
            Map<String, String> detailMap = this.getEvaluationData(employeeId);
            String interviewPos = detailMap.get("interviewPos");
            String interviewOrg = detailMap.get("interviewOrg");
            String source = detailMap.get("source");
            this.showInfo(interviewPos, interviewOrg, source);
            this.showEvaluationList("");
        }
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().contains("detailflex")) {
            Container container = new Container();
            container.setKey(e.getKey());
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            e.setControl((Control)container);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().contains("detailflex")) {
            Set itemSet = list.get().stream().map(map -> "detailflex" + (String)map.get("id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(itemSet)) {
                return;
            }
            if (itemSet.contains(source.getKey())) {
                this.showEvaluationList(source.getKey());
            }
        }
    }

    private void showInfo(String interviewPos, String interviewOrg, String source) {
        Label posLabel = (Label)this.getControl("appliedpos");
        posLabel.setText(interviewPos);
        Label orgLabel = (Label)this.getControl("org");
        orgLabel.setText(interviewOrg);
        Label sourceLabel = (Label)this.getControl("source");
        sourceLabel.setText(source);
    }

    private void showEvaluationList(String itemKey) {
        FlexPanelAp evaluationFlexPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("evaluationflex").setDirection("row").setGrow(0).setShrink(1).setAlignItems("flex-start").setJustifyContent("flex-start").setMarginLeft("13px")).build();
        FlexPanelAp leftFlexPanelAp = new HRFlexPanelAp.Builder("leftflex").setDirection("column").setGrow(0).setShrink(0).setOverflow("visible").setAlignItems("flex-start").setJustifyContent("stretch").build();
        FlexPanelAp rightFlexPanelAp = new FlexPanelAp();
        if (CollectionUtils.isEmpty((Collection)list.get())) {
            return;
        }
        if (HRStringUtils.isEmpty((String)itemKey)) {
            for (int i = 0; i < list.get().size(); ++i) {
                boolean selected = i < 1;
                leftFlexPanelAp.getItems().add(this.buildItemFlexPanelAp(list.get().get(i), selected));
                if (!selected) continue;
                rightFlexPanelAp = this.buildRightFlexPanelAp(list.get().get(i).get("label"), list.get().get(i).get("desc"));
            }
        } else {
            for (Map<String, String> map : list.get()) {
                boolean selected = itemKey.equals("detailflex" + map.get("id"));
                leftFlexPanelAp.getItems().add(this.buildItemFlexPanelAp(map, selected));
                if (!selected) continue;
                rightFlexPanelAp = this.buildRightFlexPanelAp(map.get("label"), map.get("desc"));
            }
        }
        evaluationFlexPanelAp.getItems().add(leftFlexPanelAp);
        evaluationFlexPanelAp.getItems().add(rightFlexPanelAp);
        this.getView().updateControlMetadata("evaluationflex", evaluationFlexPanelAp.createControl());
    }

    private FlexPanelAp buildItemFlexPanelAp(Map<String, String> map, boolean selected) {
        FlexPanelAp itemFlexPanelAp = new HRFlexPanelAp.Builder("itemflex" + map.get("id")).setDirection("row").setGrow(0).setShrink(0).setJustifyContent("center").setAlignItems("center").setOverflow("visible").build();
        itemFlexPanelAp.getItems().add(this.buildInfoFlexPanelAp(map, selected));
        itemFlexPanelAp.getItems().add(this.buildVectorFlexPanelAp(selected));
        return itemFlexPanelAp;
    }

    private FlexPanelAp buildVectorFlexPanelAp(boolean selected) {
        FlexPanelAp labelFlexPanelAp = new HRFlexPanelAp.Builder("labelflex").setDirection("row").setGrow(0).setShrink(0).setJustifyContent("center").setAlignItems("center").setBackColor("#ffffff").setWidth("20px").setHeight("20px").setOverflow("visible").build();
        VectorAp vectorAp = ((HRVectorAp.Builder)new HRVectorAp.Builder("leftvector").setId("leftvector").setfontClass("kdfont kdfont-fangxiangzuo").setForeColor("#d9d9d9").setBackColor("#ffffff").setMarginRight("-10px")).setZIndex(1).setClickable(false).setNeedHoverClass(false).setHeight(new LocaleString("16px")).setWidth(new LocaleString("16px")).build();
        vectorAp.setHidden(!selected);
        labelFlexPanelAp.getItems().add(vectorAp);
        return labelFlexPanelAp;
    }

    private FlexPanelAp buildInfoFlexPanelAp(Map<String, String> map, boolean selected) {
        String backColor = selected ? "#e1efff" : "#f5f5f5";
        FlexPanelAp infoFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("infoflex" + map.get("id")).setWrap(true).setDirection("row").setGrow(0).setShrink(0).setOverflow("visible").setMarginLeft("10px")).setMarginRight("20px")).setMarginTop("5px")).setMarginBottom("5px")).setRadius("5px").setBackColor(backColor).build();
        FlexPanelAp headImgFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("headimgflex").setWrap(true).setDirection("row").setGrow(0).setShrink(0).setHeight("50px").setWidth("50px").setAlignItems("center").setJustifyContent("center").setMarginLeft("3px")).setMarginRight("3px")).build();
        ImageAp headImageAp = new HRImageAp.Builder("picturefield").setId("genderAp").setImageKey(map.get("headimg")).setRadius("50px").setHeight("40px").setWidth("40px").build();
        headImgFlexPanelAp.getItems().add(headImageAp);
        FlexPanelAp detailFlexPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("detailflex" + map.get("id")).setDirection("column").setGrow(0).setShrink(0).setZIndex(1).setMarginLeft("5px")).setClickable(true).build();
        FlexPanelAp jobFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("jobflex").setWrap(true).setDirection("row").setGrow(1).setShrink(1).setZIndex(0).setMarginTop("5px")).setMarginBottom("10px")).build();
        LabelAp nameLabel = ((HRLabelAp.Builder)new HRLabelAp.Builder("name").setId("name").setName(map.get("name")).setFontSize(12).setMarginRight("10px")).setGrow(0).setShrink(1).build();
        nameLabel.setFontWeight("bold");
        LabelAp lineLabel = ((HRLabelAp.Builder)new HRLabelAp.Builder("line").setId("line").setName("|").setFontSize(12).setMarginRight("10px")).setGrow(0).setShrink(1).setForeColor("#999999").build();
        LabelAp posLabel = ((HRLabelAp.Builder)new HRLabelAp.Builder("pos").setId("pos").setName(map.get("pos")).setFontSize(12).setMarginRight("10px")).setGrow(0).setShrink(1).build();
        posLabel.setFontWeight("bold");
        LabelAp roundLabel = ((HRLabelAp.Builder)new HRLabelAp.Builder("round").setId("round").setName(map.get("round")).setFontSize(12).setMarginRight("30px")).setGrow(0).setShrink(1).build();
        roundLabel.setFontWeight("bold");
        jobFlexPanelAp.getItems().add(nameLabel);
        jobFlexPanelAp.getItems().add(lineLabel);
        jobFlexPanelAp.getItems().add(posLabel);
        jobFlexPanelAp.getItems().add(lineLabel);
        jobFlexPanelAp.getItems().add(roundLabel);
        FlexPanelAp timeFlexPanelAp = new HRFlexPanelAp.Builder("timeflex").setWrap(true).setDirection("column").setGrow(0).setShrink(1).setZIndex(0).build();
        LabelAp timeLabel = new HRLabelAp.Builder("time").setId("time").setName(map.get("time")).setFontSize(12).setGrow(0).setShrink(1).setForeColor("#919191").build();
        timeFlexPanelAp.getItems().add(timeLabel);
        detailFlexPanelAp.getItems().add(jobFlexPanelAp);
        detailFlexPanelAp.getItems().add(timeFlexPanelAp);
        infoFlexPanelAp.getItems().add(headImgFlexPanelAp);
        infoFlexPanelAp.getItems().add(detailFlexPanelAp);
        return infoFlexPanelAp;
    }

    private FlexPanelAp buildRightFlexPanelAp(String labels, String desc) {
        FlexPanelAp rightFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("rightflex").setDirection("column").setGrow(0).setShrink(1).setBorderLeft("1px_solid_#d9d9d9")).setMarginTop("5px")).setMarginLeft("-2px")).setAlignItems("flex-start").setJustifyContent("stretch").setHeight("170px").build();
        rightFlexPanelAp.getItems().add(this.buildLabelFlexPanelAp(labels));
        rightFlexPanelAp.getItems().add(this.buildDescFlexPanelAp(desc));
        return rightFlexPanelAp;
    }

    private FlexPanelAp buildDescFlexPanelAp(String desc) {
        FlexPanelAp descFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("descflex").setDirection("column").setGrow(0).setShrink(0).setOverflow("visible").setMarginTop("5px")).setMarginLeft("30px")).setMarginBottom("10px")).setAlignItems("flex-start").setJustifyContent("stretch").setWidth("220px").build();
        LabelAp descLabel = new HRLabelAp.Builder("desclabel").setId("desclabel").setName(desc).setGrow(0).setShrink(0).setAutoTextWrap(true).setWidth(new LocaleString("150px")).setForeColor("#919191").build();
        descFlexPanelAp.getItems().add(descLabel);
        return descFlexPanelAp;
    }

    private FlexPanelAp buildLabelFlexPanelAp(String labels) {
        String[] labelArr;
        FlexPanelAp labelFlexPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("descflex").setWrap(true).setDirection("row").setGrow(0).setShrink(0).setMarginTop("10px")).setMarginLeft("25px")).setMarginBottom("10px")).setAlignItems("flex-start").setJustifyContent("stretch").build();
        if (HRStringUtils.isEmpty((String)labels)) {
            return labelFlexPanelAp;
        }
        for (String s : labelArr = labels.split(",")) {
            LabelAp label = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder("label").setId("label").setName(s).setFontSize(12).setForeColor("#666666").setRadius("10px").setMarginRight("10px")).setBorderLeft("1px_solid_#b2b2b2")).setBorderRight("1px_solid_#b2b2b2")).setBorderTop("1px_solid_#b2b2b2")).setBorderBottom("1px_solid_#b2b2b2")).setPaddingLeft("5px")).setPaddingRight("5px")).setPaddingTop("2px")).setPaddingBottom("2px")).build();
            labelFlexPanelAp.getItems().add(label);
        }
        return labelFlexPanelAp;
    }

    private Map<String, String> getEvaluationData(long employeeId) {
        Map employeeInfo = EXTERNAL_SERVICE.getEmployeeInfo(Long.valueOf(employeeId));
        long candidateId = HRObjectUtils.isEmpty(employeeInfo.get("candidate")) ? 0L : Long.parseLong(employeeInfo.get("candidate").toString());
        List<Long> candidateIdList = Collections.singletonList(candidateId);
        List candidateInterviewList = new ArrayList();
        try {
            candidateInterviewList = EXTERNAL_SERVICE.getCandidateInterviewList(candidateIdList);
        }
        catch (Exception e) {
            logger.error("tsc.tspr appFileService error ", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(candidateInterviewList)) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>();
    }

    private List<Map<String, String>> getEvaluationDataListBack() {
        ArrayList<Map<String, String>> listInit = new ArrayList<Map<String, String>>(3);
        for (int i = 0; i < 3; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", i + "");
            if (i == 1) {
                map.put("headimg", "/images/pc/other/hr_qdpzbg4_140_60.png");
            }
            if (i == 2) {
                map.put("headimg", "/images/pc/other/pt_cjkf_192_128.png");
            }
            if (i == 0) {
                map.put("headimg", "/images/pc/other/hr_qdpzbg2_140_60.png");
            }
            map.put("name", "ZHANG SAN " + i);
            map.put("pos", "HRBP" + i);
            map.put("round", "round" + i);
            map.put("time", "2022-04-1" + i + " 10:10");
            map.put("desc", "this is a desc" + i + ",Accept that this is your starting point.Instead of placing judgements on it,see the real,positive value that\u2019s already yours.");
            map.put("label", "label9,label" + i);
            listInit.add(map);
        }
        return listInit;
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

