/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;

public class LabelCloudPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(LabelCloudPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Vector vector = (Vector)this.getControl("showall");
        vector.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("employee"))) {
            CustomControl kdTagCloud = (CustomControl)this.getView().getControl("kdtagcloud");
            HashMap sendData = Maps.newHashMap();
            sendData.put("code", 200);
            sendData.put("success", true);
            sendData.put("eventName", "loadLabelCloud");
            sendData.put("eventStatus", "init");
            sendData.put("times", System.currentTimeMillis());
            ArrayList data = Lists.newArrayList();
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("sceneId", 1868803031756198912L);
            long employeeId = Long.parseLong(String.valueOf(customParams.get("employee")));
            DynamicObject mainObj = EXTERNAL_SERVICE.queryTalaLabelMainObjId(employeeId);
            if (mainObj == null) {
                return;
            }
            Long id = mainObj.getLong("id");
            paramMap.put("id", id);
            try {
                Map resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelBySceneIdAndBizObjId", (Object[])new Object[]{paramMap});
                LOG.info("getLabelBySceneIdAndBizObjId##{}", (Object)resultMap);
                if (CollectionUtils.isEmpty((Map)resultMap) || !"200".equals(resultMap.get("responseCode"))) {
                    this.buildDefaultData(data, Lists.newArrayList());
                } else {
                    List resultList = (List)resultMap.get("resultList");
                    List<Map<String, Object>> labelMapList = new ArrayList<Map<String, Object>>();
                    if (!CollectionUtils.isEmpty((Collection)resultList)) {
                        labelMapList = resultList.stream().flatMap(p -> ((ArrayList)p.get("labels")).stream()).collect(Collectors.toList());
                        Collections.sort(labelMapList, (p1, p2) -> {
                            if (p1.get("bizIndex") == null || p2.get("bizIndex") == null) {
                                return -1;
                            }
                            if ((Long)p1.get("bizIndex") == 0L) {
                                return 1;
                            }
                            if ((Long)p2.get("bizIndex") == 0L) {
                                return -1;
                            }
                            return Long.compare(p1.getOrDefault("bizIndex", Long.MAX_VALUE), p2.getOrDefault("bizIndex", Long.MAX_VALUE));
                        });
                        labelMapList = labelMapList.subList(0, Math.min(labelMapList.size(), 20));
                    }
                    this.buildDefaultData(data, labelMapList);
                    LOG.info("data:{}, labelMapList:{}", (Object)data, labelMapList);
                }
            }
            catch (Exception exception) {
                LOG.error("getLabelBySceneIdAndBizObjId##", (Throwable)exception);
                this.buildDefaultData(data, Lists.newArrayList());
            }
            sendData.put("data", data);
            kdTagCloud.setData((Object)sendData);
            this.getView().setVisible(Boolean.FALSE, new String[]{"emptyflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataflex", "showall"});
        }
    }

    private void buildDefaultData(List<Map<String, Object>> data, List<Map<String, Object>> labelList) {
        for (int i = 0; i < labelList.size(); ++i) {
            HashMap map = Maps.newHashMap();
            String type = (String)labelList.get(i).get("type");
            if ("10".equals(type)) {
                Object labelValueName = labelList.get(i).get("labelValueName");
                map.put("lableName", labelValueName == null ? "null" : labelValueName);
            } else if ("20".equals(type)) {
                Object labelBizValue = labelList.get(i).get("labelBizValue");
                map.put("lableName", labelBizValue == null ? "null" : labelBizValue);
            }
            map.put("weight", Integer.parseInt(String.valueOf(labelList.get(i).getOrDefault("bizIndex", 0L).toString())));
            data.add(map);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if ("showall".equals(controlKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("hrti_alllabel");
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            parameter.setOpenStyle(openStyle);
            FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
            Map customParams = parentShowParameter.getCustomParams();
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        }
    }
}

