/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class PerformanceAppraisalPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_RESULT = "btnresult";
    private static final String CONTROL_PERFORMANCE = "performancecontrol";
    private static final String RANGE_TYPE_YEAR = "40";
    private static final String YYYY = "yyyy";
    private static final String CHECK_START_DATE = "check_startdate";
    private static final String CHECK_END_DATE = "check_enddate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector viewBtn = (Vector)this.getControl(BTN_RESULT);
        viewBtn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        boolean empty = true;
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("employee"))) {
            empty = false;
            long empId = Long.parseLong(String.valueOf(customParams.get("employee")));
            Object[] performanceList = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"IPerformanceService", (String)"listPerformanceByEmployee", (Object[])new Object[]{empId, RANGE_TYPE_YEAR});
            Map<Object, Object> map = HRArrayUtils.isNotEmpty((Object[])performanceList) ? Arrays.stream(performanceList).collect(Collectors.toMap(obj -> HRDateTimeUtils.format((Date)obj.getDate(CHECK_START_DATE), (String)YYYY), Function.identity(), (v1, v2) -> v1.getDate(CHECK_END_DATE).before(v2.getDate(CHECK_END_DATE)) ? v2 : v1)) : new HashMap(16);
            List<String> threeYearsKeys = this.getThreeYearsKeys();
            ArrayList dataList = new ArrayList(16);
            for (String yearStr : threeYearsKeys) {
                DynamicObject performance = (DynamicObject)map.get(yearStr);
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("grade", Optional.ofNullable(performance).map(item -> item.getString("level")).orElse("-"));
                dataMap.put("department", "");
                dataMap.put("group", "");
                dataMap.put("year", yearStr);
                dataList.add(dataMap);
            }
            ArrayList tags = new ArrayList(16);
            HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>(16);
            dataMap.put("tags", tags);
            dataMap.put("years", dataList);
            dataMap.put("showGroup", Boolean.FALSE);
            dataMap.put("showDept", Boolean.FALSE);
            dataMap.put("groupExcellentRanking", Integer.valueOf(0));
            dataMap.put("deptExcellentRanking", Integer.valueOf(0));
            CustomControl control = (CustomControl)this.getControl(CONTROL_PERFORMANCE);
            control.setData(dataMap);
        }
        this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
    }

    private List<String> getThreeYearsKeys() {
        ArrayList threeYearsKeys = Lists.newArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        threeYearsKeys.add(HRDateTimeUtils.format((Date)calendar.getTime(), (String)YYYY));
        calendar.add(1, -1);
        threeYearsKeys.add(HRDateTimeUtils.format((Date)calendar.getTime(), (String)YYYY));
        calendar.add(1, -1);
        threeYearsKeys.add(HRDateTimeUtils.format((Date)calendar.getTime(), (String)YYYY));
        return threeYearsKeys;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickKey = source.getKey();
        if (BTN_RESULT.equals(clickKey)) {
            this.showAllResult();
        }
    }

    private void showAllResult() {
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) || Objects.isNull(customParams.get("employee"))) {
            return;
        }
        long empId = Long.parseLong(String.valueOf(customParams.get("employee")));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrti_allappraisaresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        map.put("employee", empId);
        formShowParameter.setCustomParams(map);
        this.getView().showForm(formShowParameter);
    }
}

