/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;
import kd.hr.hrti.bussiness.domain.portrait.enums.APositionTypeEnum;

public class PersonInfoPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PersonInfoPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
        Object perId = customParams.get("person");
        Object empId = customParams.get("employee");
        if (Objects.isNull(perId) || Objects.isNull(empId)) {
            return;
        }
        long personId = Long.parseLong(perId.toString());
        long employeeId = Long.parseLong(empId.toString());
        this.getView().setVisible(Boolean.FALSE, new String[]{"mobileeyeclose", "emaileyeclose", "mobileeyeopen", "emaileyeopen", "companyemail", "mobile"});
        this.showBaseInfo(personId);
        this.showJobInfo(employeeId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button mobileEyeOpen = (Button)this.getView().getControl("mobileeyeopen");
        mobileEyeOpen.addClickListener((ClickListener)this);
        Button mobileEyeClose = (Button)this.getView().getControl("mobileeyeclose");
        mobileEyeClose.addClickListener((ClickListener)this);
        Button emailEyeOpen = (Button)this.getView().getControl("emaileyeopen");
        emailEyeOpen.addClickListener((ClickListener)this);
        Button emailEyeClose = (Button)this.getView().getControl("emaileyeclose");
        emailEyeClose.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("mobileeyeopen")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mobileeyeopen", "mobilehidden"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"mobileeyeclose", "mobile"});
        }
        if (source.getKey().equals("mobileeyeclose")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mobileeyeclose", "mobile"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"mobileeyeopen", "mobilehidden"});
        }
        if (source.getKey().equals("emaileyeopen")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emaileyeopen", "companyemailhidden"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"emaileyeclose", "companyemail"});
        }
        if (source.getKey().equals("emaileyeclose")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emaileyeclose", "companyemail"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"emaileyeopen", "companyemailhidden"});
        }
    }

    private void showBaseInfo(long personId) {
        this.showNumberNameGenderHeadPic(personId);
        Map personContact = EXTERNAL_SERVICE.getPersonContact(personId);
        if (!CollectionUtils.isEmpty((Map)personContact)) {
            String email;
            String mobile;
            Label mobileLabel = (Label)this.getControl("mobile");
            Label mobileHiddenLabel = (Label)this.getControl("mobilehidden");
            String string = mobile = personContact.get("phone") == null ? "" : personContact.get("phone").toString();
            if (!HRStringUtils.isEmpty((String)mobile) && mobile.length() > 3) {
                mobileLabel.setText(mobile);
                mobileHiddenLabel.setText(this.format(mobile));
                this.getView().setVisible(Boolean.TRUE, new String[]{"mobileeyeopen", "mobilehidden"});
            }
            Label emailLabel = (Label)this.getControl("companyemail");
            Label emailHiddenLabel = (Label)this.getControl("companyemailhidden");
            String string2 = email = personContact.get("busemail") == null ? "" : personContact.get("busemail").toString();
            if (!HRStringUtils.isEmpty((String)email) && email.length() > 3) {
                emailLabel.setText(email);
                emailHiddenLabel.setText(this.format(email));
                this.getView().setVisible(Boolean.TRUE, new String[]{"emaileyeopen", "companyemailhidden"});
            }
        }
    }

    private String format(String info) {
        if (HRStringUtils.isEmpty((String)info)) {
            return "***";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < info.length(); ++i) {
            str.append("*");
        }
        return str.toString();
    }

    private void showNumberNameGenderHeadPic(long personId) {
        Map perInfoMap = EXTERNAL_SERVICE.getPersonInfo(Long.valueOf(personId));
        if (HRObjectUtils.isEmpty((Object)perInfoMap)) {
            return;
        }
        Long gender_id = (Long)perInfoMap.get("gender_id");
        if (Objects.isNull(gender_id) || gender_id == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gendericon", "gender"});
        } else {
            this.getModel().setValue("gender", (Object)gender_id);
        }
        Long adminOrg_id = (Long)perInfoMap.get("adminorg_id");
        if (Objects.isNull(adminOrg_id) || adminOrg_id == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgicon", "adminorg"});
        } else {
            this.getModel().setValue("adminorg", (Object)adminOrg_id);
        }
        this.getView().getModel().setValue("headimg", (Object)(perInfoMap.get("headsculpture") == null ? "" : perInfoMap.get("headsculpture")));
        Label numberLabel = (Label)this.getControl("number");
        numberLabel.setText(perInfoMap.get("number") == null ? "" : perInfoMap.get("number").toString());
        Label nameLabel = (Label)this.getControl("name");
        nameLabel.setText(perInfoMap.get("name") == null ? "" : perInfoMap.get("name").toString());
        String ageStr = String.valueOf(perInfoMap.get("age"));
        if (Objects.isNull(perInfoMap.get("age")) || HRStringUtils.isEmpty((String)ageStr) || "0".equals(ageStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"birthdayicon", "age"});
        } else {
            Label age = (Label)this.getControl("age");
            age.setText(ageStr);
        }
        APositionTypeEnum aPositionType = APositionTypeEnum.getEnumByType((String)((String)perInfoMap.get("apositiontype")));
        String strPosition = (String)perInfoMap.get(aPositionType.getFiled());
        Vector posVectorIcon = (Vector)this.getControl("posvectoricon");
        if (HRStringUtils.isEmpty((String)strPosition)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"posvectoricon", "pos"});
        } else {
            Tips tips = new Tips();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(aPositionType.getDesc());
            tips.setContent(localeString);
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setShowIcon(false);
            posVectorIcon.addTips(tips);
            Label pos = (Label)this.getControl("pos");
            pos.setText(strPosition);
        }
    }

    private void showJobInfo(long employeeId) {
        List empInfoList = EXTERNAL_SERVICE.listEmployeeAttachs(employeeId, "hrpi_empjobrel");
        if (!CollectionUtils.isEmpty((Collection)empInfoList)) {
            String jobYear;
            Map empInfo = (Map)empInfoList.get(0);
            Label jobLabel = (Label)this.getControl("job");
            String job = Objects.isNull(empInfo.get("job")) ? "" : (String)empInfo.get("job");
            jobLabel.setText(job);
            Label jobLevelLabel = (Label)this.getControl("joblevel");
            String jobSeq = Objects.isNull(empInfo.get("jobseq")) ? "" : (String)empInfo.get("jobseq");
            String jobLevel = Objects.isNull(empInfo.get("joblevel")) ? "" : (String)empInfo.get("joblevel");
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            String string = jobYear = Objects.isNull(empInfo.get("startdate")) ? "" : decimalFormat.format((double)HRDateTimeUtils.dateDiff((String)"d", (Date)((Date)empInfo.get("startdate")), (Date)new Date()) / 365.0);
            if (jobYear.endsWith(".0")) {
                BigDecimal bigDecimal = new BigDecimal(jobYear);
                jobYear = bigDecimal.setScale(0, 5).toString();
            }
            String formatJobYear = ResManager.loadKDString((String)"\uff08\u804c\u7ea7\u5e74\u9650\uff1a{0}\u5e74\uff09", (String)"PersonInfoPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[]{jobYear});
            jobLevelLabel.setText(jobSeq + jobLevel + formatJobYear);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

