/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;
import kd.hr.hrti.common.util.CommUtils;
import kd.hr.hrti.formplugin.formservice.FormCommonService;
import kd.hr.hrti.formplugin.formservice.FormServiceFactory;

public class PersonalSkillsPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(PersonalSkillsPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label auditPointsTips = (Label)this.getControl("omit");
        auditPointsTips.addTipsListener((TipsListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("person"))) {
            long perId = Long.parseLong(String.valueOf(customParams.get("person")));
            List perHobbies = EXTERNAL_SERVICE.listPersonAttachs(perId, "hrpi_perhobby");
            List rsmProSkl = EXTERNAL_SERVICE.listPersonAttachs(perId, "hrpi_rsmproskl");
            if (!CollectionUtils.isEmpty((Collection)perHobbies)) {
                List interests = perHobbies.stream().filter(value -> HRStringUtils.isNotEmpty((String)((String)value.get("interest")))).map(value -> String.valueOf(value.get("interest"))).collect(Collectors.toList());
                List hobbies = perHobbies.stream().filter(value -> HRStringUtils.isNotEmpty((String)((String)value.get("hobby")))).map(value -> String.valueOf(value.get("hobby"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(interests)) {
                    String longInterest = String.join((CharSequence)"\u3001", interests);
                    this.getModel().setValue("interest", (Object)longInterest);
                }
                if (!CollectionUtils.isEmpty(hobbies)) {
                    String longHobbies = String.join((CharSequence)"\u3001", hobbies);
                    this.getModel().setValue("hobby", (Object)longHobbies);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rsmProSkl)) {
                Map<String, Object> skillMap = rsmProSkl.stream().filter(value -> HRStringUtils.isNotEmpty((String)String.valueOf(value.get("name")))).sorted(Comparator.comparing(item -> (Date)item.get("createtime"), CommUtils.dateComparator())).collect(Collectors.toMap(value -> String.valueOf(value.get("name")), value -> value.get("familiarityid"), (v1, v2) -> v1));
                boolean skill2IsVisible = false;
                boolean omitIsVisible = false;
                ArrayList skills = Lists.newArrayList(skillMap.keySet());
                ArrayList labels = Lists.newArrayList();
                IPageCache pageCache = this.getPageCache();
                for (int i = 0; i < skills.size(); ++i) {
                    String skillName = (String)skills.get(i);
                    if (i == 0) {
                        this.getModel().setValue("skill1", (Object)(skillName + "-" + skillMap.get(skillName)));
                        continue;
                    }
                    if (i == 1) {
                        skill2IsVisible = true;
                        this.getModel().setValue("skill2", (Object)(skillName + "-" + skillMap.get(skillName)));
                        continue;
                    }
                    omitIsVisible = true;
                    labels.add(skillName + "-" + skillMap.get(skillName));
                    if (i != skills.size() - 1) continue;
                    pageCache.put("omit", String.join((CharSequence)"\u3001", labels));
                }
                this.getView().setVisible(Boolean.valueOf(skill2IsVisible), new String[]{"skill2"});
                this.getView().setVisible(Boolean.valueOf(omitIsVisible), new String[]{"omit"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"skill2", "omit"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"omit"});
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        FORM_COMMON_SERVICE.showMoreLabel(evt, "omit", this.getPageCache().get("omit"));
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.hr.hrti.formplugin.web.portrait.card.PersonalSkillsPlugin.afterShowTips(AfterShowTipsEvent)");
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

