/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;
import kd.hr.hrti.common.util.CommUtils;
import kd.hr.hrti.formplugin.formservice.FormCommonService;
import kd.hr.hrti.formplugin.formservice.FormServiceFactory;
import kd.hr.hrti.formplugin.web.portrait.card.PersonalSkillsPlugin;

public class ProfessionCerRecordPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(PersonalSkillsPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label moreProTiTips = (Label)this.getControl("moreproti");
        Label moreProQuaTips = (Label)this.getControl("moreproqua");
        Label morePatentTips = (Label)this.getControl("morepatent");
        moreProTiTips.addTipsListener((TipsListener)this);
        moreProQuaTips.addTipsListener((TipsListener)this);
        morePatentTips.addTipsListener((TipsListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("person"))) {
            long perId = Long.parseLong(String.valueOf(customParams.get("person")));
            this.buildTitleInfo(perId);
            this.buildProQuaInfo(perId);
            this.buildTalentInfo(perId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"moreproti", "moreproqua", "morepatent"});
        }
    }

    private void buildTalentInfo(long perId) {
        List talent = EXTERNAL_SERVICE.listPersonAttachs(perId, "hrpi_rsmpatinv");
        boolean moreProQuaIsVisible = false;
        if (!CollectionUtils.isEmpty((Collection)talent)) {
            List sortProQuaInfo = talent.stream().sorted(Comparator.comparing(item -> (Date)item.get("ptstartdate"), CommUtils.dateComparator())).collect(Collectors.toList());
            IPageCache pageCache = this.getPageCache();
            ArrayList moreLabel = Lists.newArrayList();
            for (int i = 0; i < sortProQuaInfo.size(); ++i) {
                if (i == 0) {
                    this.getModel().setValue("patent1", ((Map)sortProQuaInfo.get(i)).get("patentname"));
                    continue;
                }
                if (i == 1) {
                    this.getModel().setValue("patent2", ((Map)sortProQuaInfo.get(i)).get("patentname"));
                    continue;
                }
                moreProQuaIsVisible = true;
                moreLabel.add((String)((Map)sortProQuaInfo.get(i)).get("patentname"));
                if (i != sortProQuaInfo.size() - 1) continue;
                pageCache.put("morepatent", String.join((CharSequence)"\u3001", moreLabel));
            }
        }
        this.getView().setVisible(Boolean.valueOf(moreProQuaIsVisible), new String[]{"morepatent"});
    }

    private void buildProQuaInfo(long perId) {
        List proQua = EXTERNAL_SERVICE.listPersonAttachs(perId, "hrpi_perocpqual");
        boolean moreProQuaIsVisible = false;
        if (!CollectionUtils.isEmpty((Collection)proQua)) {
            Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
            List filterProQua = proQua.stream().filter(proQuaDetail -> (Boolean)proQuaDetail.get("isnofixedterm") != false || Objects.isNull(proQuaDetail.get("expirationdate")) || !HRDateTimeUtils.dayBefore((Date)((Date)proQuaDetail.get("expirationdate")), (Date)currDate)).collect(Collectors.toList());
            List sortProQuaInfo = filterProQua.stream().sorted(Comparator.comparing(item -> (Date)item.get("gettime"), CommUtils.dateComparator())).collect(Collectors.toList());
            IPageCache pageCache = this.getPageCache();
            ArrayList moreLabel = Lists.newArrayList();
            for (int i = 0; i < sortProQuaInfo.size(); ++i) {
                if (i == 0) {
                    this.getModel().setValue("proqua1", ((Map)sortProQuaInfo.get(i)).get("qualification"));
                    continue;
                }
                if (i == 1) {
                    this.getModel().setValue("proqua2", ((Map)sortProQuaInfo.get(i)).get("qualification"));
                    continue;
                }
                moreProQuaIsVisible = true;
                moreLabel.add((String)((Map)sortProQuaInfo.get(i)).get("qualification"));
                if (i != sortProQuaInfo.size() - 1) continue;
                pageCache.put("moreproqua", String.join((CharSequence)"\u3001", moreLabel));
            }
        }
        this.getView().setVisible(Boolean.valueOf(moreProQuaIsVisible), new String[]{"moreproqua"});
    }

    private void buildTitleInfo(long perId) {
        List proTi = EXTERNAL_SERVICE.listPersonAttachs(perId, "hrpi_perprotitle");
        boolean moreProTiIsVisible = false;
        if (!CollectionUtils.isEmpty((Collection)proTi)) {
            List sortProTiInfo = proTi.stream().sorted(Comparator.comparing(item -> (Date)item.get("awardtime"), CommUtils.dateComparator())).collect(Collectors.toList());
            IPageCache pageCache = this.getPageCache();
            ArrayList moreLabel = Lists.newArrayList();
            for (int i = 0; i < sortProTiInfo.size(); ++i) {
                if (i == 0) {
                    this.getModel().setValue("proti1", ((Map)sortProTiInfo.get(i)).get("professional"));
                    continue;
                }
                if (i == 1) {
                    this.getModel().setValue("proti2", ((Map)sortProTiInfo.get(i)).get("professional"));
                    continue;
                }
                moreProTiIsVisible = true;
                moreLabel.add((String)((Map)sortProTiInfo.get(i)).get("professional"));
                if (i != sortProTiInfo.size() - 1) continue;
                pageCache.put("moreproti", String.join((CharSequence)"\u3001", moreLabel));
            }
        }
        this.getView().setVisible(Boolean.valueOf(moreProTiIsVisible), new String[]{"moreproti"});
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("moreproti".equals(key) || "moreproqua".equals(key) || "morepatent".equals(key)) {
            FORM_COMMON_SERVICE.showMoreLabel(evt, key, this.getPageCache().get(key));
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.hr.hrti.formplugin.web.portrait.card.PersonalSkillsPlugin.afterShowTips(AfterShowTipsEvent)");
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

