/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HrtiExternalService;
import kd.hr.hrti.common.util.CommUtils;

public class QualificationPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(QualificationPlugin.class);
    private static final HrtiExternalService EXTERNAL_SERVICE = (HrtiExternalService)ServiceFactory.getService(HrtiExternalService.class);
    private static final String PASS_VALUE = "10";
    private static final String RESULT_DATA = "resultdata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean empty = true;
        if (!CollectionUtils.isEmpty((Map)params) && !Objects.isNull(params.get("employee"))) {
            Object isShowResultData = params.get("isShowResultData");
            if (Objects.isNull(isShowResultData) || isShowResultData.toString().equals("false")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{RESULT_DATA});
            }
            empty = this.buildQualificationExp(params);
            this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
            this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
            return;
        }
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)customParams) && !Objects.isNull(customParams.get("employee"))) {
            empty = this.buildQualificationExp(customParams);
        }
        this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
    }

    private boolean buildQualificationExp(Map<String, Object> customParams) {
        boolean empty = true;
        long employeeId = Long.parseLong(String.valueOf(customParams.get("employee")));
        if (employeeId == 0L) {
            return true;
        }
        Object[] qualificationDy = EXTERNAL_SERVICE.queryByEmpIdOrderByMs(employeeId);
        if (!HRArrayUtils.isEmpty((Object[])qualificationDy)) {
            empty = false;
            int total = qualificationDy.length;
            AtomicInteger passTime = new AtomicInteger();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", total);
            List sortData = Arrays.stream(qualificationDy).sorted(Comparator.comparing(item -> this.checkIsPass((DynamicObject)item) ? item.getDate("enabledate") : item.getDate("submittime"), CommUtils.dateComparator())).collect(Collectors.toList());
            for (int i = 0; i < sortData.size(); ++i) {
                String stdName;
                DynamicObject item2 = (DynamicObject)sortData.get(i);
                boolean isAppeal = "1".equals(item2.getString("isappeal"));
                boolean isPass = this.checkIsPass(item2);
                String result = isAppeal ? item2.getString("appealresult") : item2.getString("cerresult");
                this.getModel().setValue("passed", (Object)result, rowIndex[i]);
                if (isPass) {
                    passTime.getAndIncrement();
                }
                stdName = HRStringUtils.isEmpty((String)(stdName = item2.getString("cerstandtxt") + " " + item2.getString("cerleveltxt"))) ? "-" : stdName;
                this.getModel().setValue("iqn", (Object)stdName, rowIndex[i]);
                if (isPass) {
                    Date disabledDate = item2.getDate("disenabledate");
                    Date enableDate = item2.getDate("enabledate");
                    String strDate = Objects.isNull(disabledDate) ? MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u81f3\u4eca", (String)"QualificationPlugin_1", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]), Objects.isNull(enableDate) ? "-" : HRDateTimeUtils.format((Date)enableDate, (String)"yyyy-MM-dd"), System.lineSeparator()) : (HRDateTimeUtils.getYear((Date)disabledDate) >= 2199 ? (Objects.isNull(enableDate) ? "-" : HRDateTimeUtils.format((Date)enableDate, (String)"yyyy-MM-dd")) : MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u81f3{2}{3}", (String)"QualificationPlugin_0", (String)"hrmp-hrti-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)enableDate, (String)"yyyy-MM-dd"), System.lineSeparator(), System.lineSeparator(), HRDateTimeUtils.format((Date)disabledDate, (String)"yyyy-MM-dd")));
                    this.getModel().setValue("msd", (Object)strDate, rowIndex[i]);
                } else {
                    this.getModel().setValue("msd", (Object)HRDateTimeUtils.format((Date)item2.getDate("submittime"), (String)"yyyy-MM-dd"), rowIndex[i]);
                }
                this.getModel().setValue("cerevaluate", (Object)item2.getString("ceropinion"), rowIndex[i]);
            }
            Label change = (Label)this.getControl("change");
            Label pass = (Label)this.getControl("pass");
            Label fail = (Label)this.getControl("fail");
            change.setText(String.valueOf(total));
            pass.setText(String.valueOf(passTime.get()));
            fail.setText(String.valueOf(total - passTime.get()));
            this.getModel().updateCache();
        }
        return empty;
    }

    private boolean checkIsPass(DynamicObject item) {
        boolean isAppeal = "1".equals(item.getString("isappeal"));
        boolean appealPass = PASS_VALUE.equals(item.getString("appealresult"));
        boolean cerPass = PASS_VALUE.equals(item.getString("cerresult"));
        return isAppeal ? appealPass : cerPass;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry source = (CardEntry)this.getControl("entryentity");
        source.selectCard(Integer.valueOf(0));
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid source = (EntryGrid)evt.getSource();
        if (HRStringUtils.equals((String)source.getEntryKey(), (String)"entryentity")) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                String isSelect = i == evt.getRow() ? "1" : "0";
                this.getModel().setValue("isselect", (Object)isSelect, i);
            }
            DynamicObject entryEntityDy = this.getModel().getEntryRowEntity("entryentity", evt.getRow());
            if (!Objects.isNull(entryEntityDy)) {
                this.getModel().setValue("cerresult", entryEntityDy.get("passed"));
                Label cerOpinionLabel = (Label)this.getControl("ceropinion");
                cerOpinionLabel.setText(entryEntityDy.getString("cerevaluate"));
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

