/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.card;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class TalentReviewPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_RESULT = "btnresult";
    private static final String CONTROL_TALENTMAP = "talentmapcontrol";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector viewBtn = (Vector)this.getControl(BTN_RESULT);
        viewBtn.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject evt) {
        long empId;
        Object[] reviewResults;
        super.afterBindData(evt);
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        boolean empty = true;
        if (!(CollectionUtils.isEmpty((Map)customParams) || Objects.isNull(customParams.get("employee")) || HRArrayUtils.isEmpty((Object[])(reviewResults = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"IReviewResultService", (String)"listReviewResultByEmployee", (Object[])new Object[]{empId = Long.parseLong(String.valueOf(customParams.get("employee")))}))))) {
            empty = false;
            Long latestReviewActivityId = Arrays.stream(reviewResults).max(Comparator.comparing(reviewResult -> reviewResult.getDate("actfinishdate"))).get().getLong("activityid");
            List latestReviewResults = Arrays.stream(reviewResults).filter(reviewResult -> latestReviewActivityId.equals(reviewResult.getLong("activityid"))).collect(Collectors.toList());
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>(16);
            for (DynamicObject latestReviewResult : latestReviewResults) {
                String gridmap = latestReviewResult.getString("gridmap_tag");
                JSONObject gridMapJson = JSONObject.parseObject((String)gridmap);
                HashMap<String, String> personInfoMap = new HashMap<String, String>(16);
                personInfoMap.put("customNumber", latestReviewResult.getString("positionnumber"));
                personInfoMap.put("calibrationName", latestReviewResult.getString("activityname"));
                gridMapJson.put("personInfo", personInfoMap);
                dataList.add(gridMapJson);
            }
            CustomControl control = (CustomControl)this.getControl(CONTROL_TALENTMAP);
            control.setData(dataList);
        }
        this.getView().setVisible(Boolean.valueOf(empty), new String[]{"emptyflex"});
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{"dataflex"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickKey = source.getKey();
        if (BTN_RESULT.equals(clickKey)) {
            this.showAllResult();
        }
    }

    private void showAllResult() {
        FormShowParameter parentShowParameter = this.getView().getParentView().getFormShowParameter();
        Map customParams = parentShowParameter.getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) || Objects.isNull(customParams.get("employee"))) {
            return;
        }
        long empId = Long.parseLong(String.valueOf(customParams.get("employee")));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrti_allinventoryresult");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        map.put("employee", empId);
        formShowParameter.setCustomParams(map);
        this.getView().showForm(formShowParameter);
    }
}

