/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.infodetail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.formplugin.formservice.FormCommonService;
import kd.hr.hrti.formplugin.formservice.FormServiceFactory;

public class EduExpInfoPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(EduExpInfoPlugin.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label_3 = (Label)this.getControl("label3");
        label_3.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List sortEduExpList = (List)fsp.getCustomParam("data");
        int currSize = (Integer)fsp.getCustomParam("currSize");
        if (sortEduExpList.size() == currSize + 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"line"});
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("sceneId", 0L);
        Map resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelBySceneIdAndBizObjId", (Object[])new Object[]{paramMap});
        if (CollectionUtils.isEmpty((Map)resultMap) || "200".equals(resultMap.get("responseCode"))) {
            // empty if block
        }
        Map eduExpInfo = (Map)sortEduExpList.get(currSize);
        IDataModel model = this.getModel();
        try {
            Object gradutionDate;
            Object admissionDate = eduExpInfo.get("admissiondate");
            if (!Objects.isNull(admissionDate)) {
                model.setValue("admissiondate", (Object)HRDateTimeUtils.parseDate((String)((String)admissionDate)));
            }
            if (!Objects.isNull(gradutionDate = eduExpInfo.get("gradutiondate"))) {
                model.setValue("gradutiondate", (Object)HRDateTimeUtils.parseDate((String)((String)gradutionDate)));
            }
        }
        catch (Exception exception) {
            LOG.error("ParseException", (Throwable)exception);
        }
        Object schoolSystem = eduExpInfo.get("schoolsystem");
        if (!Objects.isNull(schoolSystem)) {
            BigDecimal bigDecimal = (BigDecimal)schoolSystem;
            String str = bigDecimal.setScale(1, 5).toString();
            if (str.endsWith(".0")) {
                str = bigDecimal.setScale(0, 5).toString();
            }
            if ("0".equals(str)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"schoolsystemflex"});
            } else {
                Label schoolSystemLabel = (Label)this.getControl("schoolsystem");
                schoolSystemLabel.setText(str);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"schoolsystemflex"});
        }
        Label name = (Label)this.getControl("name");
        Object graduateSchool = eduExpInfo.get("graduateschool");
        if (!Objects.isNull(graduateSchool)) {
            name.setText(HRStringUtils.isEmpty((String)String.valueOf(graduateSchool)) ? "-" : graduateSchool.toString());
        }
        model.setValue("education", eduExpInfo.get("education_id"));
        model.setValue("degree", eduExpInfo.get("degree_id"));
        Object major = eduExpInfo.get("major");
        String secondMajor = (String)eduExpInfo.get("secondmajor");
        String majorStr = HRStringUtils.isEmpty((String)secondMajor) ? (String)major : major + "\u3001" + secondMajor;
        model.setValue("major", (Object)(HRStringUtils.isEmpty((String)majorStr) ? "-" : majorStr));
        this.getView().setVisible(Boolean.FALSE, new String[]{"label3"});
        model.updateCache();
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        FORM_COMMON_SERVICE.showMoreLabel(evt, "label3", (String)this.getModel().getValue("morelabel"));
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.hr.hrti.formplugin.web.portrait.infodetail.EduExpInfoPlugin.afterShowTips(AfterShowTipsEvent)");
    }
}

