/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.infodetail;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.formplugin.formservice.FormCommonService;
import kd.hr.hrti.formplugin.formservice.FormServiceFactory;

public class PreWorkExpInfoPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(PreWorkExpInfoPlugin.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label_3 = (Label)this.getControl("label3");
        label_3.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List sortPreWorkExpList = (List)fsp.getCustomParam("data");
        int currSize = (Integer)fsp.getCustomParam("currSize");
        if (sortPreWorkExpList.size() == currSize + 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"line"});
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("sceneId", 0L);
        Map resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSLabelService", (String)"getLabelBySceneIdAndBizObjId", (Object[])new Object[]{paramMap});
        if (CollectionUtils.isEmpty((Map)resultMap) || "200".equals(resultMap.get("responseCode"))) {
            // empty if block
        }
        IDataModel model = this.getModel();
        Map preWorkExpInfo = (Map)sortPreWorkExpList.get(currSize);
        try {
            String startDate = (String)preWorkExpInfo.get("startdate");
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                model.setValue("startdate", (Object)HRDateTimeUtils.parseDate((String)startDate));
                this.getView().setVisible(Boolean.FALSE, new String[]{"blank"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            }
            String endDate = (String)preWorkExpInfo.get("enddate");
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                model.setValue("enddate", (Object)HRDateTimeUtils.parseDate((String)endDate));
                this.getView().setVisible(Boolean.FALSE, new String[]{"sofar"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"to", "enddate"});
            }
        }
        catch (ParseException exception) {
            LOG.error("ParseException", (Throwable)exception);
        }
        model.setValue("unitname", preWorkExpInfo.get("unitname"));
        model.setValue("department", preWorkExpInfo.get("department"));
        model.setValue("position", preWorkExpInfo.get("position"));
        String jobDescText = (String)preWorkExpInfo.get("jobdesc");
        model.setValue("jobdesc", (Object)(HRStringUtils.isEmpty((String)jobDescText) ? "-" : jobDescText));
        this.getView().setVisible(Boolean.FALSE, new String[]{"label3"});
        model.updateCache();
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        FORM_COMMON_SERVICE.showMoreLabel(evt, "label3", (String)this.getModel().getValue("morelabel"));
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.hr.hrti.formplugin.web.portrait.infodetail.PreWorkExpInfoPlugin.afterShowTips(AfterShowTipsEvent)");
    }
}

