/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.formplugin.web.portrait.infodetail;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrti.formplugin.formservice.FormCommonService;
import kd.hr.hrti.formplugin.formservice.FormServiceFactory;

public class TrainingExpInfoPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(TrainingExpInfoPlugin.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label_3 = (Label)this.getControl("label3");
        label_3.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List sortEduExpList = (List)fsp.getCustomParam("data");
        int currSize = (Integer)fsp.getCustomParam("currSize");
        if (sortEduExpList.size() == currSize + 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"line"});
        }
        Map trainingExpInfo = (Map)sortEduExpList.get(currSize);
        IDataModel model = this.getModel();
        try {
            String startDate = (String)trainingExpInfo.get("startdate");
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                model.setValue("startdate", (Object)HRDateTimeUtils.parseDate((String)startDate));
                this.getView().setVisible(Boolean.FALSE, new String[]{"blank"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"startdate"});
            }
            String endDate = (String)trainingExpInfo.get("enddate");
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                model.setValue("enddate", (Object)HRDateTimeUtils.parseDate((String)endDate));
                this.getView().setVisible(Boolean.FALSE, new String[]{"sofar"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"to", "enddate"});
            }
        }
        catch (ParseException exception) {
            LOG.error("ParseException", (Throwable)exception);
        }
        BigDecimal bigDecimal = (BigDecimal)trainingExpInfo.get("trainlength");
        String str = bigDecimal.setScale(1, 5).toString();
        if (str.endsWith(".0")) {
            str = bigDecimal.setScale(0, 5).toString();
        }
        Label label = (Label)this.getControl("trainlength");
        if ("0".equals(str)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"schoolsystemflex"});
        } else {
            label.setText(str);
        }
        model.setValue("name", trainingExpInfo.get("name"));
        String organizer = Objects.isNull(trainingExpInfo.get("organizer")) ? "-" : String.valueOf(trainingExpInfo.get("organizer"));
        model.setValue("organizer", (Object)(HRStringUtils.isEmpty((String)organizer) ? "-" : organizer));
        model.setValue("trainmode", trainingExpInfo.get("trainmode_id"));
        String training = (String)trainingExpInfo.get("trainingcertificate");
        model.setValue("trainingcertificate", (Object)(HRStringUtils.isEmpty((String)training) ? "-" : training));
        this.getView().setVisible(Boolean.FALSE, new String[]{"label3"});
        model.updateCache();
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        FORM_COMMON_SERVICE.showMoreLabel(evt, "label3", (String)this.getModel().getValue("morelabel"));
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.hr.hrti.formplugin.web.portrait.infodetail.TrainingExpInfoPlugin.afterShowTips(AfterShowTipsEvent)");
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }
}

