/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.application;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.HbjmJobApplicationService;
import kd.hr.hrti.bussiness.domain.businessscenario.service.BusinessScenarioDomainService;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageRangeTypeEnum;
import kd.hr.hrti.bussiness.domain.capacity.service.CapacityStorageDomainService;
import kd.hr.hrti.bussiness.domain.caprankexpet.service.CapRankExpectDomainService;
import kd.hr.hrti.bussiness.domain.caprankresult.service.CapRankResultDomainService;
import kd.hr.hrti.common.api.CommonResult;
import kd.hr.hrti.common.api.ResultCode;
import kd.hr.hrti.common.util.CommUtils;

public class CapacityApplicationService {
    private static final String packageKey = "hrmp-hrti-business";
    private static final Log logger = LogFactory.getLog(CapacityApplicationService.class);
    private final CapacityStorageDomainService capacityStorageDomainService = ServiceFactory.getService(CapacityStorageDomainService.class);
    private final HbjmJobApplicationService hbjmJobApplicationService = ServiceFactory.getService(HbjmJobApplicationService.class);
    private final BusinessScenarioDomainService businessScenarioDomainService = ServiceFactory.getService(BusinessScenarioDomainService.class);
    private final CapRankExpectDomainService capRankExpectDomainService = ServiceFactory.getService(CapRankExpectDomainService.class);
    private final CapRankResultDomainService capRankResultDomainService = ServiceFactory.getService(CapRankResultDomainService.class);
    private static final Set<String> allParamKey = new HashSet<String>(16);

    public Map<String, Object> queryCapacityStorageItem(Map<String, Object> params) {
        if (params == null) {
            CommonResult failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"CapacityApplicationService_0", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed);
        }
        List<String> errorKeyList = this.haveErrorKey(params);
        if (!CollectionUtils.isEmpty(errorKeyList)) {
            CommonResult failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u53c2\u6570key\u6709\u8bef\uff1a{0}", (String)"CapacityApplicationService_16", (String)packageKey, (Object[])new Object[]{errorKeyList.toString()}));
            return this.parseCommonResultToMap(failed);
        }
        logger.info("queryCapacityStorageItem\u65b9\u6cd5\u5165\u53c2\uff1a" + params.toString());
        String strNames = this.checkParamType(params);
        if (!StringUtils.isEmpty((Object)strNames)) {
            CommonResult failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u53c2\u6570\u7684\u7c7b\u578b\u6709\u8bef\u5982\u4e0b\uff1a{0}\u3002\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityApplicationService_1", (String)packageKey, (Object[])new Object[]{strNames}));
            return this.parseCommonResultToMap(failed);
        }
        Map<String, Object> failed = this.checkParamInDbAndRelation(params);
        if (failed != null) {
            return failed;
        }
        Long createOrgId = this.longTypeValue(params.get("createOrgId"));
        QFilter baseDataFilter = null;
        if (createOrgId != null && createOrgId != 0L) {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hrti_capacitystorage", (Long)createOrgId);
        }
        List<Long> generalItemIds = this.queryGeneralCapacityStorageItemIds(this.longTypeValue(params.get("countryId")), this.longTypeValue(params.get("orgId")), baseDataFilter);
        List<Long> professionalItemIds = this.queryProfessionalCapacityStorageItemIds(this.longTypeValue(params.get("jobScmId")), this.longTypeValue(params.get("jobSeqId")), this.longTypeValue(params.get("jobFamilyId")), this.longTypeValue(params.get("jobClassId")), this.longTypeValue(params.get("jobId")), this.longTypeValue(params.get("postId")), baseDataFilter);
        HashSet<Long> itemSet = new HashSet<Long>();
        itemSet.addAll(generalItemIds);
        itemSet.addAll(professionalItemIds);
        ArrayList allItemIds = Lists.newArrayList(itemSet);
        CommonResult success = CommonResult.success((Object)allItemIds);
        return this.parseCommonResultToMap(success);
    }

    private List<String> haveErrorKey(Map<String, Object> params) {
        ArrayList<String> errorKey = new ArrayList<String>(8);
        for (String key : params.keySet()) {
            if (allParamKey.contains(key)) continue;
            errorKey.add(key);
        }
        return errorKey;
    }

    private Map<String, Object> checkParamInDbAndRelation(Map<String, Object> params) {
        CommonResult failed;
        Long countryId = this.longTypeValue(params.get("countryId"));
        if (countryId != null && !this.capacityStorageDomainService.checkCountryIdInDB(countryId)) {
            CommonResult failed2 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u5185\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityApplicationService_2", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed2);
        }
        Long orgId = this.longTypeValue(params.get("orgId"));
        if (orgId != null && !this.capacityStorageDomainService.checkOrgIdInDB(orgId)) {
            CommonResult failed3 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5185\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityApplicationService_3", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed3);
        }
        Long createOrgId = this.longTypeValue(params.get("createOrgId"));
        if (createOrgId != null && !this.capacityStorageDomainService.checkBosOrgInDB(createOrgId)) {
            CommonResult failed4 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u5185\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityApplicationService_4", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed4);
        }
        Long jobScmId = this.longTypeValue(params.get("jobScmId"));
        Long jobSeqId = this.longTypeValue(params.get("jobSeqId"));
        Long jobFamilyId = this.longTypeValue(params.get("jobFamilyId"));
        Long jobClassId = this.longTypeValue(params.get("jobClassId"));
        Long jobId = this.longTypeValue(params.get("jobId"));
        Long postId = this.longTypeValue(params.get("postId"));
        if (jobScmId == null && jobSeqId == null && jobFamilyId == null && jobClassId == null && jobId == null && postId == null) {
            return null;
        }
        if (jobScmId == null && jobSeqId == null && jobId == null && postId == null) {
            CommonResult failed5 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u8bf7\u6ee1\u8db3\u5982\u4e0b\u67e5\u8be2\u6761\u4ef6\u4e4b\u4e00\uff1a1.\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848+\u804c\u4f4d\u5e8f\u5217\u90fd\u4e0d\u4e3a\u7a7a\uff1b2.\u804c\u4f4d\u4e0d\u4e3a\u7a7a\uff1b3.\u5c97\u4f4d\u4e0d\u4e3a\u7a7a", (String)"CapacityApplicationService_5", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed5);
        }
        if (jobId != null) {
            DynamicObject[] jobDatas = this.capacityStorageDomainService.queryJobDataById(jobId);
            if (jobDatas.length == 0) {
                CommonResult failed6 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u5185\u7801\u4e0d\u5b58\u5728", (String)"CapacityApplicationService_6", (String)packageKey, (Object[])new Object[0]));
                return this.parseCommonResultToMap(failed6);
            }
            Long jobscmIdRight = jobDatas[0].getLong("jobscm_id");
            Long jobseqIdRight = jobDatas[0].getLong("jobseq_id");
            Long jobFamilyIdRight = jobDatas[0].getLong("jobfamily_id");
            Long jobClassIdRight = jobDatas[0].getLong("jobclass_id");
            if (jobScmId != null && !jobScmId.equals(jobscmIdRight)) {
                CommonResult failed7 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u5bf9\u5e94\u7684\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u4e0e\u5165\u53c2\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u4e0d\u5339\u914d", (String)"CapacityApplicationService_7", (String)packageKey, (Object[])new Object[0]));
                return this.parseCommonResultToMap(failed7);
            }
            if (jobSeqId != null && !jobSeqId.equals(jobseqIdRight)) {
                CommonResult failed8 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"", (String)"CapacityApplicationService_17", (String)packageKey, (Object[])new Object[0]));
                return this.parseCommonResultToMap(failed8);
            }
            if (jobFamilyId != null && !jobFamilyId.equals(jobFamilyIdRight)) {
                CommonResult failed9 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u5bf9\u5e94\u7684\u804c\u4f4d\u5e8f\u5217\u4e0e\u5165\u53c2\u804c\u4f4d\u5e8f\u5217\u4e0d\u5339\u914d", (String)"CapacityApplicationService_8", (String)packageKey, (Object[])new Object[0]));
                return this.parseCommonResultToMap(failed9);
            }
            if (jobClassId != null && !jobClassId.equals(jobClassIdRight)) {
                CommonResult failed10 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u5bf9\u5e94\u7684\u804c\u4f4d\u7c7b\u4e0e\u5165\u53c2\u804c\u4f4d\u7c7b\u4e0d\u5339\u914d", (String)"CapacityApplicationService_10", (String)packageKey, (Object[])new Object[0]));
                return this.parseCommonResultToMap(failed10);
            }
        }
        if (jobScmId != null && jobSeqId != null && !this.hbjmJobApplicationService.scmAndSeqIsExists(jobScmId, jobSeqId)) {
            failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848+\u804c\u4f4d\u5e8f\u5217\u5728\u5173\u7cfb\u8868\u4e2d\u672a\u627e\u5230", (String)"CapacityApplicationService_11", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed);
        }
        if (jobScmId != null && jobSeqId != null && jobFamilyId != null && !this.hbjmJobApplicationService.scmAndFamilyIsExists(jobScmId, jobSeqId, jobFamilyId)) {
            failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848+\u804c\u4f4d\u5e8f\u5217+\u804c\u4f4d\u65cf\u5728\u5173\u7cfb\u8868\u4e2d\u672a\u627e\u5230", (String)"CapacityApplicationService_12", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed);
        }
        if (jobScmId != null && jobFamilyId != null && jobClassId != null && !this.hbjmJobApplicationService.scmAndClassIsExists(jobScmId, jobFamilyId, jobClassId)) {
            failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848+\u804c\u4f4d\u65cf+\u804c\u4f4d\u7c7b\u5728\u5173\u7cfb\u8868\u4e2d\u672a\u627e\u5230", (String)"CapacityApplicationService_13", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed);
        }
        if (postId != null && !this.hbjmJobApplicationService.postIsExists(postId)) {
            failed = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u5c97\u4f4d\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u672a\u627e\u5230\u3002", (String)"CapacityApplicationService_14", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed);
        }
        String appendStr = "";
        appendStr = jobScmId == null ? appendStr + "0" : appendStr + "1";
        appendStr = jobSeqId == null ? appendStr + "0" : appendStr + "1";
        appendStr = jobFamilyId == null ? appendStr + "0" : appendStr + "1";
        String string = appendStr = jobClassId == null ? appendStr + "0" : appendStr + "1";
        if (appendStr.contains("01")) {
            CommonResult failed11 = CommonResult.failed((ResultCode)ResultCode.BAD_REQUEST, (String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u7b26\u5408\u67e5\u8be2\u4e13\u4e1a\u80fd\u529b\u5e93\u6570\u636e\u7684\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"CapacityApplicationService_15", (String)packageKey, (Object[])new Object[0]));
            return this.parseCommonResultToMap(failed11);
        }
        return null;
    }

    private Map<String, Object> parseCommonResultToMap(CommonResult commonResult) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("code", commonResult.getCode());
        resultMap.put("message", commonResult.getMessage());
        resultMap.put("data", commonResult.getData());
        return resultMap;
    }

    public List<DynamicObject> queryCapacityStorage(Map<String, Object> params) {
        Long createOrgId = this.longTypeValue(params.get("createOrgId"));
        QFilter baseDataFilter = null;
        if (createOrgId != null && createOrgId != 0L) {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hrti_capacitystorage", (Long)createOrgId);
        }
        List<DynamicObject> generalStorages = this.queryGeneralCapacityStorage(this.longTypeValue(params.get("countryId")), this.longTypeValue(params.get("orgId")), baseDataFilter);
        Long jobscmId = this.longTypeValue(params.get("jobScmId"));
        Long jobseqId = this.longTypeValue(params.get("jobSeqId"));
        Long jobFamilyId = this.longTypeValue(params.get("jobFamilyId"));
        Long jobClassId = this.longTypeValue(params.get("jobClassId"));
        Long jobId = this.longTypeValue(params.get("jobId"));
        Long postId = this.longTypeValue(params.get("postId"));
        List<DynamicObject> professionalStorages = this.queryProfessionalCapacityStorage(jobscmId, jobseqId, jobFamilyId, jobClassId, jobId, postId, baseDataFilter);
        ArrayList<DynamicObject> allList = new ArrayList<DynamicObject>();
        allList.addAll(generalStorages);
        allList.addAll(professionalStorages);
        return allList;
    }

    private String checkParamType(Map<String, Object> params) {
        String paramNames = "";
        Object countryIdObj = params.get("countryId");
        String countryKey = "countryId";
        paramNames = this.appendLongErrorParam(paramNames, countryIdObj, countryKey);
        Object orgIdObj = params.get("orgId");
        String orgKey = "orgId";
        paramNames = this.appendLongErrorParam(paramNames, orgIdObj, orgKey);
        Object jobScmIdObj = params.get("jobScmId");
        String jobScmKey = "jobScmId";
        paramNames = this.appendLongErrorParam(paramNames, jobScmIdObj, jobScmKey);
        Object jobSeqIdObj = params.get("jobSeqId");
        String jobSeqKey = "jobSeqId";
        paramNames = this.appendLongErrorParam(paramNames, jobSeqIdObj, jobSeqKey);
        Object jobFamilyIdObj = params.get("jobFamilyId");
        String jobFamilyKey = "jobFamilyId";
        paramNames = this.appendLongErrorParam(paramNames, jobFamilyIdObj, jobFamilyKey);
        Object jobClassIdObj = params.get("jobClassId");
        String jobClassKey = "jobClassId";
        paramNames = this.appendLongErrorParam(paramNames, jobClassIdObj, jobClassKey);
        Object jobIdObj = params.get("jobId");
        String jobIdKey = "jobId";
        paramNames = this.appendLongErrorParam(paramNames, jobIdObj, jobIdKey);
        Object postIdObj = params.get("postId");
        String postKey = "postId";
        paramNames = this.appendLongErrorParam(paramNames, postIdObj, postKey);
        Object createOrgIdObj = params.get("createOrgId");
        String createOrgKey = "createOrgId";
        paramNames = this.appendLongErrorParam(paramNames, createOrgIdObj, createOrgKey);
        return paramNames;
    }

    private String appendLongErrorParam(String paramNames, Object obj, String key) {
        if (obj == null) {
            return paramNames;
        }
        if (!(obj instanceof Long)) {
            return this.appendKey(paramNames, key);
        }
        return paramNames;
    }

    private String appendStringErrorParam(String paramNames, Object obj, String key) {
        if (obj == null) {
            return paramNames;
        }
        if (!(obj instanceof String)) {
            return this.appendKey(paramNames, key);
        }
        return paramNames;
    }

    private String appendKey(String paramNames, String key) {
        if (StringUtils.isEmpty((Object)paramNames)) {
            return CommUtils.appendStr((String[])new String[]{paramNames, key});
        }
        return paramNames;
    }

    private Long longTypeValue(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    private String stringTypeValue(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        return null;
    }

    public List<Long> queryGeneralCapacityStorageItemIds(Long countryId, Long orgId, QFilter baseDataFilter) {
        List<DynamicObject> generalCapacityStroageItemObjs = this.queryGeneralCapacityStorage(countryId, orgId, baseDataFilter);
        return this.getCapacityStorageItemId(generalCapacityStroageItemObjs);
    }

    public List<DynamicObject> queryGeneralCapacityStorage(Long countryId, Long orgId, QFilter baseDataFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (countryId != null || orgId != null) {
            Object[] generalCapStorage = this.capacityStorageDomainService.getGeneralCapStorage(countryId, orgId, baseDataFilter);
            list.addAll(Lists.newArrayList((Object[])generalCapStorage));
        }
        Object[] generalCapacityStorage = this.capacityStorageDomainService.getGeneralCapacityStorage(baseDataFilter);
        list.addAll(Lists.newArrayList((Object[])generalCapacityStorage));
        return list;
    }

    private List<Long> getCapacityStorageItemId(List<DynamicObject> list) {
        HashSet<Long> itemSet = new HashSet<Long>();
        for (DynamicObject storageDynamicObject : list) {
            DynamicObjectCollection entryentity = storageDynamicObject.getDynamicObjectCollection("entryentity");
            if (entryentity.size() == 0) continue;
            for (DynamicObject item : entryentity) {
                itemSet.add(item.getLong("capitem_id"));
            }
        }
        return Lists.newArrayList(itemSet);
    }

    public List<Long> queryProfessionalCapacityStorageItemIds(Long jobScmId, Long jobSeqId, Long jobFamilyId, Long jobClassId, Long jobId, Long postId, QFilter baseDataFilter) {
        List<DynamicObject> professionalItems = this.queryProfessionalCapacityStorage(jobScmId, jobSeqId, jobFamilyId, jobClassId, jobId, postId, baseDataFilter);
        return this.getCapacityStorageItemId(professionalItems);
    }

    public List<DynamicObject> queryProfessionalCapacityStorage(Long jobScmId, Long jobSeqId, Long jobFamilyId, Long jobClassId, Long jobId, Long postId, QFilter baseDataFilter) {
        boolean jobParamNotNull;
        boolean scmIdAndJobSeqIdBothNotNull = this.idIsNotNull(jobScmId) && this.idIsNotNull(jobSeqId);
        boolean bl = jobParamNotNull = scmIdAndJobSeqIdBothNotNull || this.idIsNotNull(jobId);
        if (jobParamNotNull && this.idIsNull(postId)) {
            return this.getJobCapacityStorage(jobScmId, jobSeqId, jobFamilyId, jobClassId, jobId, postId, false, baseDataFilter);
        }
        if (this.idIsNull(jobScmId) && this.idIsNull(jobSeqId) && this.idIsNull(jobId) && this.idIsNotNull(postId)) {
            return this.getPostCapcityStorageItem(postId, baseDataFilter);
        }
        if (jobParamNotNull && this.idIsNotNull(postId)) {
            List<DynamicObject> jobItemObjs = this.getJobCapacityStorage(jobScmId, jobSeqId, jobFamilyId, jobClassId, jobId, postId, false, baseDataFilter);
            List<DynamicObject> postItemObjs = this.getPostCapcityStorageItem(postId, baseDataFilter);
            List<DynamicObject> jobAndPostItemObjs = this.getJobCapacityStorage(jobScmId, jobSeqId, jobFamilyId, jobClassId, jobId, postId, true, baseDataFilter);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            list.addAll(jobItemObjs);
            list.addAll(postItemObjs);
            list.addAll(jobAndPostItemObjs);
            return list;
        }
        return new ArrayList<DynamicObject>();
    }

    private boolean idIsNull(Long id) {
        return id == null || id == 0L;
    }

    private boolean idIsNotNull(Long id) {
        return id != null && id > 0L;
    }

    private List<DynamicObject> getPostCapcityStorageItem(Long postId, QFilter baseDataFilter) {
        DynamicObject[] capacityStorage = this.capacityStorageDomainService.getProfessionalCapacityStorageByPost(postId, baseDataFilter);
        List<DynamicObject> collect = Arrays.stream(capacityStorage).filter(this.getNotIncludeFieldPredicate("capstorjobseq")).filter(this.getNotIncludeFieldPredicate("capstorjobfamily")).filter(this.getNotIncludeFieldPredicate("capstorjobclass")).collect(Collectors.toList());
        return collect;
    }

    public List<DynamicObject> getJobCapacityStorage(Long jobScmId, Long jobSeqId, Long jobFamilyId, Long jobClassId, Long jobId, Long postId, boolean equalPostId, QFilter baseDataFilter) {
        DynamicObject[] jobHrData;
        if (this.idIsNull(jobScmId) && this.idIsNull(jobSeqId) && this.idIsNull(jobFamilyId) && this.idIsNull(jobClassId) && this.idIsNotNull(jobId) && (jobHrData = this.hbjmJobApplicationService.getJobHrData(Lists.newArrayList((Object[])new Long[]{jobId}))).length > 0) {
            jobScmId = jobHrData[0].getLong("jobscm");
            jobSeqId = jobHrData[0].getLong("jobseq");
            jobFamilyId = jobHrData[0].getLong("jobfamily");
            jobClassId = jobHrData[0].getLong("jobclass");
        }
        return this.getCapcityItemByJobId(jobScmId, jobSeqId, jobFamilyId, jobClassId, jobId, postId, equalPostId, baseDataFilter);
    }

    private List<DynamicObject> getCapcityItemByJobId(Long jobScmId, Long jobSeqId, Long jobFamilyId, Long jobClassId, Long jobId, Long postId, boolean equalPostId, QFilter baseDataFilter) {
        DynamicObject[] professionDynamicObjects;
        ArrayList<DynamicObject> itemDynaimcObjectList = new ArrayList<DynamicObject>();
        String number = CapacityStorageRangeTypeEnum.JOB.getNumber();
        if (equalPostId) {
            number = CapacityStorageRangeTypeEnum.JOBANDPOST.getNumber();
        }
        if ((professionDynamicObjects = this.capacityStorageDomainService.getProfessionalCapacityStorage(jobScmId, jobSeqId, number, baseDataFilter)).length > 0) {
            Stream<DynamicObject> scmAndSeqStream = Arrays.stream(professionDynamicObjects).filter(this.getNotIncludeFieldPredicate("capstorjobfamily")).filter(this.getNotIncludeFieldPredicate("capstorjobclass")).filter(this.getNotIncludeFieldPredicate("capjob"));
            scmAndSeqStream = equalPostId ? scmAndSeqStream.filter(this.getIncludeFieldIdPredicate(postId, "post")) : scmAndSeqStream.filter(this.getNotIncludeFieldPredicate("post"));
            List scmAndSeqCapcityStorage = scmAndSeqStream.collect(Collectors.toList());
            itemDynaimcObjectList.addAll(scmAndSeqCapcityStorage);
            if (this.idIsNotNull(jobFamilyId)) {
                Stream<DynamicObject> familyStream = Arrays.stream(professionDynamicObjects).filter(this.getIncludeFieldIdPredicate(jobFamilyId, "capstorjobfamily")).filter(this.getNotIncludeFieldPredicate("capstorjobclass")).filter(this.getNotIncludeFieldPredicate("capjob"));
                familyStream = equalPostId ? familyStream.filter(this.getIncludeFieldIdPredicate(postId, "post")) : familyStream.filter(this.getNotIncludeFieldPredicate("post"));
                List familyCapcityStorage = familyStream.collect(Collectors.toList());
                itemDynaimcObjectList.addAll(familyCapcityStorage);
            }
            if (this.idIsNotNull(jobFamilyId) && this.idIsNotNull(jobClassId)) {
                Stream<DynamicObject> classStream = Arrays.stream(professionDynamicObjects).filter(this.getIncludeFieldIdPredicate(jobFamilyId, "capstorjobfamily")).filter(this.getIncludeFieldIdPredicate(jobClassId, "capstorjobclass")).filter(this.getNotIncludeFieldPredicate("capjob"));
                classStream = equalPostId ? classStream.filter(this.getIncludeFieldIdPredicate(postId, "post")) : classStream.filter(this.getNotIncludeFieldPredicate("post"));
                List classCapcityStorage = classStream.collect(Collectors.toList());
                itemDynaimcObjectList.addAll(classCapcityStorage);
            }
            if (this.idIsNotNull(jobId)) {
                Stream<DynamicObject> jobStream = Arrays.stream(professionDynamicObjects);
                if (this.idIsNotNull(jobFamilyId)) {
                    jobStream = jobStream.filter(this.getIncludeFieldIdPredicate(jobFamilyId, "capstorjobfamily"));
                }
                if (this.idIsNotNull(jobClassId)) {
                    jobStream = jobStream.filter(this.getIncludeFieldIdPredicate(jobClassId, "capstorjobclass"));
                }
                jobStream = jobStream.filter(this.getIncludeFieldIdPredicate(jobId, "capjob"));
                jobStream = equalPostId ? jobStream.filter(this.getIncludeFieldIdPredicate(postId, "post")) : jobStream.filter(this.getNotIncludeFieldPredicate("post"));
                List jobCapcityStorage = jobStream.collect(Collectors.toList());
                itemDynaimcObjectList.addAll(jobCapcityStorage);
            }
        }
        return itemDynaimcObjectList;
    }

    private Predicate<DynamicObject> getNotIncludeFieldPredicate(String field) {
        return dynamicObject -> ((MulBasedataDynamicObjectCollection)dynamicObject.get(field)).size() == 0;
    }

    private Predicate<DynamicObject> getIncludeFieldIdPredicate(Long finalJobId, String field) {
        return dynamicObject -> {
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)dynamicObject.get(field);
            for (DynamicObject obj : collection) {
                long aLong = obj.getLong("fbasedataid_id");
                if (!finalJobId.equals(aLong)) continue;
                return true;
            }
            return false;
        };
    }

    public boolean updateCapRankExpect(Long employee, Long capItem, Long capItemRank, Long businessScenario) {
        if (this.checkEmployee(employee)) {
            return false;
        }
        if (this.checkItemparam(capItem, capItemRank)) {
            return false;
        }
        if (this.checkBusinessScenario(businessScenario)) {
            return false;
        }
        DynamicObject[] data = this.capRankResultDomainService.queryPersonCapRankData("hrti_caprankexpect", employee, capItem);
        if (data.length == 0) {
            this.capRankExpectDomainService.saveOne(employee, capItem, capItemRank, businessScenario);
        } else {
            DynamicObject dynamicObject = data[0];
            dynamicObject.set("capitemrank_id", (Object)capItemRank);
            dynamicObject.set("busiscen_id", (Object)businessScenario);
            this.capRankExpectDomainService.saveOne(dynamicObject);
        }
        return true;
    }

    public boolean updateCapRankResult(Long employee, Long capItem, Long capItemRank, Long businessScenario) {
        if (this.checkEmployee(employee)) {
            return false;
        }
        if (this.checkItemparam(capItem, capItemRank)) {
            return false;
        }
        if (this.checkBusinessScenario(businessScenario)) {
            return false;
        }
        DynamicObject[] data = this.capRankResultDomainService.queryPersonCapRankData("hrti_caprankresult", employee, capItem);
        if (data.length == 0) {
            this.capRankResultDomainService.saveOne(employee, capItem, capItemRank, businessScenario);
        } else {
            DynamicObject dynamicObject = data[0];
            dynamicObject.set("capitemrank_id", (Object)capItemRank);
            dynamicObject.set("busiscen_id", (Object)businessScenario);
            this.capRankResultDomainService.saveOne(dynamicObject);
        }
        return true;
    }

    private boolean checkItemparam(Long capItem, Long capItemRank) {
        Map itemMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSCapacityService", (String)"queryCapacityItem", (Object[])new Object[]{capItem});
        if (CollectionUtils.isEmpty((Map)itemMap)) {
            logger.info(ResManager.loadKDString((String)"\u80fd\u529b\u7d20\u8d28\u9879\u4e0d\u5b58\u5728\u3002", (String)"CapacityApplicationService_20", (String)packageKey, (Object[])new Object[0]));
            return true;
        }
        String enable = (String)itemMap.get("enable");
        if (!"1".equals(enable)) {
            logger.info(ResManager.loadKDString((String)"\u80fd\u529b\u7d20\u8d28\u9879\u4e0d\u53ef\u7528\u3002", (String)"CapacityApplicationService_21", (String)packageKey, (Object[])new Object[0]));
            return true;
        }
        if (itemMap.get("rankList") == null) {
            logger.info(ResManager.loadKDString((String)"\u80fd\u529b\u7d20\u8d28\u9879\u7f3a\u5c11\u80fd\u529b\u7b49\u7ea7\u3002", (String)"CapacityApplicationService_22", (String)packageKey, (Object[])new Object[0]));
            return true;
        }
        boolean haveItem = false;
        List rankList = (List)itemMap.get("rankList");
        for (HashMap map : rankList) {
            Long rankId = (Long)map.get("rankId");
            if (!capItemRank.equals(rankId)) continue;
            haveItem = true;
        }
        if (!haveItem) {
            logger.info(ResManager.loadKDString((String)"\u80fd\u529b\u7d20\u8d28\u9879\u7684\u80fd\u529b\u7b49\u7ea7\u4e0e\u53c2\u6570\u7684\u80fd\u529b\u7b49\u7ea7\u4e0d\u76f8\u7b26\u3002", (String)"CapacityApplicationService_23", (String)packageKey, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkBusinessScenario(Long businessScenario) {
        DynamicObject businessScenarioDy = this.businessScenarioDomainService.queryOneByPkValue(businessScenario);
        if (HRObjectUtils.isEmpty((Object)businessScenarioDy)) {
            logger.info("\u672a\u6ce8\u518c\u6570\u636e\u6765\u6e90");
            return true;
        }
        return false;
    }

    private boolean checkEmployee(Long employee) {
        Map employeeDy = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployee", (Object[])new Object[]{employee});
        if (CollectionUtils.isEmpty((Map)employeeDy)) {
            logger.info(employee + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u4eba\u4e0d\u5b58\u5728");
            return true;
        }
        String businessStatus = (String)employeeDy.get("businessstatus");
        if (!"1".equals(businessStatus)) {
            logger.info(employee + "\u5bf9\u5e94\u7684\u4f01\u4e1a\u4eba\u4e0d\u751f\u6548");
            return true;
        }
        return false;
    }

    public List<DynamicObject> getCapRankExpect(Long employee) {
        return Lists.newArrayList((Object[])this.capRankExpectDomainService.getOneByEmployee(employee));
    }

    public List<DynamicObject> getCapRankResult(Long employee) {
        return Lists.newArrayList((Object[])this.capRankResultDomainService.getOneByEmployee(employee));
    }

    static {
        allParamKey.add("countryId");
        allParamKey.add("orgId");
        allParamKey.add("jobScmId");
        allParamKey.add("jobSeqId");
        allParamKey.add("jobFamilyId");
        allParamKey.add("jobClassId");
        allParamKey.add("jobId");
        allParamKey.add("postId");
        allParamKey.add("createOrgId");
    }
}

