/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.application;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"hrmp-hrti-business", (Object[])new Object[0]), serviceName));
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz.newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"hrmp-hrti-business", (Object[])new Object[0]), serviceName), exp);
        }
    }

    static {
        SERVICE_MAP.put("HbjmJobApplicationService", "kd.hr.hrti.bussiness.application.external.HbjmJobApplicationService");
        SERVICE_MAP.put("CapacityApplicationService", "kd.hr.hrti.bussiness.application.CapacityApplicationService");
        SERVICE_MAP.put("HrtiExternalService", "kd.hr.hrti.bussiness.application.external.HrtiExternalService");
        SERVICE_MAP.put("BizApplicationService", "kd.hr.hrti.bussiness.application.external.BizApplicationService");
        SERVICE_MAP.put("CapacityStorageDomainService", "kd.hr.hrti.bussiness.domain.capacity.service.CapacityStorageDomainService");
        SERVICE_MAP.put("BusinessScenarioDomainService", "kd.hr.hrti.bussiness.domain.businessscenario.service.BusinessScenarioDomainService");
        SERVICE_MAP.put("CapRankExpectDomainService", "kd.hr.hrti.bussiness.domain.caprankexpet.service.CapRankExpectDomainService");
        SERVICE_MAP.put("CapRankResultDomainService", "kd.hr.hrti.bussiness.domain.caprankresult.service.CapRankResultDomainService");
    }
}

