/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.application.external;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;

public class BizApplicationService {
    private static final Log LOG = LogFactory.getLog(BizApplicationService.class);

    public DynamicObject[] queryFormInfoByFormIds(List<String> formIds) {
        HRBaseServiceHelper formMeta = new HRBaseServiceHelper("bos_formmeta");
        QFilter qFilter = new QFilter("id", "in", formIds);
        return formMeta.query("id,number,inheritpath,type", new QFilter[]{qFilter});
    }

    public String queryNewestSchemeIdByNumber(String number) {
        LOG.info("queryNewestSchemeIdByNumber###number:{}", (Object)number);
        HRBaseServiceHelper portraitHelper = new HRBaseServiceHelper("portal_scheme");
        QFilter formNumberQFilter = new QFilter("formnum", "=", (Object)"hrti_workbench");
        QFilter viewNumberQFilter = new QFilter("number", "=", (Object)String.valueOf(number));
        DynamicObject saveResultDy = portraitHelper.queryOriginalOne("id", new QFilter[]{formNumberQFilter, viewNumberQFilter}, "createtime desc");
        if (Objects.isNull(saveResultDy)) {
            return "";
        }
        return String.valueOf(saveResultDy.get("id"));
    }

    @Deprecated
    public String matchSchemeId(Long employeeId, String sceneNumber) {
        String schemeId = null;
        LOG.info("employeeId###sceneNumber:{},{}", (Object)employeeId, (Object)sceneNumber);
        try {
            schemeId = (String)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tlmg", (String)"ITLMGPortraitService", (String)"getPortraitConfigSchemeId", (Object[])new Object[]{employeeId, sceneNumber});
        }
        catch (Exception exception) {
            LOG.error("matchSchemeId##error###sceneNumber:{},exception:", (Object)sceneNumber, (Object)exception);
        }
        LOG.info("------------matchSchemeId:{}", schemeId);
        return schemeId;
    }

    public HRMServiceResult matchSchemeId(Map<String, Object> paramMap) {
        LOG.info("matchSchemeId###paramMap:{}", paramMap);
        try {
            HRMServiceResult returnResult = (HRMServiceResult)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tlmg", (String)"ITLMGPortraitService", (String)"matchPortraitSchemeId", (Object[])new Object[]{paramMap});
            LOG.info("matchSchemeId###returnResult:{}", (Object)returnResult);
            return returnResult;
        }
        catch (Exception exception) {
            LOG.error("matchSchemeId##exception:", (Throwable)exception);
            return HRMServiceResult.fail((String)ResManager.loadKDString((String)"\u5339\u914d\u753b\u50cf\u89c6\u56fe\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizApplicationService_0", (String)"hrmp-hrti-business", (Object[])new Object[0]));
        }
    }

    public List<Long> getDeleteSchemeIds(Object[] schemeIds) {
        List schemeIdsStr = Arrays.stream(schemeIds).map(String::valueOf).collect(Collectors.toList());
        LOG.info("validateSchemeIds###schemeIdsStr:{},{}", schemeIdsStr);
        try {
            List ids = (List)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tlmg", (String)"ITLMGPortraitService", (String)"getPortraitConfigSchemeIds", (Object[])new Object[]{schemeIdsStr});
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                schemeIdsStr.removeAll(ids);
            }
        }
        catch (Exception exception) {
            LOG.error("querySchemeIds##error:", (Throwable)exception);
        }
        return schemeIdsStr.stream().map(Long::valueOf).collect(Collectors.toList());
    }

    public Map<String, Object> querySalaryData(Long empId) {
        return Maps.newHashMap();
    }

    public Map<String, Object> queryYearAttendanceSta(Long empId) {
        return Maps.newHashMap();
    }

    public Map<String, Object> queryPerformanceSta(Long empId) {
        return Maps.newHashMap();
    }
}

