/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.application.external;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class HrtiExternalService {
    private static final Log logger = LogFactory.getLog(HrtiExternalService.class);
    private static final String HRPI = "hrpi";
    private static final String LIST_PERSON_ATTACHS = "listPersonAttachs";
    private static final String IHRPI_PERSON_SERVICE = "IHRPIPersonService";
    private static final String IHRPI_EMPLOYEE_SERVICE = "IHRPIEmployeeService";
    private static final HRBaseServiceHelper TDCS_QUALIFICATION_RECORD_HELPER = new HRBaseServiceHelper("tdcs_cerprocessrecord");
    private static final HRBaseServiceHelper HRPI_PERNONTSPROP_INIT_HELPER = new HRBaseServiceHelper("hrpi_pernontsprop_init");
    private static final HRBaseServiceHelper HRPI_EMPLOYEE_HELPER = new HRBaseServiceHelper("hrpi_employee");

    public List<Map<String, Object>> getCandidateInterviewList(List<Long> candidateIdList) {
        List resultList = (List)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"appFileService", (String)"getCandidateIntInfo", (Object[])new Object[]{candidateIdList});
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new ArrayList<Map<String, Object>>();
        }
        logger.info("TSCApplicationService-->getCandidateInterviewList-->param:{},return resultList:{}", candidateIdList, (Object)resultList);
        return resultList;
    }

    public List<Map<String, Object>> listPersonAttachs(long personId, String metaString) {
        logger.info("ExternalService-->listPersonAttachs->personId:{0},metaString:{1}", (Object)personId, (Object)metaString);
        List resultList = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)LIST_PERSON_ATTACHS, (Object[])new Object[]{personId, metaString});
        logger.info("ExternalService-->listPersonAttachs->personId:{0},metaString:{1}", (Object)personId, (Object)metaString);
        return resultList;
    }

    public Map<String, Object> queryPersonalInfo(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getPersonBaseInfo", (Object[])new Object[]{personId});
    }

    public Map<String, Object> getEmployeeInfo(Long employeeId) {
        Map personBaseInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_EMPLOYEE_SERVICE, (String)"getEmployee", (Object[])new Object[]{employeeId});
        logger.info("HRApplicationService-->getEmployee-->param:{} ,return personBaseInfoMap:{}", (Object)employeeId, (Object)personBaseInfoMap);
        return personBaseInfoMap;
    }

    public DynamicObject[] queryByEmpIdOrderByMs(long employeeId) {
        return TDCS_QUALIFICATION_RECORD_HELPER.query("id,person,employee,cerresult,enabledate,disenabledate,cerstandtxt,cerleveltxt,createtime,ceropinion,isappeal,appealresult,submittime", new QFilter[]{new QFilter("employee", "=", (Object)employeeId)}, "enabledate asc");
    }

    public Map<String, Object> getPersonContact(long personId) {
        logger.info("HRApplicationService-->getPersonContact-->personId:{}", (Object)personId);
        List personContactMapList = null;
        try {
            personContactMapList = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)LIST_PERSON_ATTACHS, (Object[])new Object[]{personId, "hrpi_percontact"});
        }
        catch (Exception exception) {
            logger.error("HRApplicationService-->getPersonContact-->return personInfoMap:exception", (Throwable)exception);
        }
        if (Objects.isNull(personContactMapList) || CollectionUtils.isEmpty(personContactMapList)) {
            return new HashMap<String, Object>();
        }
        return (Map)personContactMapList.get(0);
    }

    public Map<String, Object> getPersonInfo(Long personId) {
        logger.info("IHRPIPersonService-->getPersonInfo-->personId:{}", (Object)personId);
        Map personInfoMap = null;
        try {
            personInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getPersonInfo", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService-->getPersonInfo-->responseData:exception", (Throwable)exception);
        }
        logger.info("IHRPIPersonService-->getPersonInfo-->responseData:{}", personInfoMap);
        return personInfoMap;
    }

    public Map<String, Object> getEmpentrel(long employeeId) {
        logger.info("IHRPIEmployeeService-->getEmpentrel-->employeeId:{}", (Object)employeeId);
        Map empentrelMap = null;
        try {
            empentrelMap = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_EMPLOYEE_SERVICE, (String)"getEmpentrel", (Object[])new Object[]{employeeId});
        }
        catch (Exception exception) {
            logger.info("IHRPIEmployeeService-->getEmpentrel-->responseData:exception}", (Object)exception);
        }
        logger.info("IHRPIEmployeeService-->getEmpentrel-->responseData:{}", empentrelMap);
        return empentrelMap;
    }

    public List<Map<String, Object>> listEmployeeAttachs(long employeeId, String entityName) {
        logger.info("IHRPIEmployeeService-->listEmployeeAttachs-->employeeId:{0}-->entityName:{1}", (Object)employeeId, (Object)entityName);
        List employeeAttachInfo = null;
        try {
            employeeAttachInfo = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_EMPLOYEE_SERVICE, (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, entityName});
        }
        catch (Exception exception) {
            logger.error("IHRPIEmployeeService-->listEmployeeAttachs-->responseData:exception", (Throwable)exception);
        }
        logger.info("IHRPIEmployeeService-->listEmployeeAttachs-->responseData:{}", employeeAttachInfo);
        return employeeAttachInfo;
    }

    public List<Map<String, Object>> getPersonCommWorkRecord(long employeeId) {
        logger.info("ITDCSService-->getPersonCommWorkRecord-->employeeId:{0}", (Object)employeeId);
        List personCommWorkRecords = null;
        try {
            personCommWorkRecords = (List)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"ITDCSService", (String)"getPersonCommWorkRecord", (Object[])new Object[]{employeeId});
        }
        catch (Exception exception) {
            logger.error("ITDCSService-->getPersonCommWorkRecord-->responseData:exception", (Throwable)exception);
        }
        logger.info("ITDCSService-->getPersonCommWorkRecord-->responseData:{}", personCommWorkRecords);
        return personCommWorkRecords;
    }

    public Map<String, Object> getPrimaryEmpposorgrel(long personId) {
        logger.info("IHRPIPersonService-->getPrimaryEmpposorgrel-->personId:{0}", (Object)personId);
        Map primaryEmpExpInfo = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
        logger.info("IHRPIPersonService-->getPrimaryEmpposorgrel-->responseData:{}", (Object)primaryEmpExpInfo);
        return primaryEmpExpInfo;
    }

    public DynamicObject[] queryJobLevelScm(Long jobLevelScmId) {
        HRBaseServiceHelper jobGradeScmService = new HRBaseServiceHelper("hbjm_joblevelscmhr");
        return jobGradeScmService.queryOriginalArray("entryentity,entryentity.joblevel_name,entryentity.joblevel_seq,entryentity.entryboid,entryentity.joblevel_enable", new QFilter[]{new QFilter("id", "=", (Object)jobLevelScmId)});
    }

    public DynamicObject[] queryJobGradeScm(Long jobGradeScmId) {
        HRBaseServiceHelper jobGradeScmService = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        return jobGradeScmService.queryOriginalArray("entryentity,entryentity.jobgrade_name,entryentity.jobgrade_seq,entryentity.entryboid,entryentity.jobgrade_enable", new QFilter[]{new QFilter("id", "=", (Object)jobGradeScmId)});
    }

    public DynamicObject queryTalaLabelMainObjId(long employeeId) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("id", "=", (Object)employeeId));
        DynamicObject[] data = HRPI_EMPLOYEE_HELPER.query("id", new QFilter[]{qFilter});
        return data.length == 0 ? null : data[0];
    }
}

