/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.domain.capacity.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageRangeTypeEnum;
import kd.hr.hrti.bussiness.domain.capacity.enums.CapacityStorageTypeEnum;

public class CapacityStorageDomainService {
    private static final HRBaseServiceHelper CAP_STORAGE_HELPER = new HRBaseServiceHelper("hrti_capacitystorage");

    public DynamicObject[] getGeneralCapStorage(Long countryId, Long orgId, QFilter baseDataFilter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{CapacityStorageTypeEnum.GENERAL.getNumber(), CapacityStorageTypeEnum.MANAGEAL.getNumber()})));
        if (countryId != null) {
            qFilters.add(new QFilter("country.fbasedataid", "=", (Object)countryId));
        } else {
            qFilters.add(new QFilter("country.fbasedataid", "is null", null));
        }
        if (orgId != null) {
            qFilters.add(new QFilter("capacityorg.fbasedataid", "=", (Object)orgId));
        } else {
            qFilters.add(new QFilter("capacityorg.fbasedataid", "is null", null));
        }
        if (baseDataFilter != null) {
            qFilters.add(baseDataFilter);
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        return BusinessDataServiceHelper.load((String)"hrti_capacitystorage", (String)"name,type,number,description,entryentity.capitem,entryentity.capitem.number,entryentity.capitem.type,country,capacityorg,isadministrator", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public DynamicObject[] getGeneralCapacityStorage(QFilter baseDataFilter) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{CapacityStorageTypeEnum.GENERAL.getNumber(), CapacityStorageTypeEnum.MANAGEAL.getNumber()})));
        if (baseDataFilter != null) {
            qFilters.add(baseDataFilter);
        }
        qFilters.add(new QFilter("country.fbasedataid", "is null", null));
        qFilters.add(new QFilter("capacityorg.fbasedataid", "is null", null));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        return BusinessDataServiceHelper.load((String)"hrti_capacitystorage", (String)"name,type,number,description,entryentity.capitem,entryentity.capitem.number,entryentity.capitem.type", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public DynamicObject[] getProfessionalCapacityStorageByPost(Long postId, QFilter baseDataFilter) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        if (baseDataFilter != null) {
            filter.add(baseDataFilter);
        }
        filter.add(new QFilter("type", "=", (Object)CapacityStorageTypeEnum.PROFESSIONAL.getNumber()));
        filter.add(new QFilter("rangetype", "=", (Object)CapacityStorageRangeTypeEnum.POST.getNumber()));
        filter.add(new QFilter("status", "=", (Object)"C"));
        filter.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        filter.add(new QFilter("post.fbasedataid", "in", (Object)postId));
        return BusinessDataServiceHelper.load((String)"hrti_capacitystorage", (String)"id,number,jobscm.fbasedataid,capstorjobseq.fbasedataid,capstorjobfamily.fbasedataid,capstorjobclass.fbasedataid ,entryentity.capitem ,entryentity.capitem.number,entryentity.capitem.type,post.fbasedataid,capjob.fbasedataid", (QFilter[])filter.toArray(new QFilter[0]));
    }

    public DynamicObject[] getProfessionalCapacityStorage(Long jobScmId, Long jobSeqId, String number, QFilter baseDataFilter) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        if (baseDataFilter != null) {
            filter.add(baseDataFilter);
        }
        filter.add(new QFilter("jobscm", "=", (Object)jobScmId));
        filter.add(new QFilter("type", "=", (Object)CapacityStorageTypeEnum.PROFESSIONAL.getNumber()));
        filter.add(new QFilter("rangetype", "=", (Object)number));
        filter.add(new QFilter("status", "=", (Object)"C"));
        filter.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        filter.add(new QFilter("capstorjobseq.fbasedataid", "=", (Object)jobSeqId));
        return BusinessDataServiceHelper.load((String)"hrti_capacitystorage", (String)"id,name,number,type,description,jobscm.fbasedataid,capstorjobseq.fbasedataid,capstorjobfamily.fbasedataid,capstorjobclass.fbasedataid,entryentity.capitem ,entryentity.capitem.number,entryentity.capitem.type,post.fbasedataid,capjob.fbasedataid", (QFilter[])filter.toArray(new QFilter[0]));
    }

    public boolean checkCountryIdInDB(Long countryId) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("id", "=", (Object)countryId));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_country", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
        return ids.length >= 1;
    }

    public boolean checkOrgIdInDB(Long orgId) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("id", "=", (Object)orgId));
        Object[] ids = BusinessDataServiceHelper.load((String)"haos_adminorghr", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
        return HRArrayUtils.isNotEmpty((Object[])ids) && ids.length >= 1;
    }

    public boolean checkBosOrgInDB(Long orgId) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("id", "=", (Object)orgId));
        Object[] ids = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
        return HRArrayUtils.isNotEmpty((Object[])ids) && ids.length >= 1;
    }

    public DynamicObject[] queryJobDataById(Long jobId) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("id", "=", (Object)jobId));
        filter.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        return BusinessDataServiceHelper.load((String)"hbjm_jobhr", (String)"id,jobscm,jobseq,jobfamily,jobclass", (QFilter[])filter.toArray(new QFilter[0]));
    }
}

