/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.bussiness.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrti.bussiness.application.ServiceFactory;
import kd.hr.hrti.bussiness.application.external.BizApplicationService;

public class PortraitBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(PortraitBaseServiceHelper.class);
    private static final BizApplicationService BIZ_SERVICE = ServiceFactory.getService(BizApplicationService.class);
    private static final List<Long> DEFAULT_IDS = Lists.newArrayList((Object[])new Long[]{1585418459888582656L, 1693428666379298816L});

    public static HRMServiceResult showTalentPortrait(Map<String, Object> paramMap) {
        LOG.info("paramMap:{}", paramMap);
        if (CollectionUtils.isEmpty(paramMap)) {
            return HRMServiceResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PortraitServiceHelper_0", (String)"hrmp-hrti-business", (Object[])new Object[0]));
        }
        Long employeeId = (Long)paramMap.get("employee");
        Long personId = (Long)paramMap.get("person");
        HRMServiceResult returnResult = BIZ_SERVICE.matchSchemeId(paramMap);
        if (!returnResult.isSuccess()) {
            return HRMServiceResult.fail((String)returnResult.getMessage());
        }
        HRMServiceResult hrmServiceResult = PortraitBaseServiceHelper.certValidate(personId);
        if (null != hrmServiceResult) {
            return hrmServiceResult;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setFormId("hrti_workbench");
        showParameter.setCustomParam("strSchemeId", returnResult.getReturnData());
        showParameter.setCustomParam("employee", (Object)employeeId);
        showParameter.setCustomParam("person", (Object)personId);
        showParameter.setCustomParam("status", (Object)OperationStatus.VIEW);
        return HRMServiceResult.success((Object)showParameter);
    }

    public static HRMServiceResult configTalentPortrait(Map<String, Object> paramMap) {
        LOG.info("paramMap:{}", paramMap);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setFormId("hrti_workbench");
        showParameter.setCustomParams(paramMap);
        HRMServiceResult serviceResult = HRMServiceResult.success();
        serviceResult.setReturnData((Object)showParameter);
        return serviceResult;
    }

    public static void deleteViewBeforeClose(String viewNumber) {
        LOG.info("deleteViewBeforeClose###viewNumber:{}", (Object)viewNumber);
        HRBaseServiceHelper portraitHelper = new HRBaseServiceHelper("portal_scheme");
        QFilter formNumberQFilter = new QFilter("formnum", "=", (Object)"hrti_workbench");
        QFilter viewNumberQFilter = new QFilter("number", "=", (Object)viewNumber);
        QFilter idQFilter = new QFilter("id", "not in", DEFAULT_IDS);
        DynamicObject[] portraits = portraitHelper.queryOriginalArray("id", new QFilter[]{formNumberQFilter, viewNumberQFilter, idQFilter});
        Object[] ids = Arrays.stream(portraits).map(value -> value.getLong("id")).toArray();
        List deleteIds = Arrays.stream(ids).map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList());
        HRBaseServiceHelper cardHelper = new HRBaseServiceHelper("bos_mainpagecardconfig");
        cardHelper.deleteByFilter(new QFilter[]{new QFilter("mainpagelayout", "in", deleteIds)});
        portraitHelper.delete(deleteIds.toArray());
    }

    public static void deleteViewSaveOne(String viewNumber, String strSchemeId) {
        List<Long> deleteSchemeIds;
        QFilter viewNumberQFilter;
        QFilter formNumberQFilter;
        HRBaseServiceHelper portraitHelper;
        DynamicObject[] portraits;
        Object[] ids;
        LOG.info("deleteViewSaveOne###strSchemeId:{}", (Object)strSchemeId);
        if (DEFAULT_IDS.stream().noneMatch(item -> item.toString().equals(strSchemeId)) && HRArrayUtils.isNotEmpty((Object[])(ids = Arrays.stream(portraits = (portraitHelper = new HRBaseServiceHelper("portal_scheme")).queryOriginalArray("id,number", new QFilter[]{formNumberQFilter = new QFilter("formnum", "=", (Object)"hrti_workbench"), viewNumberQFilter = new QFilter("number", "=", (Object)viewNumber)})).filter(value -> !HRStringUtils.equals((String)String.valueOf(value.get("id")), (String)strSchemeId)).map(value -> value.get("id")).toArray())) && !CollectionUtils.isEmpty(deleteSchemeIds = BIZ_SERVICE.getDeleteSchemeIds(ids))) {
            HRBaseServiceHelper cardHelper = new HRBaseServiceHelper("bos_mainpagecardconfig");
            cardHelper.deleteByFilter(new QFilter[]{new QFilter("mainpagelayout", "in", deleteSchemeIds)});
            portraitHelper.delete(deleteSchemeIds.toArray());
        }
    }

    public static void deleteViewByIds(List<String> strSchemeIds) {
        LOG.info("deleteViewByIds###strSchemeIds:{}", strSchemeIds);
        if (!CollectionUtils.isEmpty(strSchemeIds)) {
            DEFAULT_IDS.forEach(item -> strSchemeIds.remove(item.toString()));
            HRBaseServiceHelper portraitHelper = new HRBaseServiceHelper("portal_scheme");
            List<Long> deleteSchemeIds = BIZ_SERVICE.getDeleteSchemeIds(strSchemeIds.toArray());
            if (!CollectionUtils.isEmpty(deleteSchemeIds)) {
                HRBaseServiceHelper cardHelper = new HRBaseServiceHelper("bos_mainpagecardconfig");
                cardHelper.deleteByFilter(new QFilter[]{new QFilter("mainpagelayout", "in", deleteSchemeIds)});
                portraitHelper.delete(deleteSchemeIds.toArray());
            }
        }
    }

    public static HRMServiceResult showInCompanyExpCard(Map<String, Object> paramMap) {
        return PortraitBaseServiceHelper.buildResult(paramMap, "hrti_incompanyexp_card");
    }

    public static HRMServiceResult showQualificationCard(Map<String, Object> paramMap) {
        return PortraitBaseServiceHelper.buildResult(paramMap, "hrti_qualification_card");
    }

    private static HRMServiceResult buildResult(Map<String, Object> paramMap, String formId) {
        LOG.info("PortraitBaseServiceHelper###buildResult###formId###paramMap:{},{}", (Object)formId, paramMap);
        if (CollectionUtils.isEmpty(paramMap)) {
            return HRMServiceResult.fail((String)"paramMap-is-not-empty");
        }
        if (Objects.isNull(paramMap.get("employee"))) {
            return HRMServiceResult.fail((String)"employee-is-not-null");
        }
        if (Objects.isNull(paramMap.get("targetKey"))) {
            return HRMServiceResult.fail((String)"showType-is-InContainer,targetKey-is-not-null");
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey((String)paramMap.get("targetKey"));
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setFormId(formId);
        fsp.setCustomParams(paramMap);
        return HRMServiceResult.success((Object)fsp);
    }

    private static HRMServiceResult certValidate(Long personId) {
        Map certResultMap = (Map)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"ITDCSLicenseService", (String)"verifyCertByPersonId", (Object[])new Object[]{"2IXTB4SBW0QV", "hrti_workbench", Lists.newArrayList((Object[])new Long[]{personId})});
        Object state = certResultMap.get("STATE");
        LOG.info(String.format("certValidate %d result %s", personId, SerializationUtils.toJsonString((Object)certResultMap)));
        if ("FAIL".equals(state)) {
            return HRMServiceResult.fail((String)(certResultMap.get("MSG") == null ? "" : certResultMap.get("MSG").toString()));
        }
        if ("FORBID".equals(state)) {
            ArrayList failPersonIdList = Lists.newArrayList();
            if (null != certResultMap.get("NEXISTID")) {
                List nExistPersonIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("NEXISTID")), ArrayList.class);
                failPersonIdList.addAll(nExistPersonIdList);
            }
            if (null != certResultMap.get("EXCEPTID")) {
                List exceptPersonIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("EXCEPTID")), ArrayList.class);
                failPersonIdList.addAll(exceptPersonIdList);
            }
            if (failPersonIdList.size() > 0) {
                return HRMServiceResult.fail((String)(certResultMap.get("MSG") == null ? "" : certResultMap.get("MSG").toString()));
            }
        }
        return null;
    }
}

