/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.common.api;

import java.io.Serializable;
import kd.hr.hrti.common.api.ResultCode;

public class CommonResult<T>
implements Serializable {
    private static final long serialVersionUID = -5638398104816936560L;
    private long code;
    private String message;
    private T data;

    protected CommonResult() {
    }

    public long getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    protected CommonResult(long code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> CommonResult<T> success(T data) {
        return new CommonResult<T>(ResultCode.SUCCESS.getCode(), ResultCode.getName(ResultCode.SUCCESS.getCode()), data);
    }

    public static <T> CommonResult<T> success(T data, String message) {
        return new CommonResult<T>(ResultCode.SUCCESS.getCode(), message, data);
    }

    public static <T> CommonResult<T> failed(ResultCode errorCode, String message) {
        return new CommonResult<Object>(errorCode.getCode(), message, null);
    }
}

