/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrti.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.util.CollectionUtils;

public class CommUtils {
    public static String appendStr(String ... strs) {
        StringBuilder buffer = new StringBuilder();
        for (String str : strs) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static void setPropertyNotDataChanged(IDataModel model, String ... propertyNames) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        Arrays.stream(propertyNames).forEach(propertyName -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(propertyName);
            if (property != null) {
                CommUtils.removePropertyChanged(dataEntity, propertyName);
            } else {
                List propertyList = dataEntity.getDataEntityType().getProperties().getCollectionProperties(false);
                if (CollectionUtils.isEmpty((Collection)propertyList)) {
                    return;
                }
                List<ICollectionProperty> entryPropertyList = propertyList.stream().filter(collectionProperty -> collectionProperty instanceof EntryProp).collect(Collectors.toList());
                entryPropertyList.forEach(entryProperty -> {
                    DynamicObjectCollection collection = (DynamicObjectCollection)entryProperty.getValueFast((Object)dataEntity);
                    if (CollectionUtils.isEmpty((Collection)collection)) {
                        return;
                    }
                    collection.forEach(rowDataEntity -> CommUtils.removePropertyChanged(rowDataEntity, propertyName));
                });
            }
        });
    }

    private static void removePropertyChanged(DynamicObject dataEntity, String propertyName) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propertyName);
        if (property != null) {
            if (property instanceof BasedataProp) {
                property = (IDataEntityProperty)properties.get((Object)(propertyName + "_id"));
            } else if (property instanceof MulBasedataProp || property instanceof EntryProp) {
                if (property instanceof AttachmentProp) {
                    dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
                }
                DynamicObjectCollection entryEntities = (DynamicObjectCollection)property.getValueFast((Object)dataEntity);
                entryEntities.forEach(entry -> {
                    entry.getDataEntityState().setBizChanged(false);
                    entry.getDataEntityState().setRemovedItems(Boolean.FALSE);
                });
                if (property instanceof MulBasedataProp) {
                    dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
                }
                return;
            }
            dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
        }
    }

    public static Comparator<Date> dateComparator() {
        return (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o2.compareTo((Date)o1);
        };
    }
}

