/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.formplugin.web.basedata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.lcs.business.cost.service.CostStruService;

public class CostStruSecondEntryPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(CostStruSecondEntryPlugin.class);
    private static final String KEY_COST_BIZ_OBJ_ENTRY = "costbizobjentry";
    private static final String CANCEL_SELECTED_CONFIRM_CALL_BACK = "cancelselected_confirmcallback";
    private static final String COST_STRU_DEF_VALUE_BACK = "coststrudefvalueback";
    private static final String DO_NOTHING_REFRESH = "donothing_refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"adaptationruleent"});
        this.addClickListeners(new String[]{"defaultvalruleent"});
        EntryGrid costBizObjEntry = (EntryGrid)this.getControl(KEY_COST_BIZ_OBJ_ENTRY);
        costBizObjEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        CostStruService costStruService = new CostStruService();
        IFormView grandParentView = costStruService.getGrandParentView(this.getView());
        if (grandParentView == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = grandParentView.getModel().getEntryEntity("dimensionentry");
        if (dimensionEntry == null || dimensionEntry.isEmpty()) {
            return;
        }
        TableValueSetter vs = this.tableValueSetterAddField();
        ArrayList<String> dimensionIds = new ArrayList<String>(10);
        for (DynamicObject dimensionObj : dimensionEntry) {
            dimensionIds.add(dimensionObj.getString("id"));
        }
        JSONObject dimensionRefBizObjCacheInfo = this.getCacheData();
        if (dimensionRefBizObjCacheInfo.isEmpty()) {
            costStruService.initNewDataToCache(dimensionRefBizObjCacheInfo, grandParentView, dimensionIds);
        }
        Long currentSelectCostBizObjId = this.getSelectCostBizObjId(grandParentView);
        this.fillCostBizObjEntryData(dimensionEntry, vs, dimensionRefBizObjCacheInfo, currentSelectCostBizObjId);
        this.initNewEntryRow(vs);
        IHRAppCache appCache = HRAppCache.get((String)this.getView().getParentView().getParentView().getPageId());
        appCache.put("costbizpageid", (Object)this.getView().getPageId());
        this.setCostBizObjEntryEnable(grandParentView);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (propName) {
            case "isselected": {
                this.clickIsSelectOperation(rowIndex, newValue);
            }
            case "defaultvalruleent": 
            case "defaultvalruleentval": 
            case "adaptationruleent": 
            case "adaptationruleentval": {
                this.saveCostBizObjEntryValToCache(propName, newValue);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (DO_NOTHING_REFRESH.equals(operateKey)) {
            CostStruService costStruService = new CostStruService();
            IFormView grandParentView = costStruService.getGrandParentView(this.getView());
            if (grandParentView == null) {
                return;
            }
            this.setCostBizObjEntryEnable(grandParentView);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CANCEL_SELECTED_CONFIRM_CALL_BACK.equals(callBackId)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_COST_BIZ_OBJ_ENTRY);
            if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().setValue("isselected", (Object)Boolean.TRUE, currentRowIndex);
            } else {
                this.getModel().setValue("adaptationruleent", null, currentRowIndex);
                this.getModel().setValue("adaptationruleentval", null, currentRowIndex);
                this.getModel().setValue("defaultvalruleent", null, currentRowIndex);
                this.getModel().setValue("defaultvalruleentval", null, currentRowIndex);
                this.getModel().setValue("isselected", (Object)Boolean.FALSE, currentRowIndex);
                this.saveCostBizObjEntryValToCache("isselected", "false");
            }
        }
    }

    private void initNewEntryRow(TableValueSetter vs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(KEY_COST_BIZ_OBJ_ENTRY, vs);
        model.endInit();
    }

    private TableValueSetter tableValueSetterAddField() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("costdimension", new Object[0]);
        vs.addField("isselected", new Object[0]);
        vs.addField("adaptationruleent", new Object[0]);
        vs.addField("defaultvalruleent", new Object[0]);
        vs.addField("adaptationruleentval", new Object[0]);
        vs.addField("defaultvalruleentval", new Object[0]);
        return vs;
    }

    private String getCurrentSelectedDimensionId() {
        IFormView grandParentView = this.getView().getParentView().getParentView();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_COST_BIZ_OBJ_ENTRY);
        int[] entryGridSelectRows = entryGrid.getSelectRows();
        DynamicObjectCollection dimensionEntryList = grandParentView.getModel().getEntryEntity("dimensionentry");
        if (entryGridSelectRows.length == 0) {
            return "";
        }
        return ((DynamicObject)dimensionEntryList.get(entryGridSelectRows[0])).getString("costdimension.id");
    }

    private Long getSelectCostBizObjId(IFormView grandParentView) {
        HRPageCache grandParentPageCache = new HRPageCache(grandParentView);
        String tabSelectedIndex = (String)grandParentPageCache.get("tabselectedindex", String.class);
        if (tabSelectedIndex == null || tabSelectedIndex.isEmpty()) {
            tabSelectedIndex = "1";
        }
        Map indexCostBizObjIdMap = (Map)grandParentPageCache.get("indexcostbizobjidmap", Map.class);
        return Long.valueOf((String)indexCostBizObjIdMap.get(tabSelectedIndex));
    }

    private void fillCostBizObjEntryData(DynamicObjectCollection dimensionEntry, TableValueSetter vs, JSONObject dimensionRefBizObjCacheInfo, Long currentSelectCostBizObjId) {
        int row = 0;
        for (DynamicObject dimensionDy : dimensionEntry) {
            long costDimensionId;
            ArrayList costBizObjInfoList;
            String isSelected = "";
            String adaptationRuleEnt = "";
            String defaultValRuleEnt = "";
            String adaptationRuleEntVal = "";
            String defaultValRuleEntVal = "";
            if (dimensionRefBizObjCacheInfo == null || (costBizObjInfoList = (ArrayList)dimensionRefBizObjCacheInfo.get((Object)String.valueOf(costDimensionId = dimensionDy.getLong("costdimension.id")))) == null || costBizObjInfoList.isEmpty()) break;
            for (Object costBizObj : costBizObjInfoList) {
                LinkedHashMap costBizObjMap;
                Object costBizIdObj;
                if (!(costBizObj instanceof LinkedHashMap) || (costBizIdObj = (costBizObjMap = (LinkedHashMap)costBizObj).get("costbizid")) == null || !String.valueOf(costBizIdObj).equals(String.valueOf(currentSelectCostBizObjId))) continue;
                isSelected = costBizObjMap.get("isselected");
                this.setEnbleByIsSelect(isSelected, row);
                adaptationRuleEnt = (String)costBizObjMap.get("adaptationruleent");
                adaptationRuleEntVal = (String)costBizObjMap.get("adaptationruleentval");
                defaultValRuleEntVal = (String)costBizObjMap.get("defaultvalruleentval");
                defaultValRuleEnt = HRStringUtils.isEmpty((String)defaultValRuleEntVal) ? "" : "...";
                break;
            }
            vs.addRow(new Object[]{costDimensionId, isSelected, adaptationRuleEnt, defaultValRuleEnt, adaptationRuleEntVal, defaultValRuleEntVal});
            ++row;
        }
    }

    private void setEnbleByIsSelect(Object isSelected, int row) {
        Boolean isSelect = (Boolean)isSelected;
        this.getView().setEnable(isSelect, row, new String[]{"adaptationruleent", "defaultvalruleent"});
    }

    private void setCostBizObjEntryEnable(IFormView grandParentView) {
        String status = grandParentView.getModel().getDataEntity().getString("status");
        int curPage = grandParentView.getModel().getDataEntity().getInt("curpage");
        if ("C".equals(status) || "B".equals(status) || curPage == 3) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_COST_BIZ_OBJ_ENTRY});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_COST_BIZ_OBJ_ENTRY});
        }
    }

    private void saveCostBizObjEntryValToCache(String propName, Object newValue) {
        JSONObject dimensionRefBizObjCacheJSONObject = this.getCacheData();
        this.updateAllValue(propName, newValue, dimensionRefBizObjCacheJSONObject);
    }

    private void updateAllValue(String propName, Object newValue, JSONObject dimensionRefBizObjCacheJSONObject) {
        String currentSelectedDimensionId = this.getCurrentSelectedDimensionId();
        Object bizObjObj = dimensionRefBizObjCacheJSONObject.get((Object)currentSelectedDimensionId);
        if (bizObjObj == null) {
            return;
        }
        CostStruService costStruService = new CostStruService();
        IFormView grandParentView = costStruService.getGrandParentView(this.getView());
        if (grandParentView == null) {
            return;
        }
        Long currentSelectCostBizObjId = this.getSelectCostBizObjId(grandParentView);
        List bizObjObjList = (List)bizObjObj;
        this.updateJsonValue(propName, newValue, currentSelectCostBizObjId, bizObjObjList);
        this.cleanEmptyEntryValue(propName, newValue);
        IHRAppCache appCache = HRAppCache.get((String)this.getView().getParentView().getParentView().getPageId());
        dimensionRefBizObjCacheJSONObject.put(currentSelectedDimensionId, (Object)bizObjObjList);
        appCache.put("dimensionCache", (Object)dimensionRefBizObjCacheJSONObject);
    }

    private void updateJsonValue(String propName, Object newValue, Long currentSelectCostBizObjId, List<Map<String, Object>> bizObjObjList) {
        for (Map<String, Object> map : bizObjObjList) {
            Object costBizIdObj = map.get("costbizid");
            long costBizObjId = Long.parseLong(String.valueOf(costBizIdObj));
            if (costBizObjId != currentSelectCostBizObjId || "adaptationruleent".equals(propName) || "adaptationruleentval".equals(propName) || "defaultvalruleent".equals(propName) || "defaultvalruleentval".equals(propName) || !"isselected".equals(propName)) continue;
            String booleanStr = String.valueOf(newValue);
            Boolean isSelect = Boolean.valueOf(booleanStr);
            map.put("isselected", isSelect);
        }
    }

    private void cleanEmptyEntryValue(String propName, Object newValue) {
        String value = String.valueOf(newValue);
        if (value == null || value.isEmpty()) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_COST_BIZ_OBJ_ENTRY);
            if ("adaptationruleent".equals(propName) || "adaptationruleentval".equals(propName)) {
                this.getModel().setValue("adaptationruleent", (Object)"", currentRowIndex);
                this.getModel().setValue("adaptationruleentval", (Object)"", currentRowIndex);
            } else if ("defaultvalruleent".equals(propName) || "defaultvalruleentval".equals(propName)) {
                this.getModel().setValue("defaultvalruleent", (Object)"", currentRowIndex);
                this.getModel().setValue("defaultvalruleentval", (Object)"", currentRowIndex);
            }
        }
    }

    private String getCostBizObjNumberById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costbizobj");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject costBizObjDy = serviceHelper.queryOne("id,entityobject", new QFilter[]{idFilter});
        String number = "";
        if (costBizObjDy != null) {
            number = costBizObjDy.getString("entityobject.number");
        }
        return number;
    }

    private JSONObject getCacheData() {
        CostStruService costStruService = new CostStruService();
        IFormView grandParentView = costStruService.getGrandParentView(this.getView());
        if (grandParentView == null) {
            return new JSONObject();
        }
        IHRAppCache appCache = HRAppCache.get((String)grandParentView.getPageId());
        JSONObject dimensionRefBizObjCacheJSONObject = (JSONObject)appCache.get("dimensionCache", JSONObject.class);
        if (dimensionRefBizObjCacheJSONObject == null) {
            dimensionRefBizObjCacheJSONObject = new JSONObject();
        }
        return dimensionRefBizObjCacheJSONObject;
    }

    private void clickIsSelectOperation(int rowIndex, Object isSelectedObj) {
        Boolean isSelected = (Boolean)isSelectedObj;
        if (!isSelected.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"adaptationruleent", "defaultvalruleent"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"adaptationruleent", "defaultvalruleent"});
        }
    }
}

