/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.formplugin.web.basedata;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.lcs.business.basedata.CostBasaDataHelper;
import kd.hrmp.lcs.business.cost.service.CostStruService;

public class CostStruSecondObjectPagePlugin
extends HRDataBaseEdit
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String FLEX_PANEL_AP = "flexpanelap";
    private static final String CREATE_FLEX_PANEL_AP = "createflexpanel";
    private static final String TAB_PAGE_AP = "tabpageap";
    private static final char CONCAT_UNDERLINE = '_';

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FlexPanelAp panelAp = this.createAbstractFlexPlanAp();
        HashMap<String, String> mapHead = new HashMap<String, String>(16);
        mapHead.put("id", FLEX_PANEL_AP);
        mapHead.put("items", (String)panelAp.createControl().get("items"));
        this.getView().updateControlMetadata(FLEX_PANEL_AP, mapHead);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String index = this.getSelectTabIndex();
        this.loadCostStruEntryFlex(index);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        int length = tabKey.length();
        String index = tabKey.substring(tabKey.indexOf(95) + 1, length);
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        parentPageCache.put("tabselectedindex", (Object)index);
        this.getView().updateView();
    }

    public TabAp createDynamicTabAp(TabAp tabAp, String name, int index, String tabSelectedIndex) {
        TabPageAp tabPageAp = this.createTabPageAp(name, index);
        this.firstOrCreateCurentTabSelectIndex(index, tabSelectedIndex, tabPageAp);
        tabAp.getItems().add(tabPageAp);
        return tabAp;
    }

    private void firstOrCreateCurentTabSelectIndex(int index, String tabSelectedIndex, TabPageAp tabPageAp) {
        if (this.isSetTabSelectIndex(index, tabSelectedIndex)) {
            FlexPanelAp statusPanelAp = new FlexPanelAp();
            statusPanelAp.setKey("createflexpanel_" + index);
            statusPanelAp.setAlignItems("stretch");
            tabPageAp.getItems().add(statusPanelAp);
        }
    }

    private boolean isSetTabSelectIndex(int index, String tabSelectedIndex) {
        return tabSelectedIndex == null && index == 1 || tabSelectedIndex != null && tabSelectedIndex.equals(String.valueOf(index));
    }

    private TabPageAp createTabPageAp(String name, int index) {
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey("tabpageap_" + index);
        tabPageAp.setName(new LocaleString(name));
        tabPageAp.setBackColor("#ffffff");
        tabPageAp.setFontSize(14);
        return tabPageAp;
    }

    private FlexPanelAp createAbstractFlexPlanAp() {
        FlexPanelAp statusPanelAp = new FlexPanelAp();
        statusPanelAp.setKey("flexstatus");
        TabAp tabAp = new TabAp();
        tabAp.setKey(TABAP);
        tabAp.setTabStyle(1);
        IFormView parentView = this.getView().getParentView();
        CostStruService costStruService = new CostStruService();
        Map selectDimensionIndexMap = costStruService.getSelectDimensionIndexMap(parentView);
        HRPageCache parentPageCache = new HRPageCache(parentView);
        String tabSelectedIndex = (String)parentPageCache.get("tabselectedindex", String.class);
        DynamicObject[] costBizObjs = CostBasaDataHelper.getCostBizObjects();
        Map<String, String> indexCostBizObjIdMap = this.createTableAp(tabAp, selectDimensionIndexMap, tabSelectedIndex, costBizObjs);
        parentPageCache.put("indexcostbizobjidmap", indexCostBizObjIdMap);
        tabAp.setTabDirection("vertical");
        statusPanelAp.getItems().add(tabAp);
        return statusPanelAp;
    }

    private Map<String, String> createTableAp(TabAp tabAp, Map<String, List<String>> selectDimensionIndexMap, String tabSelectedIndex, DynamicObject[] costBizObjs) {
        HashMap<String, String> indexCostBizObjIdMap = new HashMap<String, String>(16);
        if (selectDimensionIndexMap == null || selectDimensionIndexMap.isEmpty()) {
            this.createDynamicTabAp(tabAp, tabSelectedIndex, costBizObjs, indexCostBizObjIdMap);
        } else {
            this.createDynamicTabApBySelectNumber(tabAp, selectDimensionIndexMap, tabSelectedIndex, costBizObjs, indexCostBizObjIdMap);
        }
        return indexCostBizObjIdMap;
    }

    private void createDynamicTabAp(TabAp tabAp, String tabSelectedIndex, DynamicObject[] costBizObjs, Map<String, String> indexCostBizObjIdMap) {
        for (int i = 0; i < costBizObjs.length; ++i) {
            String name = costBizObjs[i].getString("name");
            long id = costBizObjs[i].getLong("id");
            this.createDynamicTabAp(tabAp, name, i + 1, tabSelectedIndex);
            indexCostBizObjIdMap.put(String.valueOf(i + 1), String.valueOf(id));
        }
    }

    private void createDynamicTabApBySelectNumber(TabAp tabAp, Map<String, List<String>> selectDimensionIndexMap, String tabSelectedIndex, DynamicObject[] costBizObjs, Map<String, String> indexCostBizObjIdMap) {
        for (int i = 0; i < costBizObjs.length; ++i) {
            long costBizObjId = costBizObjs[i].getLong("id");
            List<String> dynamicObjects = selectDimensionIndexMap.get(String.valueOf(costBizObjId));
            String name = !CollectionUtils.isEmpty(dynamicObjects) ? costBizObjs[i].getString("name") + '(' + dynamicObjects.size() + ')' : costBizObjs[i].getString("name");
            indexCostBizObjIdMap.put(String.valueOf(i + 1), String.valueOf(costBizObjId));
            this.createDynamicTabAp(tabAp, name, i + 1, tabSelectedIndex);
        }
    }

    private String getSelectTabIndex() {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        String currentTab = tab.getCurrentTab();
        if (TAB_PAGE_AP.equals(currentTab)) {
            currentTab = "tabpageap_1";
        }
        int length = currentTab.length();
        String index = currentTab.substring(currentTab.indexOf(95) + 1, length);
        this.initTableSelectIndex(tab);
        return index;
    }

    private void initTableSelectIndex(Tab tab) {
        HRPageCache parentPageCache = new HRPageCache(this.getView().getParentView());
        String tabSelectedIndex = (String)parentPageCache.get("tabselectedindex", String.class);
        if (tabSelectedIndex != null && !tabSelectedIndex.isEmpty()) {
            tab.activeTab("tabpageap_" + tabSelectedIndex);
        }
    }

    private void loadCostStruEntryFlex(String index) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("createflexpanel_" + index);
        formShowParameter.setFormId("lcs_coststrusecondpageent");
        this.getView().showForm(formShowParameter);
        this.getView().getModel().setDataChanged(false);
    }
}

