/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.business.basedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class CostBasaDataHelper {
    private static final Log LOGGER = LogFactory.getLog(CostBasaDataHelper.class);

    public static DynamicObject[] getDimensionObjArrByPkIdList(Object[] primaryKeyValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costdimension");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValue);
        String selectProp = "id,name";
        DynamicObject[] dimensionObjArr = serviceHelper.query(selectProp, new QFilter[]{idFilter, enableFilter, auditFilter});
        return dimensionObjArr;
    }

    public static Map<Long, DynamicObject> getDimensionObjMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costdimension");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        String selectProp = "id,name";
        DynamicObject[] dimensionObjArr = serviceHelper.query(selectProp, new QFilter[]{enableFilter, auditFilter});
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(dimensionObjArr.length);
        for (int i = 0; i < dimensionObjArr.length; ++i) {
            DynamicObject dynamicObject = dimensionObjArr[i];
            long id = dynamicObject.getLong("id");
            resultMap.put(id, dynamicObject);
        }
        return resultMap;
    }

    public static Map<String, String> queryCostStruFidRefName(List<Long> fids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_coststru");
        QFilter idFilter = new QFilter("id", "in", fids);
        DynamicObject[] costStruObjArr = serviceHelper.queryOriginalArray("id,name", new QFilter[]{idFilter});
        HashMap<String, String> costStruFidRefNameMap = new HashMap<String, String>(costStruObjArr.length);
        for (DynamicObject costStruObj : costStruObjArr) {
            costStruFidRefNameMap.put(costStruObj.getString("id"), costStruObj.getString("name"));
        }
        return costStruFidRefNameMap;
    }

    public static DynamicObject[] getCostBizObjList() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costbizobj");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        String selectProp = "id";
        DynamicObject[] dimensionObjArr = serviceHelper.queryOriginalArray(selectProp, new QFilter[]{enableFilter, auditFilter});
        return dimensionObjArr;
    }

    public static DynamicObject[] querySegementArr(List<Long> segementIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_segement");
        QFilter idFilter = new QFilter("id", "not in", segementIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        String selectProp = "id";
        DynamicObject[] segementObjArr = serviceHelper.queryOriginalArray(selectProp, new QFilter[]{idFilter, enableFilter, auditFilter}, "index");
        return segementObjArr;
    }

    public static DynamicObject[] querySegement() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_segement");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] segementObjArr = serviceHelper.query(new QFilter[]{enableFilter, auditFilter}, "index");
        return segementObjArr;
    }

    public static boolean isExistCostSetUp(Long costStruId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("pcs_costsetuprst");
        QFilter filter = new QFilter("costadapter.coststru", "=", (Object)costStruId);
        return serviceHelper.isExists(filter);
    }

    public static boolean isExistCostCfg(Long costStruId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("pcs_costcfg");
        QFilter filter = new QFilter("costadapter.coststru", "=", (Object)costStruId);
        return serviceHelper.isExists(filter);
    }

    public static List<Long> getDbSelectedItemsIds(Long bizType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costitem");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter bizTypeFilter = new QFilter("costbiztype", "=", (Object)bizType);
        DynamicObject[] costItemObjArr = serviceHelper.query("salaryitementry.salaryitem", new QFilter[]{auditFilter, enableFilter, bizTypeFilter});
        ArrayList<Long> itemIds = new ArrayList<Long>(10);
        for (DynamicObject costItemObj : costItemObjArr) {
            DynamicObjectCollection itemObjColl = costItemObj.getDynamicObjectCollection("salaryitementry");
            itemObjColl.forEach(itemObj -> itemIds.add(itemObj.getLong("salaryitem.id")));
        }
        return itemIds;
    }

    public static Map<String, List<Long>> getRefencedCostStruIds(List<Object> dimensionIds) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FID AS ID,FCOSTDIMENSIONID AS DIMENSIONID FROM T_LCS_COSTSTRUENTRY ");
        sb.append(" WHERE FCOSTDIMENSIONID IN (");
        Iterator<Object> fidIterator = dimensionIds.iterator();
        while (fidIterator.hasNext()) {
            String fid = String.valueOf(fidIterator.next());
            sb.append(fid);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        try (DataSet dataSet = null;){
            dataSet = DB.queryDataSet((String)"kd.hrmp.lcs.business.basedata.CostBasaDataHelper", (DBRoute)DBRoute.of((String)"hmp"), (String)sb.toString(), (Object[])null);
            HashMap<String, List<Long>> dimesionIdRefStruIdListMap = new HashMap<String, List<Long>>(16);
            for (Row row : dataSet) {
                String dimensionId = row.getString("DIMENSIONID");
                ArrayList<Long> struIdList = (ArrayList<Long>)dimesionIdRefStruIdListMap.get(dimensionId);
                if (struIdList == null) {
                    struIdList = new ArrayList<Long>(10);
                    dimesionIdRefStruIdListMap.put(dimensionId, struIdList);
                }
                struIdList.add(row.getLong("id"));
            }
            HashMap<String, List<Long>> hashMap = dimesionIdRefStruIdListMap;
            return hashMap;
        }
    }

    public static DynamicObject[] getCostBizObjects() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("lcs_costbizobj");
        QFilter filter = new QFilter("issyspreset", "=", (Object)"1");
        return helper.query("id, name, number", new QFilter[]{filter}, "index desc");
    }

    public static Map<String, List<Long>> getRefencedCostAdaptionIds(List<Object> refencedCostStruIdList) {
        DynamicObject[] costAdaptionObjArr;
        HashMap<String, List<Long>> struIdRefAdaptionIdListMap = new HashMap<String, List<Long>>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("coststru.id", "in", refencedCostStruIdList);
        for (DynamicObject dynamicObject : costAdaptionObjArr = serviceHelper.query("id,coststru", new QFilter[]{idFilter})) {
            Long costAdaptionId = dynamicObject.getLong("id");
            String costStruId = dynamicObject.getString("coststru.id");
            ArrayList<Long> adaptionIdList = (ArrayList<Long>)struIdRefAdaptionIdListMap.get(costStruId);
            if (adaptionIdList == null) {
                adaptionIdList = new ArrayList<Long>(10);
            }
            adaptionIdList.add(costAdaptionId);
            struIdRefAdaptionIdListMap.put(costStruId, adaptionIdList);
        }
        return struIdRefAdaptionIdListMap;
    }

    public static Map<String, String> queryCostAdaptionFidRefName(List<Long> fids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("id", "in", fids);
        DynamicObject[] costAdaptionObjArr = serviceHelper.queryOriginalArray("id,name", new QFilter[]{idFilter});
        HashMap<String, String> costAdaptionFidRefNameMap = new HashMap<String, String>(costAdaptionObjArr.length);
        for (DynamicObject costAdaptionObj : costAdaptionObjArr) {
            costAdaptionFidRefNameMap.put(costAdaptionObj.getString("id"), costAdaptionObj.getString("name"));
        }
        return costAdaptionFidRefNameMap;
    }

    public static void updateIsallowedsplit(List<Long> pkIds, Boolean aFalse) {
        DynamicObject[] allotBillObjArr;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("lcs_costbizobj");
        QFilter qFilter = new QFilter("id", "in", pkIds);
        for (DynamicObject obj : allotBillObjArr = serviceHelper.query("isallowedsplit", new QFilter[]{qFilter})) {
            obj.set("isallowedsplit", (Object)aFalse);
        }
        serviceHelper.update(allotBillObjArr);
    }
}

