/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.business.cost.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hrmp.lcs.business.basedata.CostBasaDataHelper;
import org.apache.commons.collections.CollectionUtils;

public class CostStruService {
    public Map<String, List<String>> getSelectDimensionIndexMap(IFormView grandParentView) {
        IHRAppCache appCache = HRAppCache.get((String)grandParentView.getPageId());
        JSONObject dimensionRefBizObjCacheInfo = (JSONObject)appCache.get("dimensionCache", JSONObject.class);
        HashMap<String, List<String>> selectDimensionIndexMap = new HashMap<String, List<String>>(16);
        if (dimensionRefBizObjCacheInfo == null) {
            return selectDimensionIndexMap;
        }
        for (Map.Entry next : dimensionRefBizObjCacheInfo.entrySet()) {
            String dimensionIdStr = (String)next.getKey();
            ArrayList costBizObjInfoList = (ArrayList)dimensionRefBizObjCacheInfo.get((Object)dimensionIdStr);
            if (CollectionUtils.isEmpty((Collection)costBizObjInfoList)) continue;
            for (Object costBizObj : costBizObjInfoList) {
                if (!(costBizObj instanceof LinkedHashMap)) continue;
                LinkedHashMap costBizObjMap = (LinkedHashMap)costBizObj;
                String costBizIdStr = (String)costBizObjMap.get("costbizid");
                ArrayList<String> costBizIdList = (ArrayList<String>)selectDimensionIndexMap.get(costBizIdStr);
                if (costBizIdList == null) {
                    costBizIdList = new ArrayList<String>(10);
                }
                Boolean isSelected = (Boolean)costBizObjMap.get("isselected");
                if (costBizIdStr != null && isSelected.booleanValue()) {
                    costBizIdList.add(dimensionIdStr);
                }
                selectDimensionIndexMap.put(costBizIdStr, costBizIdList);
            }
        }
        return selectDimensionIndexMap;
    }

    public IFormView getGrandParentView(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return null;
        }
        IFormView grandParentView = parentView.getParentView();
        if (grandParentView == null) {
            return null;
        }
        return grandParentView;
    }

    public void initDBDataToCache(JSONObject dimensionRefBizObjCacheJSONObject, IFormView view) {
        DynamicObjectCollection dimensionEntry = view.getModel().getEntryEntity("dimensionentry");
        if (dimensionEntry == null || dimensionEntry.isEmpty()) {
            return;
        }
        List<String> costBizObjIdList = this.getCostBizObjIdList(view);
        if (costBizObjIdList.isEmpty()) {
            return;
        }
        for (DynamicObject dimensionObj : dimensionEntry) {
            String dimensionId = dimensionObj.getString("costdimension.id");
            this.initCostBizObjInfo(dimensionRefBizObjCacheJSONObject, costBizObjIdList, dimensionId);
        }
        this.dbDataToCache(dimensionRefBizObjCacheJSONObject, dimensionEntry, view.getPageId());
    }

    private void initCostBizObjInfo(JSONObject dimensionRefBizObjCacheJSONObject, List<String> costBizObjIdList, String dimensionId) {
        ArrayList costBizObjInfoMapList = new ArrayList(10);
        costBizObjIdList.forEach(costBizObjId -> {
            HashMap<String, Object> costBizObjInfoMap = new HashMap<String, Object>(16);
            costBizObjInfoMap.put("isselected", Boolean.FALSE);
            costBizObjInfoMap.put("costbizid", costBizObjId);
            costBizObjInfoMap.put("adaptationruleent", "");
            costBizObjInfoMap.put("adaptationruleentval", "");
            costBizObjInfoMap.put("defaultvalruleent", "");
            costBizObjInfoMap.put("defaultvalruleentval", "");
            costBizObjInfoMapList.add(costBizObjInfoMap);
        });
        if (StringUtils.isNotEmpty((String)dimensionId)) {
            dimensionRefBizObjCacheJSONObject.put(dimensionId, costBizObjInfoMapList);
        }
    }

    private void dbDataToCache(JSONObject dimensionRefBizObjCacheJSONObject, DynamicObjectCollection dimensionEntry, String pageId) {
        for (DynamicObject dimensionObj : dimensionEntry) {
            String dimensionId = dimensionObj.getString("costdimension.id");
            ArrayList selectedCostBizObjInfoJSONArray = (ArrayList)dimensionRefBizObjCacheJSONObject.get((Object)dimensionId);
            if (selectedCostBizObjInfoJSONArray == null) {
                selectedCostBizObjInfoJSONArray = new ArrayList(10);
            }
            this.initAdaptationRuleInfo(dimensionObj, selectedCostBizObjInfoJSONArray);
            this.initDefaultRuleInfo(dimensionObj, selectedCostBizObjInfoJSONArray);
        }
        IHRAppCache appCache = HRAppCache.get((String)pageId);
        appCache.put("dimensionCache", (Object)dimensionRefBizObjCacheJSONObject);
    }

    private void initAdaptationRuleInfo(DynamicObject dimensionObj, ArrayList selectedCostBizObjInfoJSONArray) {
        DynamicObjectCollection subEntryEntity = dimensionObj.getDynamicObjectCollection("subentryentity");
        Map<String, DynamicObject> packagedSubEntityData = this.getPackageSubEntityData(subEntryEntity, "costbizobj.id");
        for (Object costBizObj : selectedCostBizObjInfoJSONArray) {
            HashMap costBizObjMap;
            String costBizId;
            DynamicObject subCostBizObj;
            if (!(costBizObj instanceof HashMap) || (subCostBizObj = packagedSubEntityData.get(costBizId = (String)(costBizObjMap = (HashMap)costBizObj).get("costbizid"))) == null) continue;
            String adaptationRule = subCostBizObj.getString("adaptationrule");
            String substring = this.getShowAdaptationRule(adaptationRule);
            costBizObjMap.put("adaptationruleent", substring);
            costBizObjMap.put("isselected", Boolean.TRUE);
            costBizObjMap.put("adaptationruleentval", adaptationRule);
        }
    }

    public String getShowAdaptationRule(String adaptationRule) {
        String zhCn;
        if (adaptationRule.isEmpty()) {
            return "";
        }
        JSONObject parseObject = JSONObject.parseObject((String)adaptationRule);
        if (parseObject == null) {
            return "";
        }
        JSONObject description = parseObject.getJSONObject("description");
        if (description == null) {
            return "";
        }
        return zhCn.substring(0, (zhCn = description.getString("zh_CN")).length() > 50 ? 50 : zhCn.length());
    }

    private void initDefaultRuleInfo(DynamicObject dimensionObj, ArrayList selectedCostBizObjInfoJSONArray) {
        DynamicObjectCollection defSubEntryEntity = dimensionObj.getDynamicObjectCollection("defsubentryentity");
        Map<String, DynamicObject> packagedDefSubEntityData = this.getPackageSubEntityData(defSubEntryEntity, "defcostbizobj.id");
        for (Object costBizObj : selectedCostBizObjInfoJSONArray) {
            HashMap costBizObjMap;
            String costBizId;
            DynamicObject subCostBizObj;
            if (!(costBizObj instanceof HashMap) || (subCostBizObj = packagedDefSubEntityData.get(costBizId = (String)(costBizObjMap = (HashMap)costBizObj).get("costbizid"))) == null) continue;
            costBizObjMap.put("isselected", Boolean.TRUE);
            String defaultValRuleEnt = subCostBizObj.getString("defaultrule");
            costBizObjMap.put("defaultvalruleent", defaultValRuleEnt.isEmpty() ? "" : "...");
            costBizObjMap.put("defaultvalruleentval", defaultValRuleEnt);
        }
    }

    private Map<String, DynamicObject> getPackageSubEntityData(DynamicObjectCollection entryEntity, String key) {
        HashMap<String, DynamicObject> packageSubEntityDataMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject costBizObj : entryEntity) {
            packageSubEntityDataMap.put(costBizObj.getString(key), costBizObj);
        }
        return packageSubEntityDataMap;
    }

    public void initNewDataToCache(JSONObject dimensionRefBizObjCacheJSONObject, IFormView grandParentView, List<String> dimensionIds) {
        if (grandParentView == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = grandParentView.getModel().getEntryEntity("dimensionentry");
        if (dimensionEntry == null || dimensionEntry.isEmpty()) {
            return;
        }
        List<String> costBizObjIdList = this.getCostBizObjIdList(grandParentView);
        if (costBizObjIdList.isEmpty()) {
            return;
        }
        for (String dimensionId : dimensionIds) {
            this.initCostBizObjInfo(dimensionRefBizObjCacheJSONObject, costBizObjIdList, dimensionId);
        }
        IHRAppCache appCache = HRAppCache.get((String)grandParentView.getPageId());
        appCache.put("dimensionCache", (Object)dimensionRefBizObjCacheJSONObject);
    }

    private List<String> getCostBizObjIdList(IFormView view) {
        IHRAppCache appCache = HRAppCache.get((String)view.getPageId());
        ArrayList<String> costBizObjIdList = (ArrayList<String>)appCache.get("costBizObjIdListCache", List.class);
        if (costBizObjIdList == null) {
            DynamicObject[] costBizObjArr;
            costBizObjIdList = new ArrayList<String>(16);
            for (DynamicObject obj : costBizObjArr = CostBasaDataHelper.getCostBizObjList()) {
                costBizObjIdList.add(obj.getString("id"));
            }
            appCache.put("costBizObjIdListCache", costBizObjIdList);
        }
        return costBizObjIdList;
    }

    public boolean validateCostbiz(IFormView view) {
        JSONObject dimensionRefBizObjCacheInfo;
        IHRAppCache appCache = HRAppCache.get((String)view.getPageId());
        JSONObject dimensionRefBizObjCacheInfoMap = dimensionRefBizObjCacheInfo = (JSONObject)appCache.get("dimensionCache", JSONObject.class);
        boolean isNull = true;
        block0: for (Object costBizObjInfo : dimensionRefBizObjCacheInfoMap.values()) {
            ArrayList costBizObjInfoList = (ArrayList)costBizObjInfo;
            if (costBizObjInfoList == null || costBizObjInfoList.isEmpty()) continue;
            for (Object costBizObj : costBizObjInfoList) {
                LinkedHashMap costBizObjMap;
                if (!(costBizObj instanceof LinkedHashMap) || !((Boolean)(costBizObjMap = (LinkedHashMap)costBizObj).get("isselected")).booleanValue()) continue;
                isNull = false;
                continue block0;
            }
        }
        if (isNull) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5728\u6210\u672c\u5bf9\u8c61\u4e0a\u7ef4\u62a4\u542f\u7528\u7684\u7ef4\u5ea6\u3002", (String)"CostStruService_2", (String)"hrmp-lcs-business", (Object[])new Object[0]);
            view.showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    public boolean validateDimension(IFormView view) {
        IHRAppCache appCache = HRAppCache.get((String)view.getPageId());
        JSONObject dimensionRefBizObjCacheInfo = (JSONObject)appCache.get("dimensionCache", JSONObject.class);
        DynamicObjectCollection dimensionEntry = view.getModel().getEntryEntity("dimensionentry");
        StringBuilder dimensionNameBuilder = new StringBuilder();
        for (DynamicObject dimensionObj : dimensionEntry) {
            boolean isRequired = dimensionObj.getBoolean("isrequired");
            String dimensionId = dimensionObj.getString("costdimension.id");
            String dimensionName = dimensionObj.getString("costdimension.name");
            if (!isRequired || dimensionRefBizObjCacheInfo == null) continue;
            ArrayList costBizObjInfoList = (ArrayList)dimensionRefBizObjCacheInfo.get((Object)dimensionId);
            if (costBizObjInfoList == null || costBizObjInfoList.isEmpty()) {
                dimensionNameBuilder.append(dimensionName).append('\uff0c');
                continue;
            }
            boolean isNull = true;
            for (Object costBizObj : costBizObjInfoList) {
                LinkedHashMap costBizObjMap;
                if (!(costBizObj instanceof LinkedHashMap) || !((Boolean)(costBizObjMap = (LinkedHashMap)costBizObj).get("isselected")).booleanValue()) continue;
                isNull = false;
                break;
            }
            if (!isNull) continue;
            dimensionNameBuilder.append(dimensionName).append('\uff0c');
        }
        if (dimensionNameBuilder.length() > 0) {
            String errorMsg = ResManager.loadKDString((String)"%s\u4e3a\u5fc5\u586b\uff0c\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u9002\u914d\u6210\u672c\u5bf9\u8c61\u3002", (String)"CostStruService_1", (String)"hrmp-lcs-business", (Object[])new Object[0]);
            view.showErrorNotification(String.format(Locale.ROOT, errorMsg, dimensionNameBuilder.substring(0, dimensionNameBuilder.length() - 1)));
            return false;
        }
        return true;
    }

    public void packageEntryData(IFormView view) {
        IHRAppCache appCache = HRAppCache.get((String)view.getPageId());
        JSONObject dimensionRefBizObjCacheInfo = (JSONObject)appCache.get("dimensionCache", JSONObject.class);
        if (dimensionRefBizObjCacheInfo == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = view.getModel().getEntryEntity("dimensionentry");
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        int index = 0;
        for (DynamicObject dimensionObj : dimensionEntry) {
            String dimensionId = dimensionObj.getString("costdimension.id");
            model.setEntryCurrentRowIndex("dimensionentry", index++);
            model.deleteEntryData("subentryentity");
            model.deleteEntryData("defsubentryentity");
            ArrayList costBizObjInfoList = (ArrayList)dimensionRefBizObjCacheInfo.get((Object)dimensionId);
            if (costBizObjInfoList == null || costBizObjInfoList.isEmpty()) continue;
            TableValueSetter subEntryEntity = this.getSubEntryEntity(costBizObjInfoList);
            model.batchCreateNewEntryRow("subentryentity", subEntryEntity);
            TableValueSetter defSubEntryEntity = this.getDefSubEntryEntity(costBizObjInfoList);
            model.batchCreateNewEntryRow("defsubentryentity", defSubEntryEntity);
        }
        model.endInit();
        view.updateView("dimensionentry");
        view.updateView("subentryentity");
        view.updateView("defsubentryentity");
    }

    private TableValueSetter getSubEntryEntity(ArrayList costBizObjInfoList) {
        TableValueSetter subEntryEntity = new TableValueSetter(new String[0]);
        subEntryEntity.addField("costbizobj", new Object[0]);
        subEntryEntity.addField("adaptationrule", new Object[0]);
        for (Object obj : costBizObjInfoList) {
            this.addEntryRow(subEntryEntity, obj, "adaptationruleentval");
        }
        return subEntryEntity;
    }

    private TableValueSetter getDefSubEntryEntity(ArrayList costBizObjInfoList) {
        TableValueSetter subEntryEntity = new TableValueSetter(new String[0]);
        subEntryEntity.addField("defcostbizobj", new Object[0]);
        subEntryEntity.addField("defaultrule", new Object[0]);
        for (Object obj : costBizObjInfoList) {
            this.addEntryRow(subEntryEntity, obj, "defaultvalruleentval");
        }
        return subEntryEntity;
    }

    private void addEntryRow(TableValueSetter subEntryEntity, Object obj, String key) {
        if (obj instanceof LinkedHashMap) {
            LinkedHashMap costBizObjInfoMap = (LinkedHashMap)obj;
            Boolean isSelected = (Boolean)costBizObjInfoMap.get("isselected");
            if (!isSelected.booleanValue()) {
                return;
            }
            Object costBizObjId = costBizObjInfoMap.get("costbizid");
            Object adaptationRuleEntVal = costBizObjInfoMap.get(key);
            subEntryEntity.addRow(new Object[]{costBizObjId, adaptationRuleEntVal});
        }
    }
}

