/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.lcs.business.costcenter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.lcs.business.servicehelper.LCSBaseDataHelper;
import org.apache.commons.collections.MapUtils;

public class CostCenterInterfaceHelper {
    private static final Log LOG = LogFactory.getLog(CostCenterInterfaceHelper.class);
    private static final int MAX_COUNT = 10000;
    private static final String KEY_DATA = "data";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static List<String> MUST_INPUT_FIELDS = new ArrayList<String>(10);
    private static Map<String, Integer> FIELD_LENGTH_MAP = new HashMap<String, Integer>(16);

    public Map<String, Object> saveCostCenters(Map<String, Object> param) {
        if (null == param) {
            return param;
        }
        param.put(KEY_SUCCESS, Boolean.TRUE);
        List data = (List)param.get(KEY_DATA);
        if (CollectionUtils.isEmpty((Collection)data)) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "data is empty!");
            return param;
        }
        if (data.size() > 10000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "data size over 10000");
            return param;
        }
        try {
            this.doValidAndSave(data);
        }
        catch (Exception exp) {
            LOG.error((Throwable)exp);
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "Execution failure!");
        }
        return param;
    }

    private void doValidAndSave(List<Map<String, Object>> data) {
        Map<String, Object> queryMap = this.getQueryMap(data);
        List<Map<String, Object>> successList = this.getCheckPassData(data, queryMap);
        this.doSave(successList, queryMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave(List<Map<String, Object>> params, Map<String, Object> queryMap) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        Map orgMap = (Map)queryMap.get("org");
        Map costCenterMap = (Map)queryMap.get("costCenter");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("lcs_costcenter");
        ArrayList<DynamicObject> waitSaveList = new ArrayList<DynamicObject>(params.size());
        ArrayList<DynamicObject> waitUpdateList = new ArrayList<DynamicObject>(10);
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)helper.getEntityName()).getFields();
        for (Map<String, Object> record : params) {
            record.put(KEY_SUCCESS, Boolean.TRUE);
            String operateType = MapUtils.getString(record, (Object)"operate");
            if ("1".equals(operateType)) {
                waitSaveList.add(this.assembleCostCenter(record, (DynamicObject)orgMap.get(MapUtils.getLong(record, (Object)"org")), (DynamicObject)costCenterMap.get(MapUtils.getString(record, (Object)"parent")), helper));
                continue;
            }
            if (!"2".equals(operateType)) continue;
            DynamicObject updateDy = (DynamicObject)costCenterMap.get(MapUtils.getString(record, (Object)"number"));
            for (Map.Entry prop : fieldProps.entrySet()) {
                if (!record.containsKey(prop.getKey())) continue;
                if (!record.containsKey("parent")) {
                    updateDy.set((String)prop.getKey(), record.get(prop.getKey()));
                    continue;
                }
                updateDy.set((String)prop.getKey(), costCenterMap.get(MapUtils.getString(record, prop.getKey())));
            }
            waitUpdateList.add(updateDy);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.executeOp("save", waitSaveList);
            this.executeOp("save", waitUpdateList);
            txHandle.commit();
        }
    }

    public void executeOp(String opKey, List<DynamicObject> dataEntities) {
        if (CollectionUtils.isEmpty(dataEntities)) {
            return;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isinterface", "true");
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        OperationResult operationResult = opImpl.localInvokeOperation(opKey, dataEntities.toArray(new DynamicObject[0]), operateOption);
        if (!operationResult.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder(operationResult.getMessage());
            if (operationResult.getAllErrorOrValidateInfo() != null) {
                for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                    errorMsg.append(operateInfo.getMessage());
                }
            }
            throw new KDBizException(errorMsg.toString());
        }
    }

    private Map<String, Object> getQueryMap(List<Map<String, Object>> data) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        HashSet<String> numberSet = new HashSet<String>(data.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        ArrayList<Long> costCenterIds = new ArrayList<Long>(data.size());
        for (Map<String, Object> record : data) {
            numberSet.add(MapUtils.getString(record, (Object)"number"));
            numberSet.add(MapUtils.getString(record, (Object)"parent"));
            orgIdSet.add(MapUtils.getLong(record, (Object)"org"));
            costCenterIds.add(MapUtils.getLong(record, (Object)"id"));
        }
        Map<Long, DynamicObject> orgMap = this.getOrgMap(orgIdSet);
        Map<String, DynamicObject> costCenterMap = this.getCostCenterMap(numberSet, costCenterIds);
        queryMap.put("org", orgMap);
        queryMap.put("costCenter", costCenterMap);
        return queryMap;
    }

    private List<Map<String, Object>> getCheckPassData(List<Map<String, Object>> data, Map<String, Object> queryMap) {
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(data.size());
        Map costCenterMap = (Map)queryMap.get("costCenter");
        Set<Long> existsIds = costCenterMap.entrySet().stream().map(entry -> ((DynamicObject)entry.getValue()).getLong("id")).collect(Collectors.toSet());
        HashSet<String> addTypeNums = new HashSet<String>(data.size());
        for (Map<String, Object> record : data) {
            if (!this.checkMustInput(record) || !this.checkLength(record) || !this.checkValueLegal(record, queryMap, addTypeNums, existsIds)) continue;
            successList.add(record);
        }
        return successList;
    }

    private Map<Long, DynamicObject> getOrgMap(Set<Long> orgIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
        QFilter filter = new QFilter("id", "in", orgIds);
        DynamicObject[] orgArr = helper.query("id, number, name", new QFilter[]{filter});
        Map<Long, DynamicObject> orgMap = Arrays.stream(orgArr).collect(Collectors.toMap(org -> org.getLong("id"), org -> org, (k1, k2) -> k1));
        return orgMap;
    }

    private Map<String, DynamicObject> getCostCenterMap(Set<String> numberSet, List<Long> costCenterIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("lcs_costcenter");
        QFilter filter = new QFilter("number", "in", numberSet);
        if (!CollectionUtils.isEmpty(costCenterIds)) {
            filter.or("id", "in", costCenterIds);
        }
        DynamicObject[] costCenterArr = helper.query(LCSBaseDataHelper.getSelectProperties("lcs_costcenter"), new QFilter[]{filter});
        Map<String, DynamicObject> costCenterMap = Arrays.stream(costCenterArr).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (k1, k2) -> k1));
        return costCenterMap;
    }

    private boolean checkMustInput(Map<String, Object> record) {
        ArrayList<String> notPassFields = new ArrayList<String>(10);
        boolean isPass = true;
        for (String field : MUST_INPUT_FIELDS) {
            if (!HRObjectUtils.isEmpty((Object)record.get(field))) continue;
            isPass = false;
            notPassFields.add(field);
        }
        if (!isPass) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010{0}\u3011\u5fc5\u586b\u3002", (String)"CostCenterInterfaceHelper_0", (String)"hrmp-lcs-business", (Object[])new Object[0]), notPassFields.stream().collect(Collectors.joining(",")));
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, message);
        }
        return isPass;
    }

    private boolean checkLength(Map<String, Object> record) {
        ArrayList<String> notPassFields = new ArrayList<String>(10);
        boolean isPass = true;
        for (Map.Entry<String, Integer> entry : FIELD_LENGTH_MAP.entrySet()) {
            String strValue;
            Object value = record.get(entry.getKey());
            if (!(value instanceof String) || !HRStringUtils.isNotEmpty((String)(strValue = (String)value)) || strValue.length() <= entry.getValue()) continue;
            isPass = false;
            notPassFields.add(entry.getKey());
        }
        if (!isPass) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010{0}\u3011\u8d85\u957f\u3002", (String)"CostCenterInterfaceHelper_1", (String)"hrmp-lcs-business", (Object[])new Object[0]), notPassFields.stream().collect(Collectors.joining(",")));
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, message);
        }
        return isPass;
    }

    private boolean checkValueLegal(Map<String, Object> record, Map<String, Object> queryMap, Set<String> addTypeNums, Set<Long> existsIds) {
        boolean pkIdNonNull;
        Map orgMap = (Map)queryMap.get("org");
        Map costCenterMap = (Map)queryMap.get("costCenter");
        Long orgId = MapUtils.getLong(record, (Object)"org");
        String number = MapUtils.getString(record, (Object)"number");
        String parentNumber = MapUtils.getString(record, (Object)"parent");
        String operateType = MapUtils.getString(record, (Object)"operate");
        Long id = MapUtils.getLong(record, (Object)"id");
        boolean bl = pkIdNonNull = id != null && id != 0L;
        if (!orgMap.containsKey(orgId)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CostCenterInterfaceHelper_2", (String)"hrmp-lcs-business", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)parentNumber) && !costCenterMap.containsKey(parentNumber)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u3002", (String)"CostCenterInterfaceHelper_3", (String)"hrmp-lcs-business", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.equals((String)number, (String)parentNumber)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u672c\u4e2d\u5fc3\u4e0d\u5141\u8bb8\u662f\u5f53\u524d\u6570\u636e\u672c\u8eab\u3002", (String)"CostCenterInterfaceHelper_4", (String)"hrmp-lcs-business", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(operateType)) {
            if (costCenterMap.containsKey(number) || addTypeNums.contains(number)) {
                record.put(KEY_SUCCESS, Boolean.FALSE);
                record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c{0}\u201d\u5df2\u5b58\u5728\u3002", (String)"CostCenterInterfaceHelper_5", (String)"hrmp-lcs-business", (Object[])new Object[0]), number));
                return false;
            }
            if (pkIdNonNull && existsIds.contains(id)) {
                record.put(KEY_SUCCESS, Boolean.FALSE);
                record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u4e3b\u952e\u5df2\u5b58\u5728\u3002", (String)"CostCenterInterfaceHelper_8", (String)"hrmp-lcs-business", (Object[])new Object[0]), number));
                return false;
            }
        } else if ("2".equals(operateType)) {
            DynamicObject costCenter = (DynamicObject)costCenterMap.get(number);
            if (HRObjectUtils.isEmpty((Object)costCenter) || !orgId.equals(costCenter.getLong("createorg.id"))) {
                record.put(KEY_SUCCESS, Boolean.FALSE);
                record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u4e0e\u201c\u7f16\u7801\u201d\u5339\u914d\u5230\u552f\u4e00\u6570\u636e\u3002", (String)"CostCenterInterfaceHelper_6", (String)"hrmp-lcs-business", (Object[])new Object[0]));
                return false;
            }
        } else {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u201coperate\u201d\u4e0d\u6b63\u786e\u3002", (String)"CostCenterInterfaceHelper_7", (String)"hrmp-lcs-business", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(operateType)) {
            addTypeNums.add(number);
            if (pkIdNonNull) {
                existsIds.add(id);
            }
        }
        return true;
    }

    private DynamicObject assembleCostCenter(Map<String, Object> record, DynamicObject org, DynamicObject parent, HRBaseServiceHelper helper) {
        String enable;
        DynamicObject costCenter = helper.generateEmptyDynamicObject();
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)helper.getEntityName()).getFields();
        for (Map.Entry prop : fieldProps.entrySet()) {
            if (!record.containsKey(prop.getKey())) continue;
            costCenter.set((String)prop.getKey(), record.get(prop.getKey()));
        }
        Long id = MapUtils.getLong(record, (Object)"id");
        if (!HRObjectUtils.isEmpty((Object)id)) {
            costCenter.set("id", (Object)id);
        }
        if (HRStringUtils.isEmpty((String)(enable = MapUtils.getString(record, (Object)"enable")))) {
            enable = "1";
        }
        costCenter.set("enable", (Object)enable);
        costCenter.set("parent", (Object)parent);
        costCenter.set("createorg", (Object)org);
        return costCenter;
    }

    private static /* synthetic */ void lambda$doSave$0(Map item) {
        item.put(KEY_SUCCESS, Boolean.FALSE);
        item.put(KEY_MESSAGE, "save costCenter error");
    }

    static {
        MUST_INPUT_FIELDS.add("operate");
        MUST_INPUT_FIELDS.add("number");
        MUST_INPUT_FIELDS.add("name");
        MUST_INPUT_FIELDS.add("org");
        FIELD_LENGTH_MAP.put("number", 60);
        FIELD_LENGTH_MAP.put("name", 100);
        FIELD_LENGTH_MAP.put("parent", 60);
        FIELD_LENGTH_MAP.put("description", 255);
    }
}

